/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.swing.voronoi;

import com.treemap.swing.voronoi.VoronoiRandom;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;

public class StoredRandom
implements VoronoiRandom {
    private double[] randoms;
    int pointer = 0;

    public StoredRandom(int seed, int nValues) {
        String path = "Randoms_seed_" + seed + "_" + nValues + "_values.doubleArray";
        File file = new File(path);
        if (!file.exists()) {
            try {
                Random random = new Random(seed);
                this.randoms = new double[nValues];
                for (int n = 0; n < nValues; ++n) {
                    this.randoms[n] = random.nextDouble();
                }
                FileOutputStream fos = new FileOutputStream(file);
                ObjectOutputStream out = new ObjectOutputStream(fos);
                out.writeObject(this.randoms);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                FileInputStream fis = new FileInputStream(file);
                ObjectInputStream in = new ObjectInputStream(fis);
                this.randoms = (double[])in.readObject();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public double nextDouble() {
        double random = this.randoms[this.pointer];
        ++this.pointer;
        this.pointer %= this.randoms.length;
        return random;
    }

    @Override
    public void reset() {
        this.pointer = 0;
    }
}

