/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.propertytable.table;

import de.javasoft.propertytable.table.PropertyTableModel;
import java.util.ArrayList;
import javax.swing.UIManager;

public class DefaultPropertyTableModel
extends PropertyTableModel {
    private static final long serialVersionUID = 92589018500656650L;
    private ArrayList<Object> keyList = new ArrayList();
    private ArrayList<Object> valueList = new ArrayList();

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return Object.class;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return UIManager.getString("JYPropertyTable.key.text");
        }
        return UIManager.getString("JYPropertyTable.value.text");
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column == 0) {
            if (row < this.keyList.size()) {
                this.keyList.remove(row);
                this.keyList.add(row, value);
            } else {
                this.keyList.add(value);
            }
        } else if (row < this.valueList.size()) {
            this.valueList.remove(row);
            this.valueList.add(row, value);
        } else {
            this.valueList.add(value);
        }
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            return this.keyList.get(row);
        }
        return this.valueList.get(row);
    }

    @Override
    public int getRowCount() {
        return this.keyList.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public void setProperty(int row, Object key, Object value) {
        this.setValueAt(key, row, 0);
        this.setValueAt(value, row, 1);
    }

    @Override
    public Object getPropertyKey(int row) {
        return this.getValueAt(row, 0);
    }

    @Override
    public Object getPropertyValue(int row) {
        return this.getValueAt(row, 1);
    }

    @Override
    public void removeProperty(int row) {
        this.keyList.remove(row);
        this.valueList.remove(row);
    }

    public void addProperty(Object key, Object value) {
        this.setProperty(this.getRowCount(), key, value);
    }

    public void removeProperty(Object key) {
        this.removeProperty(this.getPropertyRow(key));
    }

    @Override
    public int getPropertyRow(Object key) {
        return this.keyList.indexOf(key);
    }
}

