/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.tabpane.ui.controls;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.tabpane.JYTabbedPane;
import de.javasoft.tabpane.ui.BasicJYTabbedPaneUI;
import de.javasoft.tabpane.ui.controls.IButtonFactory;
import de.javasoft.tabpane.ui.controls.TabOverviewDialog;
import de.javasoft.tabpane.ui.painter.JYTabbedPanePainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class TabOverviewPreviewPanel
extends JPanel {
    private JYTabbedPane tabPane;
    private int tabIndex;
    private JLabel titleLabel;
    private BufferedImage previewImage;
    private int preferredImageWidth;
    private int preferredImageHeight;
    private boolean hover;

    public TabOverviewPreviewPanel(final JYTabbedPane tabPane, int tabIndex, IButtonFactory buttonFactory) {
        this.tabPane = tabPane;
        this.tabIndex = tabIndex;
        this.setName("JYTabbedPane.TabOverviewPreviewPanel");
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(TabOverviewPreviewPanel.getPreviewPanelInsets(tabPane)));
        this.titleLabel = new JLabel(tabPane.getTitleAt(tabIndex));
        this.titleLabel.setName("JYTabbedPane.TabOverviewPreviewTitle");
        this.titleLabel.setIcon(tabPane.getIconAt(tabIndex));
        this.updateTitleDefaults();
        JPanel titlePane = new JPanel(new BorderLayout());
        titlePane.setName("JYTabbedPane.TabOverviewPreviewTitlePanel");
        titlePane.setOpaque(false);
        titlePane.add(this.titleLabel);
        titlePane.setMinimumSize(new Dimension());
        titlePane.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(SyntheticaLookAndFeel.getInsets((String)"JYTabbedPane.tabOverview.previewTitlePane.insets", (Component)tabPane, (Insets)new Insets(0, 2, 1, 2), (boolean)true), false));
        Action a = ((BasicJYTabbedPaneUI)tabPane.getUI()).getTabsPanel().getTab(tabIndex).getCloseButton().getAction();
        AbstractButton closeButton = buttonFactory.createTabOverviewPreviewCloseButton(tabPane, tabIndex, a);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (tabPane.getTabCount() == 1 || SyntheticaLookAndFeel.getBoolean((String)"JYTabbedPane.tabOverview.closeDialogOnPreviewClose", (Component)tabPane, (boolean)false)) {
                    TabOverviewPreviewPanel.this.closeDialog();
                } else {
                    final TabOverviewDialog dialog = (TabOverviewDialog)SwingUtilities.getWindowAncestor(TabOverviewPreviewPanel.this);
                    final Rectangle screenBounds = dialog.getPreviewDialogScreenBounds(tabPane);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dialog.installOverviewPanel(screenBounds);
                        }
                    });
                }
            }
        });
        titlePane.add((Component)closeButton, "After");
        JPanel imagePanel = new JPanel(null){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (TabOverviewPreviewPanel.this.previewImage != null) {
                    g.drawImage(TabOverviewPreviewPanel.this.previewImage, 0, 0, this.getWidth(), this.getHeight(), null);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(TabOverviewPreviewPanel.this.preferredImageWidth, TabOverviewPreviewPanel.this.preferredImageHeight);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        imagePanel.setName("JYTabbedPane.TabOverviewPreviewImagePanel");
        if (tabPane.isEnabledAt(tabIndex)) {
            this.addMouseListener(new PreviewPanelMouseHandler());
        }
        this.add((Component)titlePane, "North");
        this.add(imagePanel);
        this.applyComponentOrientation(tabPane.getComponentOrientation());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        JYTabbedPanePainter.getInstance().paintTabOverviewPreviewPanel(this.tabPane, this, this.getState(), this.tabIndex, g, 0, 0, this.getWidth(), this.getHeight());
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public JYTabbedPane getTabbedPane() {
        return this.tabPane;
    }

    static Insets getPreviewPanelInsets(JTabbedPane tabPane) {
        return SyntheticaLookAndFeel.getInsets((String)"JYTabbedPane.tabOverview.previewPanel.insets", (Component)tabPane, (Insets)new Insets(2, 2, 2, 2), (boolean)true);
    }

    public void setPreviewImage(BufferedImage previewImage, int preferredImageWidth, int preferredImageHeight) {
        this.previewImage = previewImage;
        this.preferredImageWidth = preferredImageWidth;
        this.preferredImageHeight = preferredImageHeight;
        this.revalidate();
        this.repaint();
    }

    public BufferedImage getPreviewImage() {
        return this.previewImage;
    }

    public void closeDialog() {
        TabOverviewDialog dialog = (TabOverviewDialog)SwingUtilities.getAncestorOfClass(TabOverviewDialog.class, this);
        dialog.dispose();
    }

    public SyntheticaState getState() {
        SyntheticaState state = new SyntheticaState(this.tabIndex == this.tabPane.getSelectedIndex() ? SyntheticaState.State.SELECTED : SyntheticaState.State.UNDEFINED);
        if (this.tabIndex > 0 && this.tabIndex < this.tabPane.getTabCount() && !this.tabPane.isEnabledAt(this.tabIndex)) {
            state.setState(SyntheticaState.State.DISABLED);
        }
        if (this.hover) {
            state.setState(SyntheticaState.State.HOVER);
        }
        return state;
    }

    private void updateTitleDefaults() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof SyntheticaLookAndFeel) {
            SyntheticaState state = this.getState();
            SynthStyle ss = SyntheticaLookAndFeel.getStyle((JComponent)this.titleLabel, (Region)Region.LABEL);
            SynthContext sc = new SynthContext(this.titleLabel, Region.LABEL, ss, state.getState());
            this.titleLabel.setForeground(new Color(ss.getColor(sc, ColorType.TEXT_FOREGROUND).getRGB()));
            Font syntheticaFont = SyntheticaLookAndFeel.getFont();
            Font styleFont = ss.getFont(sc);
            boolean enabled = SyntheticaLookAndFeel.getBoolean((String)"Synthetica.font.enabled", (Component)this.titleLabel, (boolean)true);
            this.titleLabel.setFont(enabled ? new Font(syntheticaFont.getFamily(), styleFont.getStyle(), syntheticaFont.getSize()) : styleFont);
        }
    }

    private class PreviewPanelMouseHandler
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent evt) {
            TabOverviewPreviewPanel.this.closeDialog();
            TabOverviewPreviewPanel.this.tabPane.setSelectedIndex(TabOverviewPreviewPanel.this.tabIndex, true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TabOverviewPreviewPanel.this.hover = true;
            TabOverviewPreviewPanel.this.updateTitleDefaults();
            TabOverviewPreviewPanel.this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TabOverviewPreviewPanel.this.hover = false;
            TabOverviewPreviewPanel.this.updateTitleDefaults();
            TabOverviewPreviewPanel.this.repaint();
        }
    }
}

