/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.widgets;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.widgets.JYButtonIcon;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.synth.SynthContext;

public class JYScrollPaneMap
extends JButton {
    private JScrollPane scroller;
    private JComponent view;
    private Icon icon;
    private JPopupMenu popupMenu;
    private PopupContent popupContent;
    private BufferedImage previewImage;
    private Rectangle startRect;
    private Rectangle previewRect;
    private Point startPoint;
    private Point oldPoint;
    private double scaleFactor;
    private MouseHandler mouseHandler;
    private PropertyChangeListener propertyChangeListener;
    private ContainerAdapter viewPortViewListener;

    public JYScrollPaneMap(JScrollPane scrollPane) {
        this.scroller = scrollPane;
        this.view = this.getView(this.scroller);
        this.setFocusable(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setName("JYScrollPaneMap");
        this.install();
    }

    private JComponent getView(JScrollPane scroller) {
        Component c = scroller.getViewport().getView();
        return c instanceof JComponent ? (JComponent)c : null;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public Icon getDisabledIcon() {
        return this.getIcon();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setDefaults();
    }

    protected void setDefaults() {
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"JYScrollPaneMap.insets", (Component)this, (Insets)new Insets(2, 2, 0, 0), (boolean)true);
        this.setBorder(new WidgetUtils.OrientationAwareEmptyBorderUIResource(insets));
        this.icon = this.createIcon();
    }

    protected Icon createIcon() {
        String key = "JYScrollPaneMap.icon";
        return new JYButtonIcon(this, key, 12, 12){

            @Override
            public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
                g2.setPaint(JYScrollPaneMap.this.getIconPaintColor(state));
                GeneralPath path = new GeneralPath();
                path.moveTo(1.0f, 1.0f);
                path.lineTo(10.0f, 1.0f);
                path.lineTo(10.0f, 10.0f);
                path.lineTo(1.0f, 10.0f);
                path.lineTo(1.0f, 1.0f);
                path.moveTo(3.0f, 4.0f);
                path.lineTo(8.0f, 4.0f);
                path.lineTo(8.0f, 7.0f);
                path.lineTo(3.0f, 7.0f);
                path.closePath();
                g2.draw(path);
            }

            protected BasicStroke createStroke(SynthContext sc) {
                return new BasicStroke(1.2f);
            }
        };
    }

    private Color getIconPaintColor(SyntheticaState state) {
        Color color = UIManager.getColor("Label.foreground");
        if (state.isSet(SyntheticaState.State.DISABLED)) {
            color = new Color(0xAAAAAA);
        } else if (!state.isSet(SyntheticaState.State.PRESSED) && state.isSet(SyntheticaState.State.HOVER)) {
            int rgb = 0xAA000000 | color.getRGB() & 0xFFFFFF;
            color = new Color(rgb, true);
        }
        return color;
    }

    private void install() {
        this.mouseHandler = new MouseHandler();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("componentOrientation".equals(name)) {
                    JYScrollPaneMap.this.scroller.setCorner("LOWER_LEADING_CORNER", null);
                    JYScrollPaneMap.this.scroller = (JScrollPane)evt.getSource();
                    JYScrollPaneMap.this.view = JYScrollPaneMap.this.getView(JYScrollPaneMap.this.scroller);
                    JYScrollPaneMap.this.install();
                    JYScrollPaneMap.this.scroller.setCorner("LOWER_TRAILING_CORNER", JYScrollPaneMap.this);
                } else if ("LOWER_RIGHT_CORNER".equals(name) || "LOWER_LEFT_CORNER".equals(name)) {
                    Object oldVal = evt.getOldValue();
                    Object newVal = evt.getNewValue();
                    if (oldVal == JYScrollPaneMap.this && newVal != JYScrollPaneMap.this) {
                        JYScrollPaneMap.this.uninstall();
                    }
                }
            }
        };
        this.scroller.addPropertyChangeListener(this.propertyChangeListener);
        this.viewPortViewListener = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent evt) {
                if (JYScrollPaneMap.this.popupMenu.isVisible()) {
                    JYScrollPaneMap.this.popupMenu.setVisible(false);
                }
                JYScrollPaneMap.this.view = JYScrollPaneMap.this.getView(JYScrollPaneMap.this.scroller);
            }
        };
        this.scroller.getViewport().addContainerListener(this.viewPortViewListener);
        this.popupMenu = new JPopupMenu();
        this.popupMenu.setName("JYScrollPaneMap.popup");
        this.popupMenu.setLayout(new BorderLayout());
        this.popupContent = new PopupContent();
        this.popupMenu.add((Component)this.popupContent, "Center");
        this.popupMenu.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName()) && !JYScrollPaneMap.this.popupMenu.isVisible()) {
                    JYScrollPaneMap.this.popupMenu.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    private void uninstall() {
        if (this.popupMenu.isVisible()) {
            this.popupMenu.setVisible(false);
        }
        this.removeMouseListener(this.mouseHandler);
        this.removeMouseMotionListener(this.mouseHandler);
        this.scroller.removePropertyChangeListener(this.propertyChangeListener);
        this.scroller.getViewport().removeContainerListener(this.viewPortViewListener);
        this.scroller = null;
        this.view = null;
    }

    private void showPopup(Point p) {
        if (this.view == null) {
            return;
        }
        Dimension pDimension = this.getPreviewSize(this.view.getParent());
        double compWidth = this.view.getWidth();
        double compHeight = this.view.getHeight();
        double scaleX = pDimension.getWidth() / compWidth;
        double scaleY = pDimension.getHeight() / compHeight;
        this.scaleFactor = Math.min(scaleX, scaleY);
        this.previewImage = WidgetUtils.createPreviewImage(this.view, this.scaleFactor, true);
        this.startRect = this.view.getVisibleRect();
        Insets insets = this.popupContent.getInsets();
        this.startRect.x = (int)(this.scaleFactor * (double)this.startRect.x + (double)insets.left);
        this.startRect.y = (int)(this.scaleFactor * (double)this.startRect.y + (double)insets.right);
        this.startRect.width = (int)((double)this.startRect.width * this.scaleFactor);
        this.startRect.height = (int)((double)this.startRect.height * this.scaleFactor);
        this.previewRect = this.startRect;
        Dimension pref = this.popupMenu.getPreferredSize();
        Point buttonScreenLocation = this.getLocationOnScreen();
        Point popupLocation = new Point((this.getWidth() - pref.width) / 2, (this.getHeight() - pref.height) / 2);
        this.popupMenu.show(this, popupLocation.x, popupLocation.y);
        Window w = SwingUtilities.getWindowAncestor(this.popupMenu);
        if (w.getClass().getName().endsWith(".Popup$HeavyWeightWindow")) {
            Point popupScreenLocation = w.getLocation();
            popupLocation = new Point(popupScreenLocation.x - buttonScreenLocation.x, popupScreenLocation.y - buttonScreenLocation.y);
        } else {
            popupLocation = SwingUtilities.convertPoint(this.popupMenu, new Point(0, 0), this);
        }
        Point centerPoint = new Point(buttonScreenLocation.x + popupLocation.x + this.previewRect.x + this.previewRect.width / 2, buttonScreenLocation.y + popupLocation.y + this.previewRect.y + this.previewRect.height / 2);
        try {
            new Robot().mouseMove(centerPoint.x, centerPoint.y);
            this.startPoint = centerPoint;
        }
        catch (Exception e) {
            this.startPoint = p;
            popupLocation.x += this.startPoint.x - centerPoint.x;
            popupLocation.y += this.startPoint.y - centerPoint.y;
            this.popupMenu.show(this, popupLocation.x, popupLocation.y);
        }
        this.oldPoint = new Point(this.startPoint);
        this.popupMenu.setCursor(Cursor.getPredefinedCursor(13));
    }

    private Dimension getPreviewSize(Container parent) {
        Dimension dim = SyntheticaLookAndFeel.getDim((String)"JYScrollPaneMap.minPreviewSize", (Component)this, (Dimension)new Dimension(140, 70), (boolean)true);
        if (parent instanceof JViewport) {
            Dimension maxSize = SyntheticaLookAndFeel.getDim((String)"JYScrollPaneMap.maxPreviewSize", (Component)this, (Dimension)new Dimension(300, 200), (boolean)true);
            Rectangle viewportRect = ((JViewport)parent).getViewRect();
            int width = Math.max(Math.min(viewportRect.width / 3, maxSize.width), dim.width);
            int height = Math.max(Math.min(viewportRect.height / 3, maxSize.height), dim.height);
            return new Dimension(width, height);
        }
        return dim;
    }

    private void scroll(int aDeltaX, int aDeltaY) {
        if (this.view == null) {
            return;
        }
        Rectangle oldRectangle = this.view.getVisibleRect();
        Rectangle newRectangle = new Rectangle(oldRectangle.x + aDeltaX, oldRectangle.y + aDeltaY, oldRectangle.width, oldRectangle.height);
        this.view.scrollRectToVisible(newRectangle);
        this.syncRectangle();
    }

    private void syncRectangle() {
        JViewport viewport = this.scroller.getViewport();
        Rectangle viewRect = viewport.getViewRect();
        Insets insets = this.popupContent.getInsets();
        Rectangle newRect = new Rectangle();
        newRect.x = (int)(this.scaleFactor * (double)viewRect.x + (double)insets.left);
        newRect.y = (int)(this.scaleFactor * (double)viewRect.y + (double)insets.top);
        newRect.width = (int)((double)viewRect.width * this.scaleFactor);
        newRect.height = (int)((double)viewRect.height * this.scaleFactor);
        Rectangle clip = new Rectangle();
        Rectangle.union(this.previewRect, newRect, clip);
        clip.grow(2, 2);
        this.previewRect = newRect;
        this.popupContent.paintImmediately(clip);
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            Point p = evt.getPoint();
            SwingUtilities.convertPointToScreen(p, JYScrollPaneMap.this);
            JYScrollPaneMap.this.showPopup(p);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (!JYScrollPaneMap.this.popupMenu.isVisible()) {
                return;
            }
            JYScrollPaneMap.this.popupMenu.setVisible(false);
            JYScrollPaneMap.this.startRect = JYScrollPaneMap.this.previewRect;
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (JYScrollPaneMap.this.startPoint == null || !JYScrollPaneMap.this.popupMenu.isShowing()) {
                return;
            }
            Point newPoint = evt.getPoint();
            SwingUtilities.convertPointToScreen(newPoint, (Component)evt.getSource());
            Rectangle popupScreenRect = new Rectangle(JYScrollPaneMap.this.popupMenu.getLocationOnScreen(), JYScrollPaneMap.this.popupMenu.getSize());
            if (!popupScreenRect.contains(newPoint)) {
                return;
            }
            int deltaX = (int)((double)(newPoint.x - ((JYScrollPaneMap)JYScrollPaneMap.this).oldPoint.x) / JYScrollPaneMap.this.scaleFactor);
            int deltaY = (int)((double)(newPoint.y - ((JYScrollPaneMap)JYScrollPaneMap.this).oldPoint.y) / JYScrollPaneMap.this.scaleFactor);
            JYScrollPaneMap.this.scroll(deltaX, deltaY);
            JYScrollPaneMap.this.oldPoint = newPoint;
        }
    }

    private class PopupContent
    extends JComponent {
        private PopupContent() {
        }

        @Override
        public Dimension getPreferredSize() {
            if (JYScrollPaneMap.this.previewImage == null || JYScrollPaneMap.this.previewRect == null) {
                return new Dimension();
            }
            Insets insets = this.getInsets();
            return new Dimension(JYScrollPaneMap.this.previewImage.getWidth(null) + insets.left + insets.right, JYScrollPaneMap.this.previewImage.getHeight(null) + insets.top + insets.bottom);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (JYScrollPaneMap.this.previewImage == null || JYScrollPaneMap.this.previewRect == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            Insets insets = this.getInsets();
            int xOffset = insets.left;
            int yOffset = insets.top;
            int availableWidth = this.getWidth() - insets.left - insets.right;
            int availableHeight = this.getHeight() - insets.top - insets.bottom;
            g2.drawImage((Image)JYScrollPaneMap.this.previewImage, xOffset, yOffset, null);
            Area area = new Area(new Rectangle(xOffset, yOffset, availableWidth, availableHeight));
            area.subtract(new Area(JYScrollPaneMap.this.previewRect));
            g2.setColor(SyntheticaLookAndFeel.getColor((String)"JYScrollPaneMap.previewRect.background", (Component)JYScrollPaneMap.this, (Color)new Color(-2134061876, true)));
            g2.fill(area);
            g2.setColor(SyntheticaLookAndFeel.getColor((String)"JYScrollPaneMap.previewRect.foreground", (Component)JYScrollPaneMap.this, (Color)UIManager.getColor("Label.foreground")));
            g2.draw(JYScrollPaneMap.this.previewRect);
            g2.dispose();
        }
    }
}

