/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.xmenu.ui.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.SynthContext;

public class XMenuPainter
extends SyntheticaComponentPainter {
    public static final String XMENU_PAINTER = "Synthetica.XMenuPainter";

    public static XMenuPainter getInstance() {
        return XMenuPainter.getInstance(null);
    }

    public static XMenuPainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(XMenuPainter.getPainterClassName((SynthContext)sc, XMenuPainter.class, (String)XMENU_PAINTER));
        if (instance == null) {
            instance = XMenuPainter.getInstance((SynthContext)sc, XMenuPainter.class, (String)XMENU_PAINTER);
        }
        return (XMenuPainter)instance;
    }

    public void paintBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        UIKey key = new UIKey("", state, this.isFirstMenu(c) ? "XMenu.first" : "XMenu");
        String imagePath = UIKey.resolveImagePath((JComponent)c, (String)key.get(), (String)"background.image", (int)1);
        if (imagePath != null && SyntheticaLookAndFeel.isOpaque((JComponent)c)) {
            Insets sInsets;
            int cycles = SyntheticaLookAndFeel.getInt((String)key.get("animation.cycles"), (Component)c, (int)1);
            int delay = SyntheticaLookAndFeel.getInt((String)key.get("animation.delay"), (Component)c, (int)50);
            int type = SyntheticaLookAndFeel.getInt((String)key.get("animation.type"), (Component)c, (int)(state.isSet(SyntheticaState.State.HOVER) ? 1 : 2));
            Insets dInsets = sInsets = this.getImageInsets("XMenu.background.image.insets", c);
            ImagePainter imagePainter = new ImagePainter(c, null, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0, !c.getComponentOrientation().isLeftToRight(), false);
            imagePainter.draw();
        }
    }

    public void paintContentPaneBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        UIKey key = new UIKey("contentPane", state, "XMenu.");
        String imagePath = UIKey.resolveImagePath((JComponent)c, (String)key.get(), (String)"background.image", (int)0);
        if (imagePath != null) {
            Insets sInsets;
            Insets dInsets = sInsets = this.getImageInsets("XMenu.contentPane.background.image.insets", c);
            ImagePainter imagePainter = new ImagePainter(c, null, -1, -1, -1, -1, g, x, y, w, h, imagePath, sInsets, dInsets, 1, 0, !c.getComponentOrientation().isLeftToRight(), false);
            imagePainter.draw();
        }
    }

    public void paintButtonBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        UIKey key = new UIKey("button", state, "XMenu.");
        String imagePath = UIKey.resolveImagePath((JComponent)c, (String)key.get(), (String)"background.image", (int)0);
        if (imagePath != null) {
            Insets sInsets;
            Insets dInsets = sInsets = this.getImageInsets("XMenu.button.background.image.insets", c);
            ImagePainter imagePainter = new ImagePainter(c, null, -1, -1, -1, -1, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0, !c.getComponentOrientation().isLeftToRight(), false);
            imagePainter.draw();
        }
    }

    public void paintSeparator(JComponent c, boolean isSubMenu, Graphics g, int x, int y, int w, int h) {
        Insets margin = SyntheticaLookAndFeel.getInsets((String)(isSubMenu ? "XSubmenuSeparator.margin" : "XMenuSeparator.margin"), (Component)c, (boolean)false, (boolean)true);
        x += margin.left;
        y += margin.top;
        w += -margin.left - margin.right;
        h += -margin.top - margin.bottom;
        String imagePath = isSubMenu ? "XSubmenuSeparator.image" : "XMenuSeparator.image";
        if ((imagePath = this.resolveImagePath(imagePath, c)) != null) {
            Insets insets = SyntheticaLookAndFeel.getInsets((String)(isSubMenu ? "XSubmenuSeparator.image.insets" : "XMenuSeparator.image.insets"), (Component)c, (boolean)false);
            ImagePainter imagePainter = new ImagePainter(c, g, x, y, w, h, imagePath, insets, insets, 0, 0);
            imagePainter.draw();
        } else {
            Color foreground = c.getForeground();
            if (foreground instanceof ColorUIResource) {
                foreground = SyntheticaLookAndFeel.getColor((String)"XMenuSeparator.foreground", (Component)c, (Color)foreground);
                if (isSubMenu) {
                    foreground = SyntheticaLookAndFeel.getColor((String)"XSubmenuSeparator.foreground", (Component)c, (Color)foreground);
                }
            }
            g.setColor(foreground);
            g.fillRect(x, y, w, h);
        }
    }

    protected boolean isFirstMenu(JComponent c) {
        int count;
        Container parent = c.getParent();
        int n = count = parent == null ? 0 : parent.getComponentCount();
        return count > 0 && parent.getComponent(0) == c;
    }

    protected boolean isLastMenu(JComponent c) {
        int count;
        Container parent = c.getParent();
        int n = count = parent == null ? 0 : parent.getComponentCount();
        return count > 0 && parent.getComponent(count - 1) == c;
    }
}

