/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.beans.actions.net.DigestAlgorithm;
import com.install4j.runtime.beans.actions.net.DownloadAction;
import com.install4j.runtime.beans.actions.net.DualDigest;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.NoPercentageProgressDelegate;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.ChecksumChecker;
import com.install4j.runtime.installer.helper.content.Downloader;
import com.install4j.runtime.launcher.integration.UpdateLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Objects;

public class DownloadFileAction
extends DownloadAction {
    private File targetFile;
    private boolean showProgress = true;
    private boolean showFileName = true;
    private boolean deleteOnExit = false;
    private boolean checkDigest = false;
    private String digestUrl = "";
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA256;
    private boolean dontAskForRetry = false;
    private boolean retryIfInterrupted = true;

    public boolean isCheckDigest() {
        return this.replaceWithTextOverride("checkDigest", this.checkDigest);
    }

    public void setCheckDigest(boolean checkForMd5Sums) {
        this.checkDigest = checkForMd5Sums;
    }

    public String getDigestUrl() {
        return DownloadFileAction.replaceVariables(DownloadFileAction.replaceVariables(this.digestUrl));
    }

    public void setDigestUrl(String digestUrl) {
        this.digestUrl = digestUrl;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.replaceWithTextOverride("digestAlgorithm", this.digestAlgorithm, DigestAlgorithm.class);
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public boolean isDontAskForRetry() {
        return this.replaceWithTextOverride("dontAskForRetry", this.dontAskForRetry);
    }

    public void setDontAskForRetry(boolean dontAskForRetry) {
        this.dontAskForRetry = dontAskForRetry;
    }

    public boolean isRetryIfInterrupted() {
        return this.replaceWithTextOverride("retryIfInterrupted", this.retryIfInterrupted);
    }

    public void setRetryIfInterrupted(boolean retryIfInterrupted) {
        this.retryIfInterrupted = retryIfInterrupted;
    }

    public File getTargetFile() {
        return this.replaceWithTextOverride("targetFile", DownloadFileAction.replaceVariables(this.targetFile), File.class);
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public boolean isShowProgress() {
        return this.replaceWithTextOverride("showProgress", this.showProgress);
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean isShowFileName() {
        return this.replaceWithTextOverride("showFileName", this.showFileName);
    }

    public void setShowFileName(boolean showFileName) {
        this.showFileName = showFileName;
    }

    public boolean isDeleteOnExit() {
        return this.replaceWithTextOverride("deleteOnExit", this.deleteOnExit);
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean execute(Context context) throws UserCanceledException {
        boolean bl;
        Throwable throwable;
        Downloader downloader;
        BackupFileForRollbackAction backupFileForRollbackAction;
        block29: {
            block27: {
                block28: {
                    File file = context.getDestinationFile(this.getTargetFile());
                    ProgressInterface progressInterface = context.getProgressInterface();
                    if (this.isShowProgress()) {
                        if (this.isShowFileName()) {
                            String fileName = file.getName();
                            progressInterface.setStatusMessage(this.wrapMessageInNobr(Messages.format(Messages.getString(".DownloadingWithFileName"), "<b>" + fileName + "</b>")));
                        } else {
                            progressInterface.setStatusMessage(Messages.getString(".Downloading"));
                        }
                    } else {
                        progressInterface = new NoPercentageProgressDelegate(progressInterface);
                    }
                    backupFileForRollbackAction = null;
                    if (context instanceof InstallerContext && file.exists()) {
                        backupFileForRollbackAction = new BackupFileForRollbackAction(file, true);
                        backupFileForRollbackAction.install((InstallerContext)context);
                        this.addRollbackAction(backupFileForRollbackAction);
                    }
                    downloader = this.createDownloader(context, this.isShowProgress() ? progressInterface : null);
                    throwable = null;
                    bl = DownloadFileAction.doDownload(downloader, context, file, this.getUrl(), this.isDeleteOnExit(), this.isRetryIfInterrupted(), this.isCheckDigest(), this.getDigestUrl(), this.getDigestAlgorithm(), this.isDontAskForRetry());
                    if (downloader == null) break block27;
                    if (throwable == null) break block28;
                    try {
                        downloader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block27;
                }
                downloader.close();
            }
            if (backupFileForRollbackAction == null) break block29;
            this.addRollbackAction(backupFileForRollbackAction);
        }
        return bl;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (downloader != null) {
                            if (throwable != null) {
                                try {
                                    downloader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                downloader.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    UpdateLog.logIfUpdater(e);
                    if (this.isShowError()) {
                        Util.showErrorMessage(Messages.format(Messages.getString("updater.DownloadError"), this.getUrl()));
                    }
                    Logger.getInstance().error(this, "Could not download file");
                    Logger.getInstance().log(e);
                    if (backupFileForRollbackAction != null) {
                        backupFileForRollbackAction.rollback((InstallerContext)context);
                        backupFileForRollbackAction = null;
                    }
                    boolean bl2 = false;
                    if (backupFileForRollbackAction != null) {
                        this.addRollbackAction(backupFileForRollbackAction);
                    }
                    return bl2;
                }
                catch (Throwable t) {
                    try {
                        UpdateLog.logIfUpdater(t);
                        throw t;
                    }
                    catch (Throwable throwable6) {
                        if (backupFileForRollbackAction != null) {
                            this.addRollbackAction(backupFileForRollbackAction);
                        }
                        throw throwable6;
                    }
                }
            }
        }
    }

    private static boolean doDownload(Downloader downloader, Context context, File file, String url, boolean deleteOnExit, boolean retryIfInterrupted, boolean checkDigest, String digestUrl, DigestAlgorithm digestAlgorithm, boolean dontAskForRetry) throws UserCanceledException, IOException {
        MessageDigest messageDigest = digestAlgorithm.createMessageDigest();
        downloader.setMessageDigest(messageDigest);
        boolean success = true;
        String expectedChecksum = null;
        String actualChecksum = null;
        String actualSha1 = null;
        String actualMD5 = null;
        while (true) {
            UpdateLog.logIfUpdater(1, "downloading " + url + " to " + file + " (exists: " + file.exists() + ")");
            boolean retry = false;
            try {
                downloader.connect(url);
            }
            catch (UserCanceledException e) {
                if (context.isCancelling()) {
                    throw new UserCanceledException();
                }
                success = false;
            }
            if (success) {
                try {
                    downloader.download(file, -1L, deleteOnExit);
                    if (messageDigest instanceof DualDigest) {
                        DualDigest dualDigest = (DualDigest)messageDigest;
                        actualSha1 = ChecksumChecker.getHexStringFromBytes(dualDigest.getSha256().digest());
                        actualMD5 = ChecksumChecker.getHexStringFromBytes(dualDigest.getMd5().digest());
                    }
                    actualChecksum = ChecksumChecker.getHexStringFromBytes(messageDigest.digest());
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (retryIfInterrupted) {
                        UpdateLog.logIfUpdater(1, "retry after " + e);
                        Logger.getInstance().error(DownloadFileAction.class, "Could not download file");
                        Logger.getInstance().log(e);
                        retry = success = DownloadFileAction.askRetry(Messages.getString(".DownloadInterrupted"));
                    }
                    throw e;
                }
            } else {
                UpdateLog.logIfUpdater(1, "could not connect to " + url);
            }
            if (retry) continue;
            if (success) {
                if (expectedChecksum == null) {
                    expectedChecksum = checkDigest ? ChecksumChecker.getExpectedDigest(downloader, context, digestUrl, url, digestAlgorithm, file.getName()) : "";
                }
                if (!Objects.equals("", expectedChecksum)) {
                    if (messageDigest instanceof DualDigest) {
                        actualChecksum = expectedChecksum.length() > 32 ? actualSha1 : actualMD5;
                    }
                    Logger.getInstance().info(DownloadFileAction.class, "Expected digest " + expectedChecksum + ", actual digest " + actualChecksum);
                    if (!Objects.equals(expectedChecksum, actualChecksum)) {
                        downloader.resetLastTransfer();
                        success = dontAskForRetry ? false : DownloadFileAction.askRetry(Messages.getString(".DownloadFileCorrupt"));
                        UpdateLog.logIfUpdater(1, "checksums did not match: expected: " + expectedChecksum + ", actual: " + actualChecksum);
                    }
                }
            }
            if (!success || Objects.equals("", expectedChecksum) || Objects.equals(actualChecksum, expectedChecksum)) break;
        }
        if (!success) {
            UpdateLog.logIfUpdater(1, "did not retry to download " + url);
        } else {
            UpdateLog.logIfUpdater(1, "downloaded " + url + " to " + file + " (size: " + file.length() + ")");
        }
        return success;
    }
}

