/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.Comparator;
import org.opengis.feature.simple.SimpleFeature;

public final class FeatureComparators {
    public static final Comparator BY_ID = new Comparator(){

        public int compare(Object o1, Object o2) {
            SimpleFeature f1 = (SimpleFeature)o1;
            SimpleFeature f2 = (SimpleFeature)o2;
            return f1.getID().compareTo(f2.getID());
        }
    };

    private FeatureComparators() {
    }

    public static Comparator byAttributeIndex(int idx) {
        return new Index(idx);
    }

    public static Comparator byAttributeName(String name) {
        return new Name(name);
    }

    public static class Name
    implements Comparator {
        private final String name;

        public Name(String name) {
            this.name = name;
        }

        public int compare(Object o1, Object o2) {
            SimpleFeature f1 = (SimpleFeature)o1;
            SimpleFeature f2 = (SimpleFeature)o2;
            return this.compareAtts(f1.getAttribute(this.name), f2.getAttribute(this.name));
        }

        protected int compareAtts(Object att1, Object att2) {
            if (att1 == null && att2 == null) {
                return 0;
            }
            if (att1 == null) {
                return -1;
            }
            if (att2 == null) {
                return 1;
            }
            return ((Comparable)att1).compareTo(att2);
        }
    }

    public static class Index
    implements Comparator {
        private final int idx;

        public Index(int i) {
            this.idx = i;
        }

        public int compare(Object o1, Object o2) {
            SimpleFeature f1 = (SimpleFeature)o1;
            SimpleFeature f2 = (SimpleFeature)o2;
            return this.compareAtts(f1.getAttribute(this.idx), f2.getAttribute(this.idx));
        }

        protected int compareAtts(Object att1, Object att2) {
            return ((Comparable)att1).compareTo(att2);
        }
    }
}

