/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.java;

import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapefileDataFrameExporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportShapefile(DataFrame dataFrame, File shapefile) throws IOException {
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        SimpleFeatureType type = ShapefileDataFrameExporter.createFeatureType(dataFrame);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(type);
        for (Object row : dataFrame.rows()) {
            for (Object column : dataFrame.columns()) {
                Object value = dataFrame.getValueAt(row, column);
                featureBuilder.add(value);
            }
            SimpleFeature feature = featureBuilder.buildFeature(null);
            features.add(feature);
        }
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", shapefile.toURI().toURL());
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        newDataStore.createSchema(type);
        DefaultTransaction transaction = new DefaultTransaction("create");
        String typeName = newDataStore.getTypeNames()[0];
        ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
        SimpleFeatureType SHAPE_TYPE = (SimpleFeatureType)featureSource.getSchema();
        System.out.println("SHAPE:" + String.valueOf(SHAPE_TYPE));
        if (featureSource instanceof SimpleFeatureStore) {
            SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
            ListFeatureCollection collection = new ListFeatureCollection(type, features);
            featureStore.setTransaction((Transaction)transaction);
            try {
                featureStore.addFeatures((FeatureCollection)collection);
                transaction.commit();
            }
            catch (Exception problem) {
                problem.printStackTrace();
                transaction.rollback();
            }
            finally {
                transaction.close();
            }
        } else {
            throw new IOException(typeName + " does not support read/write access");
        }
    }

    private static SimpleFeatureType createFeatureType(DataFrame dataFrame) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Location");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        boolean geometryColumnFound = false;
        for (Object column : dataFrame.columns()) {
            Class<MultiPolygon> cl = dataFrame.getColumnClass(column);
            String columnName = dataFrame.getColumnName(column);
            if (cl == Geometry.class && ((cl = SwingDataFrameExporter.getCommonType(dataFrame, column)) == null || cl == Geometry.class)) {
                cl = MultiPolygon.class;
            }
            if (!geometryColumnFound && Geometry.class.isAssignableFrom(cl)) {
                columnName = "the_geom";
                geometryColumnFound = true;
            }
            builder.add(columnName, (Class)cl);
        }
        SimpleFeatureType location = builder.buildFeatureType();
        return location;
    }
}

