/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.swing;

import com.macrofocus.crossplatform.swing.AbstractComboBoxEditor;
import com.macrofocus.igraphics.swing.SwingFont;
import java.awt.Font;
import java.text.ParseException;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;

public class CPFontComboBoxEditor
extends AbstractComboBoxEditor {
    private boolean acceptNullValue;
    private static String delimiter = ",";

    public CPFontComboBoxEditor(ComboBoxEditor var1, CellEditor var2, boolean var3) {
        super(var1, var2);
        this.acceptNullValue = var3;
    }

    @Override
    protected JFormattedTextField.AbstractFormatter createFormatter() {
        JFormattedTextField.AbstractFormatter var1 = new JFormattedTextField.AbstractFormatter(){

            @Override
            public Object stringToValue(String var1) throws ParseException {
                return !CPFontComboBoxEditor.this.acceptNullValue || var1 != null && var1.length() != 0 ? new SwingFont(CPFontComboBoxEditor.parseFont(var1)) : null;
            }

            @Override
            public String valueToString(Object var1) throws ParseException {
                return var1 == null ? null : CPFontComboBoxEditor.fontAsText(((SwingFont)var1).getNativeFont());
            }
        };
        return var1;
    }

    static String fontStyleAsText(int var0) {
        String var1 = null;
        if (var0 == 0) {
            var1 = UIManager.getString("JYComboBox.fontPopup.style.plain");
        } else if (var0 == 1) {
            var1 = UIManager.getString("JYComboBox.fontPopup.style.bold");
        } else if (var0 == 2) {
            var1 = UIManager.getString("JYComboBox.fontPopup.style.italic");
        } else if (var0 == 3) {
            var1 = UIManager.getString("JYComboBox.fontPopup.style.boldItalic");
        }
        return var1;
    }

    static int parseFontStyle(String var0) {
        int var1 = 0;
        if ((var0 = var0.toLowerCase()).equals(UIManager.getString("JYComboBox.fontPopup.style.plain").toLowerCase())) {
            var1 = 0;
        } else if (var0.equals(UIManager.getString("JYComboBox.fontPopup.style.bold").toLowerCase())) {
            var1 = 1;
        } else if (var0.equals(UIManager.getString("JYComboBox.fontPopup.style.italic").toLowerCase())) {
            var1 = 2;
        } else if (var0.equals(UIManager.getString("JYComboBox.fontPopup.style.boldItalic").toLowerCase())) {
            var1 = 3;
        }
        return var1;
    }

    static String fontAsText(Font var0) {
        return var0 == null ? "" : var0.getFamily() + delimiter + " " + CPFontComboBoxEditor.fontStyleAsText(var0.getStyle()) + delimiter + " " + var0.getSize();
    }

    static Font parseFont(String var0) throws ParseException {
        byte var1 = 3;
        String[] var2 = var0.split(delimiter);
        Object[] var3 = new Object[var1];
        if (var2.length != var1) {
            throw new ParseException("Required number: " + var1, -1);
        }
        for (int var4 = 0; var4 < var3.length; ++var4) {
            if (var4 == 0) {
                var3[var4] = var2[var4].trim();
                continue;
            }
            if (var4 == 1) {
                var3[var4] = CPFontComboBoxEditor.parseFontStyle(var2[var4].trim());
                continue;
            }
            if (var4 != 2) continue;
            try {
                int var5 = Integer.parseInt(var2[var4].trim());
                if (var5 < 4 || var5 > 256) {
                    throw new NumberFormatException("Size has to be between 4 and 256");
                }
                var3[var4] = var5;
                continue;
            }
            catch (NumberFormatException var7) {
                throw new ParseException(var7.getMessage(), -1);
            }
        }
        Font var8 = null;
        try {
            var8 = new Font((String)var3[0], (int)((Integer)var3[1]), (Integer)var3[2]);
            return var8;
        }
        catch (RuntimeException var6) {
            throw new ParseException(var6.getMessage(), -1);
        }
    }
}

