/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data;

import com.macrofocus.data.AbstractDataModel;

public final class DynamicMutableDataModel
extends AbstractDataModel {
    private final Object[][] array;
    private final Object[] name;
    private final Class[] type;
    private final int rowCount;
    private final int columnCount;

    public DynamicMutableDataModel(int rowCount, int columnCount) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.array = new Object[rowCount][columnCount];
        this.name = new Object[columnCount];
        this.type = new Class[columnCount];
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.array[row][column];
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this.array[row][column] != null;
    }

    @Override
    public Object getColumnName(int column) {
        return this.name[column];
    }

    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
        }
        return index;
    }

    @Override
    public Class getColumnClass(int column) {
        return this.type[column];
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    public void setObject(int row, int column, Object value) {
        this.array[row][column] = value;
    }

    public void setColumnName(int column, Object name) {
        this.name[column] = name;
    }

    public void setClass(int column, Class type) {
        this.type[column] = type;
    }
}

