/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.format;

import com.macrofocus.data.format.DataFormat;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.DirectoryDataSource;
import java.io.File;
import java.io.IOException;
import nu.xom.Element;

public class DirectoryDataFormat
implements DataFormat {
    static final String type = "Directory";

    @Override
    public String getType() {
        return type;
    }

    @Override
    public DataSource getDataSource(Element element) throws IOException {
        String path = element.getAttributeValue("path");
        String absolutePath = element.getAttributeValue("absolutePath");
        File file = new File(absolutePath);
        if (file.exists()) {
            return this.getDataSource(file);
        }
        return this.getDataSource(new File(path));
    }

    public DataSource getDataSource(File file) {
        return new DirectoryDataSource(file);
    }
}

