/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.data.matrix.SimpleMatrixModel;
import com.macrofocus.data.reader.BinaryDataReader;
import com.macrofocus.data.reader.CsvDataReader;
import com.macrofocus.data.reader.DataReader;
import com.macrofocus.data.reader.TabDataReader;
import com.macrofocus.data.writer.BinaryDataWriter;
import com.macrofocus.data.writer.CsvDataWriter;
import com.macrofocus.data.writer.TabDataWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class MatrixHelper {
    public static MatrixModel loadTxt(File file) {
        try {
            return MatrixHelper.loadTxt(new FileReader(file));
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            return null;
        }
    }

    public static MatrixModel loadTxt(URL url) {
        try {
            InputStream in = url.openStream();
            MatrixModel matrixModel = MatrixHelper.loadTxt(new InputStreamReader(in));
            in.close();
            return matrixModel;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read URL " + String.valueOf(url));
        }
    }

    public static MatrixModel loadTxt(Reader reader) {
        return MatrixHelper.loadTxt(new BufferedReader(reader));
    }

    public static MatrixModel loadTxt(BufferedReader reader) {
        return MatrixHelper.load(new TabDataReader(reader));
    }

    public static MatrixModel loadCsv(File file) {
        try {
            return MatrixHelper.loadCsv(new FileReader(file));
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            return null;
        }
    }

    public static MatrixModel loadCsv(Reader reader) {
        return MatrixHelper.loadCsv(new BufferedReader(reader));
    }

    public static MatrixModel loadCsv(BufferedReader reader) {
        return MatrixHelper.load(new CsvDataReader(reader));
    }

    public static MatrixModel loadBinary(File file) {
        try {
            return MatrixHelper.loadBinary(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
            return null;
        }
    }

    public static MatrixModel loadBinary(InputStream stream) {
        return MatrixHelper.loadBinary(new DataInputStream(stream));
    }

    public static MatrixModel loadBinary(DataInputStream stream) {
        return MatrixHelper.load(new BinaryDataReader(stream));
    }

    public static MatrixModel load(DataReader reader) {
        SimpleMatrixModel MatrixModel2 = new SimpleMatrixModel(reader);
        reader.close();
        return MatrixModel2;
    }

    public static void saveTxt(MatrixModel MatrixModel2, String filename) {
        MatrixHelper.saveTxt(MatrixModel2, new File(filename));
    }

    public static void saveTxt(MatrixModel MatrixModel2, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            MatrixHelper.saveTxt(MatrixModel2, writer);
            writer.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void saveTxt(MatrixModel MatrixModel2, Writer writer) {
        MatrixHelper.saveTxt(MatrixModel2, new BufferedWriter(writer));
    }

    public static void saveTxt(MatrixModel MatrixModel2, BufferedWriter writer) {
        TabDataWriter dataWriter = new TabDataWriter(writer);
        dataWriter.write(MatrixModel2);
        try {
            writer.flush();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void saveCsv(MatrixModel MatrixModel2, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            MatrixHelper.saveCsv(MatrixModel2, writer);
            writer.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void saveCsv(MatrixModel MatrixModel2, Writer writer) {
        MatrixHelper.saveCsv(MatrixModel2, new BufferedWriter(writer));
    }

    public static void saveCsv(MatrixModel MatrixModel2, BufferedWriter writer) {
        CsvDataWriter dataWriter = new CsvDataWriter(writer);
        dataWriter.write(MatrixModel2);
        try {
            writer.flush();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void saveBinary(MatrixModel MatrixModel2, File file) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            MatrixHelper.saveBinary(MatrixModel2, new BufferedOutputStream(stream));
            stream.close();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }

    public static void saveBinary(MatrixModel MatrixModel2, OutputStream stream) {
        MatrixHelper.saveBinary(MatrixModel2, new DataOutputStream(stream));
    }

    public static void saveBinary(MatrixModel MatrixModel2, DataOutputStream stream) {
        BinaryDataWriter dataWriter = new BinaryDataWriter(stream);
        dataWriter.write(MatrixModel2);
        try {
            stream.flush();
        }
        catch (IOException e) {
            Logging.getInstance().process((Throwable)e);
        }
    }
}

