/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.vector.integer;

import com.macrofocus.data.matrix.vector.integer.AbstractIntegerVectorModel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.StringTokenizer;

public class SimpleIntegerVectorModel
extends AbstractIntegerVectorModel
implements Externalizable {
    static final long serialVersionUID = 3137927581748715783L;
    private boolean[] areAvailable;
    private int[] values;
    private Object name;

    public SimpleIntegerVectorModel() {
        this.areAvailable = new boolean[0];
        this.values = new int[0];
        this.name = null;
    }

    public SimpleIntegerVectorModel(int[] values) {
        this.values = values;
        this.areAvailable = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.areAvailable[i] = true;
        }
    }

    public SimpleIntegerVectorModel(Object name, int[] values) {
        this.name = name;
        this.values = values;
        this.areAvailable = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.areAvailable[i] = true;
        }
    }

    public SimpleIntegerVectorModel(boolean[] areAvailable, int[] values, Object name) {
        this.areAvailable = areAvailable;
        this.values = values;
        this.name = name;
    }

    public SimpleIntegerVectorModel(String value) {
        StringTokenizer st = new StringTokenizer(value, ",");
        int count = st.countTokens();
        this.areAvailable = new boolean[count];
        this.values = new int[count];
        for (int index = 0; index < count; ++index) {
            try {
                this.values[index] = Integer.valueOf(st.nextToken().trim());
                this.areAvailable[index] = true;
                continue;
            }
            catch (NumberFormatException e) {
                this.areAvailable[index] = false;
            }
        }
    }

    @Override
    public int getInteger(int row) {
        return this.values[row];
    }

    @Override
    public boolean isAvailable(int index) {
        return this.areAvailable[index];
    }

    @Override
    public int getRowCount() {
        return this.values.length;
    }

    @Override
    public Object getName() {
        return this.name;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeInt(10000);
        out.writeObject(this.name);
        out.writeInt(this.values.length);
        for (i = 0; i < this.getRowCount(); ++i) {
            out.writeBoolean(this.isAvailable(i));
        }
        for (i = 0; i < this.getRowCount(); ++i) {
            if (!this.isAvailable(i)) continue;
            out.writeInt(this.getInteger(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 10000) {
            int i;
            this.name = in.readObject();
            int size = in.readInt();
            this.areAvailable = new boolean[size];
            this.values = new int[size];
            for (i = 0; i < this.getRowCount(); ++i) {
                this.areAvailable[i] = in.readBoolean();
            }
            for (i = 0; i < this.getRowCount(); ++i) {
                if (!this.isAvailable(i)) continue;
                this.values[i] = in.readInt();
            }
        }
    }

    @Override
    public String toString() {
        Object str = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            str = this.isAvailable(i) ? (String)str + this.getInteger(i) : (String)str + "NaN";
            if (i >= this.getRowCount() - 1) continue;
            str = (String)str + ",";
        }
        return str;
    }
}

