/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.data.TableModelDataFrame;
import com.macrofocus.data.reader.CharMatcher;
import com.macrofocus.data.reader.PerfectDataReader;
import com.macrofocus.data.reader.SingleCharMatcher;
import com.macrofocus.data.reader.TokenizerFactory;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.table.RowMajorTableModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.persistence.DataSourceContent;
import com.macrofocus.molap.persistence.DataSourceContentBuilder;
import com.macrofocus.util.file.CharsetToolkit;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.SQLException;
import javax.swing.table.TableModel;

public class NetdrawVNADataSource
extends FileURLDataSource {
    static final String type = "NetdrawVNA";
    private DataSourceContent dataSourceContent;

    public NetdrawVNADataSource(File file) {
        super(file);
    }

    public NetdrawVNADataSource(URL url) {
        super(url);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        TableModel tableModel = this.load(contentPane, true);
        return tableModel;
    }

    public TableModel load(Component contentPane, boolean autoConvert) throws IOException {
        DataSourceContentBuilder dataSourceContentBuilder = new DataSourceContentBuilder();
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        BufferedReader reader = new CharsetToolkit(bis, Charset.forName("UTF-8")).getReader();
        reader.readLine();
        PerfectDataReader dataReader = new PerfectDataReader(reader, new TokenizerFactory(CharMatcher.getDoubleQuoteMatcher(), "*Tie data", new SingleCharMatcher(' ')), true, false, "String");
        dataReader.setFileLoader(this.getFileLoader());
        RowMajorTableModel tableModel = new RowMajorTableModel(dataReader, autoConvert);
        TableModelDataFrame dataFrame = new TableModelDataFrame(tableModel);
        dataFrame.print();
        dataSourceContentBuilder.addDataFrame("nodes", (DataFrame)dataFrame);
        PerfectDataReader dataReader2 = new PerfectDataReader(reader, new TokenizerFactory(CharMatcher.getDoubleQuoteMatcher(), null, new SingleCharMatcher(' ')), true, false, "String");
        dataReader2.setFileLoader(this.getFileLoader());
        RowMajorTableModel tableModel2 = new RowMajorTableModel(dataReader2, autoConvert);
        dataFrame = new TableModelDataFrame(tableModel2);
        dataFrame.print();
        dataSourceContentBuilder.setDataFrame((DataFrame)dataFrame);
        bis.close();
        this.dataSourceContent = dataSourceContentBuilder.build();
        return tableModel2;
    }

    public DataSourceContent loadDataSourceContent() {
        return this.dataSourceContent;
    }
}

