/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.table.TagCloudTableModel;
import com.macrofocus.util.file.filter.TextFileFilter;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import javax.swing.table.TableModel;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;

public class TextTagCloudDataSource
extends FileURLDataSource {
    static final String type = "TextTagCloud";

    public TextTagCloudDataSource(File file) {
        super(file);
    }

    public TextTagCloudDataSource(URL url) {
        super(url);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        BufferedInputStream bis = this.getInputStream(this.checkContentPane(contentPane));
        TagCloudTableModel tableModel = new TagCloudTableModel(bis, new TextFileFilter());
        bis.close();
        return tableModel;
    }

    @Override
    public Document getDocument(ApplicationModel applicationModel) {
        Element root = new Element("TreeMap");
        Element layout = new Element("Layout");
        root.appendChild((Node)layout);
        Element algorithm = new Element("Algorithm");
        algorithm.addAttribute(new Attribute("name", "Tag Cloud"));
        layout.appendChild((Node)algorithm);
        Document doc = new Document(root);
        return doc;
    }
}

