/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.util.file.FileHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.ProgressMonitor;

public class NIODirectoryStructureTableModel
extends AbstractTableModel {
    private final List<Object[]> list;
    private final ProgressMonitor progressMonitor;
    private int progress = 0;
    private final Calendar calendar = Calendar.getInstance();

    public NIODirectoryStructureTableModel(File root, ProgressMonitor progressMonitor) {
        this(root.toPath(), progressMonitor);
    }

    public NIODirectoryStructureTableModel(Path root, ProgressMonitor progressMonitor) {
        this.list = new ArrayList<Object[]>();
        this.progressMonitor = progressMonitor;
        ++this.progress;
        if (progressMonitor != null) {
            progressMonitor.setProgress(this.progress);
        }
        try {
            Files.walkFileTree(root, new PrintFiles());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.progress = Integer.MAX_VALUE;
        if (progressMonitor != null) {
            progressMonitor.setProgress(this.progress);
        }
        System.out.println("Loaded " + this.getRowCount() + " files");
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return 11;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.list.get(rowIndex)[columnIndex];
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Path";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Size";
            }
            case 4: {
                return "Modified";
            }
            case 5: {
                return "Year";
            }
            case 6: {
                return "Month";
            }
            case 7: {
                return "Day";
            }
            case 8: {
                return "Day of Week";
            }
            case 9: {
                return "Hour";
            }
            case 10: {
                return "Path";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String[].class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Long.class;
            }
            case 4: {
                return Date.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: {
                return Integer.class;
            }
            case 7: {
                return Integer.class;
            }
            case 8: {
                return Integer.class;
            }
            case 9: {
                return Integer.class;
            }
            case 10: {
                return String.class;
            }
        }
        return null;
    }

    private Object[] toArray(Path path, BasicFileAttributes attr) {
        File file = path.toFile();
        this.calendar.setTimeInMillis(attr.lastModifiedTime().toMillis());
        Object[] array = new Object[11];
        int endIndex = Math.max(0, path.getNameCount() - 1);
        String[] strings = null;
        if (endIndex > 0) {
            Path parent = path.subpath(0, endIndex);
            strings = new String[parent.getNameCount()];
            for (int n = 0; n < parent.getNameCount(); ++n) {
                strings[n] = parent.getName(n).toString().intern();
            }
        } else {
            Object parent = null;
        }
        array[0] = strings;
        array[1] = FileHelper.getName(file.getName());
        String suffix = FileHelper.getSuffix(file.getName());
        if (suffix != null) {
            suffix = suffix.intern();
        }
        array[2] = suffix;
        array[3] = attr.size();
        array[4] = new Date(attr.lastModifiedTime().toMillis());
        array[5] = this.calendar.get(1);
        array[6] = this.calendar.get(2);
        array[7] = this.calendar.get(5);
        array[8] = this.calendar.get(7);
        array[9] = this.calendar.get(10);
        array[10] = FileHelper.getPath(file.getAbsolutePath());
        return array;
    }

    public class PrintFiles
    extends SimpleFileVisitor<Path> {
        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
            if (!attr.isSymbolicLink() && attr.isRegularFile()) {
                NIODirectoryStructureTableModel.this.list.add(NIODirectoryStructureTableModel.this.toArray(file, attr));
            }
            long size = attr.size();
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (NIODirectoryStructureTableModel.this.progressMonitor != null) {
                NIODirectoryStructureTableModel.this.progressMonitor.setProgress(++NIODirectoryStructureTableModel.this.progress);
                if (dir.getFileName() != null) {
                    NIODirectoryStructureTableModel.this.progressMonitor.setNote(dir.getFileName().toString());
                } else {
                    NIODirectoryStructureTableModel.this.progressMonitor.setNote("");
                }
                if (NIODirectoryStructureTableModel.this.progressMonitor.isCanceled()) {
                    return FileVisitResult.TERMINATE;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

