/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ShapefileTableModel
extends AbstractTableModel {
    private static final boolean convertToWGS84 = true;
    private SimpleFeatureType schema;
    private List<SimpleFeature> features;

    public ShapefileTableModel(URL shapeURL) throws IOException {
        ShapefileDataStore store = new ShapefileDataStore(shapeURL);
        String name = store.getTypeNames()[0];
        ContentFeatureSource source = store.getFeatureSource(name);
        SimpleFeatureCollection collection = source.getFeatures();
        this.schema = (SimpleFeatureType)collection.getSchema();
        CoordinateReferenceSystem sourceCRS = this.schema.getCoordinateReferenceSystem();
        MathTransform transform = null;
        if (sourceCRS != null) {
            try {
                DefaultGeographicCRS targetCRS = DefaultGeographicCRS.WGS84;
                if (targetCRS != sourceCRS) {
                    transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
                }
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
        }
        this.features = new ArrayList<SimpleFeature>();
        SimpleFeatureIterator iterator = collection.features();
        while (iterator.hasNext()) {
            Geometry sourceGeometry;
            SimpleFeature feature = (SimpleFeature)iterator.next();
            if (transform != null && (sourceGeometry = (Geometry)feature.getDefaultGeometry()) != null) {
                try {
                    Geometry reprojectedGeometry = JTS.transform((Geometry)sourceGeometry, (MathTransform)transform);
                    feature.setDefaultGeometry((Object)reprojectedGeometry);
                }
                catch (TransformException e) {
                    e.printStackTrace();
                }
            }
            this.features.add(feature);
        }
        iterator.close();
        store.dispose();
    }

    @Override
    public String getColumnName(int column) {
        return this.schema.getDescriptor(column).getName().toString();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.schema.getType(columnIndex).getBinding();
    }

    @Override
    public int getRowCount() {
        return this.features.size();
    }

    @Override
    public int getColumnCount() {
        return this.schema.getAttributeCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.features.get(rowIndex).getAttribute(columnIndex);
    }
}

