/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.serial.MacrofocusObjectInputStream;
import com.macrofocus.data.table.SimpleTableModel;
import com.macrofocus.data.typemap.DefaultTypemapModel;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class TableHelper {
    public static int findColumn(TableModel tableModel, String name) {
        for (int c = 0; c < tableModel.getColumnCount(); ++c) {
            if (!name.equals(tableModel.getColumnName(c))) continue;
            return c;
        }
        return -1;
    }

    public static TableModel getExternalizableTableModel(TableModel tableModel) {
        if (tableModel instanceof Externalizable) {
            return tableModel;
        }
        return new SimpleTableModel(tableModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(TableModel tableModel, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream buffer = new BufferedOutputStream(fos);
            GZIPOutputStream compressed = new GZIPOutputStream(buffer);
            ObjectOutputStream output = new ObjectOutputStream(compressed);
            try {
                output.writeObject(TableHelper.getExternalizableTableModel(tableModel));
            }
            finally {
                output.flush();
                output.close();
                compressed.finish();
                compressed.flush();
                ((OutputStream)fos).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static TableModel read(File file, Component parentComponent) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        ProgressMonitorInputStream monitorInputStream = new ProgressMonitorInputStream(parentComponent, "Reading " + file.getName(), new BufferedInputStream(fis, 65536));
        ProgressMonitor pm = monitorInputStream.getProgressMonitor();
        pm.setMillisToDecideToPopup(500);
        pm.setMillisToPopup(500);
        BufferedInputStream in = new BufferedInputStream(new GZIPInputStream((InputStream)monitorInputStream, 65536), 65536);
        MacrofocusObjectInputStream oin = new MacrofocusObjectInputStream(in);
        TableModel tableModel = (TableModel)oin.readObject();
        oin.close();
        return tableModel;
    }

    public static TableModel read(File file) {
        TableModel tableModel = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            tableModel = TableHelper.read(fis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return tableModel;
    }

    public static TableModel read(URL url, Component parentComponent) {
        TableModel tableModel = null;
        try {
            InputStream fis = url.openStream();
            ProgressMonitorInputStream monitorInputStream = new ProgressMonitorInputStream(parentComponent, "Reading " + url.getFile(), new BufferedInputStream(fis, 65536));
            ProgressMonitor pm = monitorInputStream.getProgressMonitor();
            pm.setMillisToDecideToPopup(500);
            pm.setMillisToPopup(500);
            tableModel = TableHelper.read(monitorInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return tableModel;
    }

    public static TableModel read(URL url) {
        TableModel tableModel = null;
        try {
            InputStream fis = url.openStream();
            tableModel = TableHelper.read(fis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return tableModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableModel read(InputStream fis) throws IOException, ClassNotFoundException {
        TableModel tableModel = null;
        BufferedInputStream buffer = new BufferedInputStream(new GZIPInputStream(fis, 65536), 65536);
        try (MacrofocusObjectInputStream input = new MacrofocusObjectInputStream(buffer);){
            tableModel = (TableModel)input.readObject();
        }
        return tableModel;
    }

    public static void writeTabDelimited(TableModel tableModel, File file) throws IOException {
        int c;
        DefaultTypemapModel typemapModel = new DefaultTypemapModel();
        FileWriter writer = new FileWriter(file);
        for (c = 0; c < tableModel.getColumnCount(); ++c) {
            writer.write(tableModel.getColumnName(c));
            if (c >= tableModel.getColumnCount() - 1) continue;
            writer.write(9);
        }
        writer.write("\r\n");
        for (c = 0; c < tableModel.getColumnCount(); ++c) {
            Class<?> cl = tableModel.getColumnClass(c);
            writer.write(typemapModel.getType(cl));
            if (c >= tableModel.getColumnCount() - 1) continue;
            writer.write(9);
        }
        writer.write("\r\n");
        for (int r = 0; r < tableModel.getRowCount(); ++r) {
            for (int c2 = 0; c2 < tableModel.getColumnCount(); ++c2) {
                Object value = tableModel.getValueAt(r, c2);
                if (value != null) {
                    writer.write(value.toString());
                }
                if (c2 >= tableModel.getColumnCount() - 1) continue;
                writer.write(9);
            }
            writer.write("\r\n");
        }
        writer.close();
    }

    public static void writeCSV(TableModel tableModel, File file) throws IOException {
        int c;
        DefaultTypemapModel typemapModel = new DefaultTypemapModel();
        FileWriter writer = new FileWriter(file);
        for (c = 0; c < tableModel.getColumnCount(); ++c) {
            writer.write(tableModel.getColumnName(c));
            if (c >= tableModel.getColumnCount() - 1) continue;
            writer.write(44);
        }
        writer.write("\r\n");
        for (c = 0; c < tableModel.getColumnCount(); ++c) {
            Class<?> cl = tableModel.getColumnClass(c);
            writer.write(typemapModel.getType(cl));
            if (c >= tableModel.getColumnCount() - 1) continue;
            writer.write(44);
        }
        writer.write("\r\n");
        for (int r = 0; r < tableModel.getRowCount(); ++r) {
            for (int c2 = 0; c2 < tableModel.getColumnCount(); ++c2) {
                Object value = tableModel.getValueAt(r, c2);
                if (value != null) {
                    if (value instanceof Number) {
                        writer.write(value.toString());
                    } else {
                        writer.write("\"" + value.toString().replaceAll("\"", "\"\"") + "\"");
                    }
                }
                if (c2 >= tableModel.getColumnCount() - 1) continue;
                writer.write(44);
            }
            writer.write("\r\n");
        }
        writer.close();
    }

    public static String convertMySQLWKBtoWKT(byte[] value) throws ParseException {
        Geometry g = TableHelper.convertMySQLWKBtoGeometry(value);
        return TableHelper.convertGeometryToWKT(g);
    }

    public static String convertGeometryToWKT(Geometry g) {
        if (g != null) {
            WKTWriter writer = new WKTWriter();
            return (String)(g.getSRID() > 0 ? "SRID=" + g.getSRID() + ";" : "") + writer.write(g);
        }
        return null;
    }

    public static Geometry convertMySQLWKBtoGeometry(byte[] value) throws ParseException {
        if (value != null && value.length > 4) {
            int i;
            WKBReader reader = new WKBReader();
            byte[] sridBytes = new byte[4];
            System.arraycopy(value, 0, sridBytes, 0, 4);
            boolean bigEndian = value[4] == 0;
            int srid = 0;
            if (bigEndian) {
                for (i = 0; i < sridBytes.length; ++i) {
                    srid = (srid << 8) + (sridBytes[i] & 0xFF);
                }
            } else {
                for (i = 0; i < sridBytes.length; ++i) {
                    srid += (sridBytes[i] & 0xFF) << 8 * i;
                }
            }
            byte[] wkb = new byte[value.length - 4];
            System.arraycopy(value, 4, wkb, 0, wkb.length);
            Geometry g = reader.read(wkb);
            g.setSRID(srid);
            return g;
        }
        return null;
    }

    public static byte[] convertWKTtoMySQLWKB(String value) throws ParseException {
        WKTReader reader = new WKTReader();
        Geometry geometry = reader.read(value);
        return TableHelper.convertGeometryToMySQLWKB(geometry);
    }

    private static byte[] convertGeometryToMySQLWKB(Geometry geometry) {
        int byteOrder = 2;
        WKBWriter writer = new WKBWriter(2, 2);
        byte[] wkb = writer.write(geometry);
        byte[] mysqlWKB = new byte[wkb.length + 4];
        int srid = geometry.getSRID();
        mysqlWKB[3] = (byte)(srid >> 24);
        mysqlWKB[2] = (byte)(srid >> 16);
        mysqlWKB[1] = (byte)(srid >> 8);
        mysqlWKB[0] = (byte)srid;
        System.arraycopy(wkb, 0, mysqlWKB, 4, wkb.length);
        return mysqlWKB;
    }

    private static byte[] convertGeometryToWKB(Geometry geometry) {
        WKBWriter writer = new WKBWriter();
        byte[] wkb = writer.write(geometry);
        return wkb;
    }

    public static void saveCustom(TableModel dataModel, BufferedWriter writer, String delim, boolean hasColumnHeader, boolean hasClassHeader, String missing) {
        GenericDataWriter dataWriter = new GenericDataWriter(writer, delim, hasColumnHeader, hasClassHeader, missing);
        dataWriter.write(dataModel);
        try {
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void print(TableModel tableModel) throws SQLException {
        String s;
        String o;
        int i;
        int cols = tableModel.getColumnCount();
        for (i = 0; i < cols; ++i) {
            o = tableModel.getColumnName(i);
            s = o != null ? o : "n.a.";
            System.out.printf("%20s", StringUtils.abbreviate((String)s, (int)19));
        }
        System.out.println();
        for (i = 0; i < cols; ++i) {
            o = tableModel.getColumnClass(i).getSimpleName();
            s = o != null ? o : "n.a.";
            System.out.printf("%20s", StringUtils.abbreviate((String)s, (int)19));
        }
        System.out.println();
        for (int row = 0; row < tableModel.getRowCount(); ++row) {
            for (int i2 = 0; i2 < cols; ++i2) {
                Object o2 = tableModel.getValueAt(row, i2);
                String s2 = o2 != null ? o2.toString() : "n.a.";
                System.out.printf("%20s", StringUtils.abbreviate((String)s2, (int)19));
            }
            System.out.println();
        }
    }

    public static class GenericDataWriter {
        private final BufferedWriter writer;
        private final String delim;
        private final boolean hasColumnHeader;
        private final boolean hasClassHeader;
        private final String missing;
        private int row;
        private int column;
        private int lineNumber;
        private SimpleDateFormat dateFormat;

        public GenericDataWriter(BufferedWriter writer, String delim, boolean hasColumnHeader, boolean hasClassHeader) {
            this(writer, delim, hasColumnHeader, hasClassHeader, "NaN", "yyyy-MM-dd");
        }

        public GenericDataWriter(BufferedWriter writer, String delim, boolean hasColumnHeader, boolean hasClassHeader, String missing) {
            this.writer = writer;
            this.delim = delim;
            this.hasColumnHeader = hasColumnHeader;
            this.hasClassHeader = hasClassHeader;
            this.row = -1;
            this.column = -1;
            this.lineNumber = -1;
            this.missing = missing;
            this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        }

        public GenericDataWriter(BufferedWriter writer, String delim, boolean hasColumnHeader, boolean hasClassHeader, String missing, String dateFormatPattern) {
            this.writer = writer;
            this.delim = delim;
            this.hasColumnHeader = hasColumnHeader;
            this.hasClassHeader = hasClassHeader;
            this.row = -1;
            this.column = -1;
            this.lineNumber = -1;
            this.missing = missing;
            this.dateFormat = new SimpleDateFormat(dateFormatPattern);
        }

        public void write(TableModel dataModel) {
            try {
                if (this.hasColumnHeader) {
                    ++this.lineNumber;
                    this.column = 0;
                    while (this.column < dataModel.getColumnCount()) {
                        this.writeColumnName(dataModel.getColumnName(this.column));
                        if (this.column + 1 < dataModel.getColumnCount()) {
                            this.nextColumn();
                        }
                        ++this.column;
                    }
                    this.nextRow();
                }
                if (this.hasClassHeader) {
                    ++this.lineNumber;
                    this.column = 0;
                    while (this.column < dataModel.getColumnCount()) {
                        this.writeClass(dataModel.getColumnClass(this.column));
                        if (this.column + 1 < dataModel.getColumnCount()) {
                            this.nextColumn();
                        }
                        ++this.column;
                    }
                    this.nextRow();
                }
                this.row = 0;
                while (this.row < dataModel.getRowCount()) {
                    ++this.lineNumber;
                    this.column = 0;
                    while (this.column < dataModel.getColumnCount()) {
                        if (dataModel.getValueAt(this.row, this.column) != null) {
                            this.writeValue(dataModel.getValueAt(this.row, this.column), dataModel.getColumnClass(this.column));
                        } else {
                            this.writeNotAvailable();
                        }
                        if (this.column + 1 < dataModel.getColumnCount()) {
                            this.nextColumn();
                        }
                        ++this.column;
                    }
                    this.nextRow();
                    ++this.row;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void writeColumnName(Object columnName) {
            try {
                if (columnName != null) {
                    this.writer.write(columnName.toString());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void writeClass(Class cl) {
            String className = cl == null ? Object.class.getName() : cl.getName();
            if (className.startsWith("java.lang.")) {
                className = className.substring("java.lang.".length());
            } else if (className.equals("java.net.URL")) {
                className = "URL";
            }
            try {
                this.writer.write(className);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void writeValue(Object value, Class cl) {
            if (value == null) {
                this.writeNotAvailable();
            } else {
                try {
                    if (value instanceof String) {
                        String string = (String)value;
                        this.writer.write("\"" + string.replaceAll("\"", "\"\"") + "\"");
                    } else if (value instanceof Date) {
                        this.writer.write(this.dateFormat.format(value));
                    } else if (value instanceof Geometry) {
                        WKTWriter wkt = new WKTWriter();
                        String string = wkt.write((Geometry)value);
                        this.writer.write("\"" + string + "\"");
                    } else {
                        this.writer.write(value.toString());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public void writeNotAvailable() {
            try {
                this.writer.write(this.missing);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void nextRow() {
            try {
                this.writer.newLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void nextColumn() {
            try {
                this.writer.write(this.delim);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void close() {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

