/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ProgressMonitor;

public class YahooFinanceTableModel
extends AbstractTableModel {
    List<Stock> dataItems = new ArrayList<Stock>();
    private static QuoteProperty[] quoteProperties = new QuoteProperty[]{new QuoteProperty("Symbol", "Symbol", "s0", String.class), new QuoteProperty("StockExchange", "Stock Exchange", "x0", String.class), new QuoteProperty("Name", "Name", "n0", String.class), new QuoteProperty("MarketCapitalization", "Market Capitalization", "j1", Double.class), new QuoteProperty("PercentChangeFromFiftydayMovingAverage", "Percent Change From 50-day Moving Average", "m8", Double.class), new QuoteProperty("PercentChangeFromTwoHundreddayMovingAverage", "Percent Change From 200-day Moving Average", "m6", Double.class), new QuoteProperty("ChangeInPercent", "Change In Percent", "p2", Double.class), new QuoteProperty("ChangeInPercentFromYearHigh", "Change In Percent From Year High", "k5", Double.class), new QuoteProperty("PercentChangeFromYearLow", "Percent Change From Year Low", "j6", Double.class), new QuoteProperty("AnnualizedGain", "Annualized Gain", "g3", Double.class), new QuoteProperty("AverageDailyVolume", "Average Daily Volume", "a2", Double.class), new QuoteProperty("BookValuePerShare", "Book Value Per Share", "b4", Double.class), new QuoteProperty("Change", "Change", "c1", Double.class), new QuoteProperty("ChangeFromFiftydayMovingAverage", "Change From 50-day Moving Average", "m7", Double.class), new QuoteProperty("ChangeFromTwoHundreddayMovingAverage", "Change From 200-day Moving Average", "m5", Double.class), new QuoteProperty("ChangeFromYearHigh", "Change From Year High", "k4", Double.class), new QuoteProperty("ChangeFromYearLow", "Change From Year Low", "j5", Double.class), new QuoteProperty("Commission", "Commission", "c3", String.class), new QuoteProperty("Currency", "Currency", "c4", String.class), new QuoteProperty("DaysHigh", "Days High", "h0", Double.class), new QuoteProperty("DaysLow", "Days Low", "g0", Double.class), new QuoteProperty("TrailingAnnualDividendYield", "Trailing Annual Dividend Yield", "d0", Double.class), new QuoteProperty("TrailingAnnualDividendYieldInPercent", "Trailing Annual Dividend Yield In Percent", "y0", Double.class), new QuoteProperty("DilutedEPS", "Diluted EPS", "e0", Double.class), new QuoteProperty("EBITDA", "EBITDA", "j4", Double.class), new QuoteProperty("EPSEstimateCurrentYear", "EPS Estimate Current Year", "e7", Double.class), new QuoteProperty("EPSEstimateNextQuarter", "EPS Estimate Next Quarter", "e9", Double.class), new QuoteProperty("EPSEstimateNextYear", "EPS Estimate Next Year", "e8", Double.class), new QuoteProperty("FiftydayMovingAverage", "50-day Moving Average", "m3", Double.class), new QuoteProperty("HoldingsGain", "Holdings Gain", "g4", Double.class), new QuoteProperty("OneyrTargetPrice", "Oneyr Target Price", "t8", Double.class), new QuoteProperty("PEGRatio", "PEG Ratio", "r5", Double.class), new QuoteProperty("PERatio", "PE Ratio", "r0", Double.class), new QuoteProperty("PreviousClose", "Previous Close", "p0", Double.class), new QuoteProperty("PriceBook", "Price Book", "p6", Double.class), new QuoteProperty("PriceEPSEstimateCurrentYear", "Price EPS Estimate Current Year", "r6", Double.class), new QuoteProperty("PriceEPSEstimateNextYear", "Price EPS Estimate Next Year", "r7", Double.class), new QuoteProperty("PriceSales", "Price Sales", "p5", Double.class), new QuoteProperty("Revenue", "Revenue", "s6", Double.class), new QuoteProperty("ShortRatio", "Short Ratio", "s7", Double.class), new QuoteProperty("TwoHundreddayMovingAverage", "200-day Moving Average", "m4", Double.class), new QuoteProperty("Volume", "Volume", "v0", Double.class), new QuoteProperty("YearHigh", "Year High", "k0", Double.class), new QuoteProperty("YearLow", "Year Low", "j0", Double.class)};

    public YahooFinanceTableModel(String[] symbols, ProgressMonitor progressMonitor) {
        this.dataItems = YahooFinanceTableModel.getStocks(symbols, progressMonitor);
    }

    protected static List<Stock> getStocks(String[] symbols, ProgressMonitor progressMonitor) {
        if (symbols.length > 199) {
            System.err.println("Warning: Number of symbols (" + symbols.length + ") may be too high");
        }
        ArrayList<Stock> dataItems = new ArrayList<Stock>();
        if (symbols.length > 0) {
            if (progressMonitor != null) {
                progressMonitor.setMaximum(500);
                progressMonitor.setProgress(1);
            }
            try {
                boolean hasMore;
                StringBuffer symbolString = new StringBuffer();
                for (int i = 0; i < symbols.length; ++i) {
                    String symbol = symbols[i];
                    symbolString.append(symbol);
                    if (i >= symbols.length - 1) continue;
                    symbolString.append(",");
                }
                if (progressMonitor != null) {
                    progressMonitor.setNote(symbolString.toString());
                }
                int count = 0;
                HashSet<String> set = new HashSet<String>();
                do {
                    String inputLine;
                    hasMore = false;
                    StringBuffer format = new StringBuffer();
                    for (QuoteProperty quoteProperty : quoteProperties) {
                        format.append(quoteProperty.tag);
                    }
                    String strUrl = "http://download.finance.yahoo.com/d/quotes.csv?s=" + String.valueOf(symbolString) + "&f=" + format.toString() + "&e=.csv&h=" + count;
                    URL url = new URL(strUrl);
                    BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                    boolean firstLine = true;
                    while ((inputLine = in.readLine()) != null) {
                        if (inputLine.trim().length() > 0) {
                            try {
                                Stock item = new Stock(inputLine);
                                if (!set.contains(item.getSymbol())) {
                                    set.add(item.getSymbol());
                                    dataItems.add(item);
                                    hasMore = set.size() < symbols.length;
                                }
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                        } else if (firstLine) {
                            hasMore = false;
                        }
                        firstLine = false;
                    }
                    count += 50;
                    in.close();
                    if (progressMonitor == null) continue;
                    progressMonitor.setProgress(count);
                } while (hasMore && (progressMonitor == null || !progressMonitor.isCanceled()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (progressMonitor != null) {
                progressMonitor.setProgress(progressMonitor.getMaximum());
            }
        }
        return dataItems;
    }

    @Override
    public int getRowCount() {
        return this.dataItems.size();
    }

    @Override
    public int getColumnCount() {
        return YahooFinanceTableModel.getColumnCount2();
    }

    protected static int getColumnCount2() {
        return quoteProperties.length + 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Stock stock = this.dataItems.get(row);
        return YahooFinanceTableModel.getValue(column, stock);
    }

    protected static Object getValue(int column, Stock stock) {
        if (column < quoteProperties.length) {
            return stock.getValue(column);
        }
        switch (column - quoteProperties.length) {
            case 0: {
                try {
                    return new URL("http://finance.yahoo.com/q?s=" + stock.getSymbol());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        return null;
    }

    public Class getColumnClass(int column) {
        return YahooFinanceTableModel.getColumnClass2(column);
    }

    static Class getColumnClass2(int column) {
        if (column < quoteProperties.length) {
            return YahooFinanceTableModel.quoteProperties[column].cl;
        }
        switch (column - quoteProperties.length) {
            case 0: {
                return URL.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return YahooFinanceTableModel.getColumnName2(column);
    }

    static String getColumnName2(int column) {
        if (column < quoteProperties.length) {
            return YahooFinanceTableModel.quoteProperties[column].description;
        }
        switch (column - quoteProperties.length) {
            case 0: {
                return "Yahoo Finance Lookup";
            }
        }
        return null;
    }

    static class QuoteProperty {
        String name;
        String description;
        String tag;
        Class cl;

        private QuoteProperty(String name, String description, String tag, Class cl) {
            this.name = name;
            this.description = description;
            this.tag = tag;
            this.cl = cl;
        }

        public String toString() {
            return "QuoteProperty{tag='" + this.tag + "', cl=" + String.valueOf(this.cl) + "}";
        }
    }

    protected static class Stock {
        private Object[] values = new Object[quoteProperties.length];

        private Stock(String inputLine) {
            if (inputLine != null) {
                String[] values = inputLine.split(",");
                for (int i = 0; i < quoteProperties.length; ++i) {
                    QuoteProperty quoteProperty = quoteProperties[i];
                    try {
                        if (quoteProperty.cl == Double.class) {
                            this.values[i] = Stock.parse(values[i]);
                            continue;
                        }
                        this.values[i] = values[i];
                        continue;
                    }
                    catch (Exception e) {
                        String symbol = (String)this.values[0];
                        throw new IllegalArgumentException("Invalid value " + values[i] + " for " + String.valueOf(quoteProperty) + " of symbol " + symbol, e);
                    }
                }
            }
        }

        public String getSymbol() {
            return (String)this.values[0];
        }

        public Object getValue(int column) {
            return this.values[column];
        }

        private static Double parse(String s) throws NumberFormatException {
            if (s != null && s.length() > 0 && !s.equals("N/A") && !s.equals("-")) {
                char lastChar = (s = s.trim()).charAt(s.length() - 1);
                if (Character.isDigit(lastChar)) {
                    return Double.parseDouble(s);
                }
                double value = Double.parseDouble(s.substring(0, s.length() - 1));
                switch (lastChar) {
                    case 'B': {
                        value = value * 1000.0 * 1000.0 * 1000.0;
                        break;
                    }
                    case 'M': {
                        value = value * 1000.0 * 1000.0;
                        break;
                    }
                    case 'K': {
                        value *= 1000.0;
                        break;
                    }
                    case '%': {
                        break;
                    }
                    default: {
                        throw new NumberFormatException("Unknown unit " + lastChar);
                    }
                }
                return value;
            }
            return null;
        }
    }

    public static enum Index {
        NDX("NASDAQ-100", "@^NDX"),
        IXIC("NASDAQ Composite", "@^IXIC"),
        DJA("Dow Jones Composite Average", "@^DJA"),
        DJI("Dow Jones Industrial Average", "@^DJI"),
        DJT("Dow Jones Transportation Average", "@^DJT"),
        DJU("Dow Jones Utility Average", "@^DJU"),
        MERV("MerVal", "@^MERV"),
        BVSP("Bovespa", "@^BVSP"),
        MXX("IPC", "@^MXX"),
        HSI("Hang Seng", "@^HSI"),
        NZ50("NZSE 50", "@^NZ50"),
        STI("Straits Times", "@^STI"),
        FCHI("CAC 40", "@^FCHI"),
        GDAXI("DAX", "@^GDAXI"),
        OMXSPI("Stockholm General", "@^OMXSPI"),
        FTSE("FTSE 100", "@^FTSE");

        private final String name;
        private final String symbol;

        private Index(String name, String symbol) {
            this.name = name;
            this.symbol = symbol;
        }

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

