/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type;

public class HighLowNumber<T extends Number>
extends Number
implements Comparable {
    protected T value;
    protected T low;
    protected T high;

    public HighLowNumber() {
    }

    public HighLowNumber(T value, T low, T high) {
        this.value = value;
        this.low = low;
        this.high = high;
    }

    @Override
    public int intValue() {
        return ((Number)this.value).intValue();
    }

    @Override
    public long longValue() {
        return ((Number)this.value).longValue();
    }

    @Override
    public float floatValue() {
        if (this.value != null) {
            return ((Number)this.value).floatValue();
        }
        return Float.NaN;
    }

    @Override
    public double doubleValue() {
        if (this.value != null) {
            return ((Number)this.value).doubleValue();
        }
        return Double.NaN;
    }

    public T getValue() {
        return this.value;
    }

    public T getLow() {
        return this.low;
    }

    public T getHigh() {
        return this.high;
    }

    public int compareTo(Object o) {
        return Double.compare(this.doubleValue(), ((Number)o).doubleValue());
    }

    public boolean isHigh() {
        return this.high != null && this.value != null && ((Number)this.value).doubleValue() > ((Number)this.high).doubleValue();
    }

    public boolean isLow() {
        return this.low != null && this.value != null && ((Number)this.value).doubleValue() < ((Number)this.low).doubleValue();
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }
}

