/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.convert;

import com.macrofocus.common.convert.TypeConverter;
import com.macrofocus.data.type.convert.AbstractTypeConverter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class ToDoubleFormatTypeConverter
extends AbstractTypeConverter {
    final DecimalFormat ch2 = (DecimalFormat)NumberFormat.getNumberInstance(Locale.forLanguageTag("de-ch"));
    final NumberFormat[] doubleFormats;

    public ToDoubleFormatTypeConverter() {
        DecimalFormatSymbols symbols = this.ch2.getDecimalFormatSymbols();
        symbols.setGroupingSeparator('\'');
        this.ch2.setDecimalFormatSymbols(symbols);
        this.doubleFormats = new NumberFormat[]{NumberFormat.getNumberInstance(Locale.US), NumberFormat.getNumberInstance(Locale.GERMAN), NumberFormat.getNumberInstance(Locale.FRENCH), NumberFormat.getNumberInstance(Locale.forLanguageTag("de-ch")), this.ch2, NumberFormat.getNumberInstance(), NumberFormat.getCurrencyInstance(Locale.US), NumberFormat.getCurrencyInstance(), NumberFormat.getPercentInstance()};
    }

    public boolean isConvertable(TypeConverter.Input input) {
        if (input.getType() != Integer.class && input.getType() != Double.class) {
            boolean allNull = true;
            for (int row = 0; row < input.size(); ++row) {
                Object v = input.get(row);
                if (v == null) continue;
                if (v instanceof String) {
                    String s = ((String)v).trim();
                    if (s.equals("")) continue;
                    allNull = false;
                    try {
                        Double.valueOf(s);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        boolean parsed = false;
                        for (int i = 0; i < this.doubleFormats.length && !parsed; ++i) {
                            NumberFormat format = this.doubleFormats[i];
                            try {
                                ToDoubleFormatTypeConverter.parse(format, s);
                                parsed = true;
                                continue;
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        if (parsed) continue;
                        return false;
                    }
                }
                if (v instanceof Double) continue;
                return false;
            }
            return !allNull;
        }
        return false;
    }

    public Class convert(TypeConverter.Input input, TypeConverter.Output output) {
        for (int row = 0; row < input.size(); ++row) {
            Object v = input.get(row);
            if (v == null) continue;
            if (v instanceof String) {
                String s = ((String)v).trim();
                if (!s.equals("")) {
                    try {
                        output.set(row, (Object)Double.valueOf(s));
                    }
                    catch (NumberFormatException e) {
                        boolean parsed = false;
                        for (int i = 0; i < this.doubleFormats.length && !parsed; ++i) {
                            NumberFormat format = this.doubleFormats[i];
                            try {
                                output.set(row, ToDoubleFormatTypeConverter.parse(format, s));
                                parsed = true;
                                continue;
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                        }
                        if (parsed) continue;
                        output.set(row, null);
                    }
                    continue;
                }
                output.set(row, null);
                continue;
            }
            if (v instanceof Double) continue;
            output.set(row, null);
        }
        return Double.class;
    }

    public Class getType() {
        return Double.class;
    }
}

