/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document.swing;

import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.View;
import com.macrofocus.application.document.swing.SwingSDIDocumentBasedApplication;
import com.macrofocus.application.file.CPFileChooser;
import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.common.file.FileType;
import com.macrofocus.util.file.FileHelper;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFrame;

class SaveAsUICommand<D extends Document, V extends View<JComponent, D>>
extends AbstractUICommand {
    private SwingSDIDocumentBasedApplication<D, V> application;
    private final JFrame window;
    private final V view;
    private File selectedFile;
    private FileType fileType;

    public SaveAsUICommand(SwingSDIDocumentBasedApplication application, JFrame window, V view) {
        super("Save As", null);
        this.application = application;
        this.window = window;
        this.view = view;
        this.enabledProperty().setValue((Object)(view.getDocument() != null ? 1 : 0));
    }

    public void execute(Object source) {
        CPFileChooser<JFrame, File> fileChooser = this.application.getFileChooser();
        fileChooser.setTitle("Save File");
        fileChooser.setFileTypes(this.application.getSaveFileTypes());
        if (this.fileType != null) {
            fileChooser.setSelectedFileType(this.fileType);
        }
        if (this.selectedFile != null) {
            fileChooser.setSelectedFile((Object)this.selectedFile);
        } else {
            File file = (File)this.application.getFileManager().getFile((Object)this.window);
            if (file != null) {
                fileChooser.setSelectedFile((Object)FileHelper.replaceSuffix((File)file, (String)fileChooser.getSelectedFileType().getExtensions()[0]));
            } else if (this.view.getDocument() != null) {
                fileChooser.setSelectedFile((Object)new File(SaveAsUICommand.addSuffix(this.view.getDocument().getDocumentState().getName(), fileChooser.getSelectedFileType().getExtensions()[0])));
            }
        }
        this.selectedFile = (File)fileChooser.showSaveDialog((Object)this.window);
        this.fileType = fileChooser.getSelectedFileType();
        if (this.selectedFile != null) {
            this.application.saveView((View)this.view, this.selectedFile, this.fileType);
            this.application.getFileManager().setFile((Object)this.window, (Object)this.selectedFile);
        }
    }

    public void save(Object source) {
        if (this.selectedFile != null) {
            this.application.saveView((View)this.view, this.selectedFile, this.fileType);
            this.application.getFileManager().setFile((Object)this.window, (Object)this.selectedFile);
        } else {
            this.execute(source);
        }
    }

    public static String addSuffix(String name, String suffix) {
        String string = name = name != null ? name : "Untitled";
        if (name.endsWith("." + suffix)) {
            return name;
        }
        int index = name.lastIndexOf(".");
        if (index > 0) {
            String newName = name.substring(0, index);
            return newName + "." + suffix;
        }
        return name + "." + suffix;
    }
}

