/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions.swing;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.helper.TableHelper;
import com.macrofocus.high_d.distributions.AbstractDistributions;
import com.macrofocus.high_d.distributions.DefaultDistributionsModel;
import com.macrofocus.high_d.distributions.DistributionsModel;
import com.macrofocus.high_d.distributions.DistributionsView;
import com.macrofocus.high_d.distributions.swing.SwingDistributionsController;
import com.macrofocus.high_d.distributions.swing.SwingDistributionsView;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.java.TableModelDataFrame;
import com.macrofocus.molap.subset.SubsetDataFrame;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.OverlayLayout;
import javax.swing.table.TableModel;

public class SwingDistributions<Row, Column, Value, Bin>
extends AbstractDistributions<JComponent, Color, Row, Column, Value, Bin> {
    private final JComponent nativeComponent = new JComponent(){};

    public SwingDistributions() {
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.view = this.createView();
        this.view.setLicenseModel(licenseModel);
        this.controller = this.createController(this.view);
        this.setView(this.view);
    }

    public SwingDistributions(DistributionsModel model) {
        this();
        this.setModel(model);
    }

    public SwingDistributions(DataFrame dataFrame) {
        this();
        this.load(dataFrame);
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API, username, key);
    }

    public void setView(DistributionsView<JComponent, Color, Row, Column, Value, Bin> view) {
        if (this.getView() != null) {
            this.nativeComponent.remove((Component)this.getView().getNativeComponent());
        }
        super.setView(view);
        if (this.getView() != null) {
            this.nativeComponent.add((Component)this.getView().getNativeComponent());
        }
        this.nativeComponent.revalidate();
    }

    protected DistributionsModel createModel(DataFrame dataFrame) {
        return new DefaultDistributionsModel((CPFactory)SwingFactory.getInstance(), (ColorMapFactory)SwingColorMapFactory.getInstance(), dataFrame, new SubsetDataFrame(dataFrame));
    }

    protected SwingDistributionsView createView() {
        SwingDistributionsView view = new SwingDistributionsView();
        return view;
    }

    protected SwingDistributionsController createController(DistributionsView view) {
        return new SwingDistributionsController(view);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public static void main(String[] args) {
        SwingDistributions.setLicenseKey("Macrofocus GmbH", "3RCD9-DMQDM-AAEMV-LGN5S-76384-FE5WA");
        TableModel tableModel = TableHelper.createRandomTableModel((int)3, (int)10000, (int)10);
        SwingDistributions distributions = new SwingDistributions((DataFrame)new TableModelDataFrame(tableModel));
        DistributionsModel model = distributions.getModel();
        distributions.getView().getColorTheme().setValue((Object)new LightColorTheme((CPColorFactory)SwingFactory.getInstance()));
        distributions.getView().getShowTiming().setValue((Object)true);
        ApplicationModel applicationModel = ApplicationModelFactory.HIGHD_API_V1;
        JFrame frame = new JFrame(applicationModel.getName() + " " + applicationModel.getVersion() + ", Copyright (c) " + applicationModel.getCopyright() + " " + applicationModel.getEdition());
        frame.setSize(600, 600);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(distributions.getNativeComponent());
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

