/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions.swing;

import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.crossplatform.swing.SwingInteractiveComponent;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.high_d.axis.AxisHeaderView;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.DummyAxisModel;
import com.macrofocus.high_d.axis.swing.SwingAxisView;
import com.macrofocus.high_d.distributions.AbstractDistributionsView;
import com.macrofocus.high_d.distributions.DistributionsComponent;
import com.macrofocus.high_d.distributions.DistributionsView;
import com.macrofocus.high_d.distributions.swing.SwingDistributionsComponent;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.labeling.EnhancedJLabel;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.molap.subset.DistributionDimension;
import com.macrofocus.order.MutableVisibleOrder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;

public class SwingDistributionsView<Row, Column, Value, Bin>
extends AbstractDistributionsView<JLayeredPane, Color, Row, Column, Value, Bin> {
    private final SwingInteractiveComponent<JLayeredPane> nativeComponent = new SwingInteractiveComponent((JComponent)new DistributionsLayeredPane());
    private final Map<AxisModel, JButton> axisLabels = new HashMap<AxisModel, JButton>();
    private final SwingDistributionsComponent<Row, Column, Value, Bin> distributionsComponent;
    private int headerMaximumHeight;
    private SwingAxisView draggedAxisView;
    private int draggedLocation;
    private LicenseModel licenseModel;
    private JPanel unregisteredPanel;
    private ComponentAdapter unregisteredPanelListener;
    private final PropertiesListener<DistributionsView.PropertyType> propertiesListener = new PropertiesListener<DistributionsView.PropertyType>(){

        public void propertyChanged(DistributionsView.PropertyType name, PropertyEvent event) {
            if (name == DistributionsView.PropertyType.ColorTheme) {
                ((JLayeredPane)SwingDistributionsView.this.nativeComponent.getNativeComponent()).updateUI();
                ((JLayeredPane)SwingDistributionsView.this.nativeComponent.getNativeComponent()).repaint();
            }
        }
    };

    public SwingDistributionsView() {
        super((CPColorFactory)SwingFactory.getInstance());
        this.properties.addPropertiesListener(this.propertiesListener);
        this.distributionsComponent = new SwingDistributionsComponent(this);
        ((JLayeredPane)this.nativeComponent.getNativeComponent()).add((Component)this.distributionsComponent.getNativeComponent(), JLayeredPane.DEFAULT_LAYER);
        ((JLayeredPane)this.nativeComponent.getNativeComponent()).setOpaque(true);
        ((JLayeredPane)this.nativeComponent.getNativeComponent()).updateUI();
        ((JLayeredPane)this.nativeComponent.getNativeComponent()).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SwingDistributionsView.this.refresh();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SwingDistributionsView.this.refresh();
            }
        });
        ((JLayeredPane)this.nativeComponent.getNativeComponent()).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    SwingDistributionsView.this.refresh();
                }
            }
        });
        this.setLicenseModel(this.licenseModel);
    }

    protected DistributionsComponent getDistributionsComponent() {
        return this.distributionsComponent;
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.nativeComponent.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.nativeComponent.addMouseMotionListener(l);
    }

    public void removeMouseListener(CPCanvas.MouseListener l) {
        this.nativeComponent.removeMouseListener(l);
    }

    public void removeMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.nativeComponent.removeMouseMotionListener(l);
    }

    public JLayeredPane getNativeComponent() {
        return (JLayeredPane)this.nativeComponent.getNativeComponent();
    }

    protected void refresh() {
        if (((JLayeredPane)this.nativeComponent.getNativeComponent()).isShowing()) {
            this.runLayout();
            ((JLayeredPane)this.nativeComponent.getNativeComponent()).repaint();
        }
    }

    private void runLayout() {
        this.distributionsComponent.getNativeComponent().setBounds(0, this.headerMaximumHeight, ((JLayeredPane)this.nativeComponent.getNativeComponent()).getWidth(), ((JLayeredPane)this.nativeComponent.getNativeComponent()).getHeight() - this.headerMaximumHeight);
        MutableVisibleOrder axisOrder = this.getModel().getAxisGroupModel().getAxisOrder();
        for (AxisModel axisModel : axisOrder.iterableAll()) {
            JButton header = this.getHeader(axisModel);
            if (axisOrder.isVisible((Object)axisModel)) {
                int i = axisOrder.indexOf((Object)axisModel);
                Double x1Location = this.getModel().getLocation(axisModel);
                Double x2Location = i + 1 < axisOrder.size() ? this.getModel().getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
                if (x1Location != null && x2Location != null) {
                    int x = (int)(x1Location * (double)((JLayeredPane)this.nativeComponent.getNativeComponent()).getWidth());
                    int y = 0;
                    int width = (int)(x2Location * (double)((JLayeredPane)this.nativeComponent.getNativeComponent()).getWidth()) - x;
                    int height = this.headerMaximumHeight;
                    Rectangle mp = new Rectangle(x, y, width, height);
                    header.setBounds(mp);
                }
                header.setVisible(true);
                continue;
            }
            header.setVisible(false);
        }
        ((JLayeredPane)this.nativeComponent.getNativeComponent()).revalidate();
    }

    public JButton getHeader(AxisModel axisModel) {
        if (!this.axisLabels.containsKey(axisModel)) {
            AxisHeaderView label = this.createAxisHeaderView(axisModel);
            ((JLayeredPane)this.nativeComponent.getNativeComponent()).add((Component)label, JLayeredPane.PALETTE_LAYER);
            this.axisLabels.put(axisModel, (JButton)label);
        }
        return this.axisLabels.get(axisModel);
    }

    protected AxisHeaderView createAxisHeaderView(AxisModel axisModel) {
        return new AxisHeaderView(axisModel);
    }

    public DistributionDimension<Row, Value, Bin> getClosestDistribution(int x, int y) {
        Rectangle b = this.distributionsComponent.getNativeComponent().getBounds();
        if (b.contains(x, y)) {
            return this.distributionsComponent.getClosestDistribution(x - b.x, y - b.y);
        }
        return null;
    }

    public Bin getClosestBin(int x, int y) {
        Rectangle b = this.distributionsComponent.getNativeComponent().getBounds();
        if (b.contains(x, y)) {
            return (Bin)this.distributionsComponent.getClosestBin(x - b.x, y - b.y);
        }
        return null;
    }

    public List<Bin> getBins(Rectangle2D rect) {
        Rectangle b = this.distributionsComponent.getNativeComponent().getBounds();
        if (b.contains(rect.getX(), rect.getY())) {
            return this.distributionsComponent.getBins((Rectangle2D)new Rectangle2D.Double(rect.getX() - b.getX(), rect.getY() - b.getY(), rect.getWidth(), rect.getHeight()));
        }
        return null;
    }

    public Row getClosestRow(int x, int y) {
        Rectangle b = this.distributionsComponent.getNativeComponent().getBounds();
        if (b.contains(x, y)) {
            return (Row)this.distributionsComponent.getClosestRow(x - b.x, y - b.y);
        }
        return null;
    }

    public void setLicenseModel(LicenseModel licenseModel) {
        if (this.unregisteredPanel != null) {
            ((JLayeredPane)this.nativeComponent.getNativeComponent()).removeComponentListener(this.unregisteredPanelListener);
            ((JLayeredPane)this.nativeComponent.getNativeComponent()).remove(this.unregisteredPanel);
            this.unregisteredPanel = null;
            this.unregisteredPanelListener = null;
        }
        if (licenseModel == null || licenseModel.verify() != LicenseModel.State.Valid) {
            EnhancedJLabel unregisteredLabel = new EnhancedJLabel();
            unregisteredLabel.setEffect(EnhancedLabel.Effect.Outline);
            String message = licenseModel == null ? "Unregistered version" : licenseModel.verify().toString();
            unregisteredLabel.setText(message);
            unregisteredLabel.setForeground(new Color(0, 0, 0, 63));
            unregisteredLabel.setBackground(new Color(255, 255, 255));
            unregisteredLabel.setEffectOpacity(0.2f);
            this.unregisteredPanel = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    super.paint(g2);
                }
            };
            this.unregisteredPanel.setOpaque(false);
            this.unregisteredPanel.setLayout(new OverlayLayout(this.unregisteredPanel));
            this.unregisteredPanel.add((Component)unregisteredLabel);
            unregisteredLabel.setFont(unregisteredLabel.getFont().deriveFont(1, 32.0f));
            ((JLayeredPane)this.nativeComponent.getNativeComponent()).add(this.unregisteredPanel, JLayeredPane.MODAL_LAYER, 0);
            this.unregisteredPanelListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingHelper.centerBottom((Container)SwingDistributionsView.this.nativeComponent.getNativeComponent(), (Component)SwingDistributionsView.this.unregisteredPanel);
                }
            };
            ((JLayeredPane)this.nativeComponent.getNativeComponent()).addComponentListener(this.unregisteredPanelListener);
        }
    }

    private class DistributionsLayeredPane
    extends JLayeredPane {
        @Override
        public void paint(Graphics g) {
            Graphics2D g2;
            long current = System.currentTimeMillis();
            Object antialias = (g2 = (Graphics2D)g).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias != null ? antialias : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            super.paint(g);
            if (((Boolean)SwingDistributionsView.this.getShowTiming().getValue()).booleanValue()) {
                g.setColor(Color.red);
                g.drawString(System.currentTimeMillis() - current + " milliseconds", 5, this.getSize().height - 25);
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            SwingDistributionsView.this.headerMaximumHeight = SwingDistributionsView.this.createAxisHeaderView((AxisModel)new DummyAxisModel((String)"T")).getPreferredSize().height;
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getPreferredSize() {
            return SwingDistributionsView.this.distributionsComponent.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }
}

