/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.swing;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.AxisView;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.swing.SwingAxisView;
import com.macrofocus.high_d.interaction.InteractionMode;
import com.macrofocus.high_d.parallelcoordinates.AbstractParallelCoordinatesController;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.swing.SwingParallelCoordinatesView;
import com.macrofocus.igraphics.CPColor;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;

public class SwingParallelCoordinatesController<Row, Column>
extends AbstractParallelCoordinatesController<JComponent, Row, Column> {
    private ParallelCoordinatesView<JComponent, CPColor, Row, Column> view;
    private AxisView draggedAxisView;
    private int draggedLocation;
    private final KeyListener keyListener = new KeyAdapter(){
        InteractionMode oldMode;

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 83) {
                if (this.oldMode == null) {
                    this.oldMode = SwingParallelCoordinatesController.this.getMode();
                }
                SwingParallelCoordinatesController.this.setMode(InteractionMode.Selection);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.oldMode != null) {
                SwingParallelCoordinatesController.this.setMode(this.oldMode);
                this.oldMode = null;
            }
        }
    };
    private final ParallelCoordinatesView.DragListener dragListener = new ParallelCoordinatesView.DragListener(){

        public void startDragging(AxisView axisView) {
            if (((Boolean)SwingParallelCoordinatesController.this.reordering.getValue()).booleanValue()) {
                SwingParallelCoordinatesController.this.draggedAxisView = axisView;
                SwingParallelCoordinatesController.this.draggedLocation = ((SwingAxisView)axisView).getX();
                ((SwingParallelCoordinatesView)SwingParallelCoordinatesController.this.view).getInteractiveComponent().setLayer((Component)((SwingAxisView)axisView), JLayeredPane.DRAG_LAYER);
                ((SwingParallelCoordinatesView)SwingParallelCoordinatesController.this.view).getInteractiveComponent().setLayer(((SwingParallelCoordinatesView)SwingParallelCoordinatesController.this.view).getLabel(axisView.getModel()), JLayeredPane.DRAG_LAYER);
                AxisGroupModel axisGroup = SwingParallelCoordinatesController.this.view.getModel().getAxisHierarchy().getAxisGroup(axisView.getModel());
                SwingParallelCoordinatesController.this.view.getModel().getAxisLocations(axisGroup).drag((Alignment)SwingParallelCoordinatesController.this.view.getAlignment().getValue(), axisView.getModel(), this.computeNormalizedLocation((SwingAxisView)axisView));
                ((SwingParallelCoordinatesView)SwingParallelCoordinatesController.this.view).refresh();
            }
        }

        public void dragAxisTo(AxisView axisView, int location) {
            if (((Boolean)SwingParallelCoordinatesController.this.reordering.getValue()).booleanValue()) {
                SwingParallelCoordinatesController.this.draggedAxisView = axisView;
                ((SwingAxisView)SwingParallelCoordinatesController.this.draggedAxisView).setLocation(SwingParallelCoordinatesController.this.draggedLocation + location, ((SwingAxisView)SwingParallelCoordinatesController.this.draggedAxisView).getY());
                AxisGroupModel axisGroup = SwingParallelCoordinatesController.this.view.getModel().getAxisHierarchy().getAxisGroup(axisView.getModel());
                SwingParallelCoordinatesController.this.view.getModel().getAxisLocations(axisGroup).drag((Alignment)SwingParallelCoordinatesController.this.view.getAlignment().getValue(), axisView.getModel(), this.computeNormalizedLocation((SwingAxisView)axisView));
                ((SwingParallelCoordinatesView)SwingParallelCoordinatesController.this.view).refresh();
            }
        }

        public void stopDragging(AxisView axisView) {
            if (((Boolean)SwingParallelCoordinatesController.this.reordering.getValue()).booleanValue()) {
                SwingParallelCoordinatesController.this.draggedAxisView = null;
                SwingParallelCoordinatesController.this.draggedLocation = 0;
                AxisGroupModel axisGroup = SwingParallelCoordinatesController.this.view.getModel().getAxisHierarchy().getAxisGroup(axisView.getModel());
                SwingParallelCoordinatesController.this.view.getModel().getAxisLocations(axisGroup).stopDragging();
                ((SwingParallelCoordinatesView)SwingParallelCoordinatesController.this.view).getInteractiveComponent().setLayer(((SwingParallelCoordinatesView)SwingParallelCoordinatesController.this.view).getLabel(axisView.getModel()), JLayeredPane.PALETTE_LAYER);
                ((SwingParallelCoordinatesView)SwingParallelCoordinatesController.this.view).getInteractiveComponent().setLayer((Component)((SwingAxisView)axisView), JLayeredPane.PALETTE_LAYER);
                ((SwingParallelCoordinatesView)SwingParallelCoordinatesController.this.view).refresh();
            }
        }

        private double computeNormalizedLocation(SwingAxisView axisView) {
            AxisGroupModel axisGroup = SwingParallelCoordinatesController.this.view.getModel().getAxisHierarchy().getAxisGroup(axisView.getModel());
            Rectangle2D rect = SwingParallelCoordinatesController.this.view.getParallelCoordinatesLayout().getBounds(axisGroup);
            Alignment alignment = (Alignment)SwingParallelCoordinatesController.this.view.getAlignment().getValue();
            return Math.min(alignment.getMaximumPosition(axisGroup) + 0.05, Math.max(alignment.getMinimumPosition(axisGroup) - 0.05, ((double)(axisView.getX() + axisView.getWidth() / 2) - rect.getX()) / rect.getWidth()));
        }
    };
    private ParallelCoordinatesView.HeaderListener headerListener = new ParallelCoordinatesView.HeaderListener(){

        public void headerSelected(AxisView view, int clickCount) {
            if (clickCount == 2 && ((Boolean)SwingParallelCoordinatesController.this.reversing.getValue()).booleanValue()) {
                AxisModel axisModel = view.getModel();
                double start = axisModel.getInterval().getStart();
                double end = axisModel.getInterval().getEnd();
                double max = axisModel.getMaximum();
                double min = axisModel.getMinimum();
                axisModel.setMinMax(max, min);
                axisModel.getInterval().setStart(end);
                axisModel.getInterval().setEnd(start);
            }
        }
    };

    public SwingParallelCoordinatesController(ParallelCoordinatesView view) {
        this.setView(view);
    }

    public ParallelCoordinatesView<JComponent, CPColor, Row, Column> getView() {
        return this.view;
    }

    public void setView(ParallelCoordinatesView<JComponent, CPColor, Row, Column> view) {
        if (this.view != null) {
            ((JComponent)this.view.getNativeComponent()).removeKeyListener(this.keyListener);
            this.view.removeMouseListener((CPCanvas.MouseListener)this.mouseListener);
            this.view.removeMouseMotionListener((CPCanvas.MouseMotionListener)this.mouseListener);
            this.view.removeDragListener(this.dragListener);
            this.view.removeHeaderListener(this.headerListener);
        }
        this.view = view;
        if (view != null) {
            ((JComponent)view.getNativeComponent()).setFocusable(true);
            ((JComponent)view.getNativeComponent()).addKeyListener(this.keyListener);
            view.addMouseListener((CPCanvas.MouseListener)this.mouseListener);
            view.addMouseMotionListener((CPCanvas.MouseMotionListener)this.mouseListener);
            view.addDragListener(this.dragListener);
            view.addHeaderListener(this.headerListener);
        }
    }
}

