/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.swing;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.crossplatform.swing.SwingInteractiveComponent;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.hierarchy.Hierarchy;
import com.macrofocus.hierarchy.HierarchyEvent;
import com.macrofocus.hierarchy.HierarchyListener;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisHeaderView;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.AxisView;
import com.macrofocus.high_d.axis.DummyAxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.group.AxisGroupView;
import com.macrofocus.high_d.axis.swing.SwingAxisGroupView;
import com.macrofocus.high_d.axis.swing.SwingAxisView;
import com.macrofocus.high_d.parallelcoordinates.AbstractParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesComponent;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesListener;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesPopupMenu;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.geometry.Geometry;
import com.macrofocus.high_d.parallelcoordinates.layout.DefaultParallelCoordinatesLayoutEngine;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayout;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayoutEngine;
import com.macrofocus.high_d.parallelcoordinates.swing.AxisController;
import com.macrofocus.high_d.parallelcoordinates.swing.PopupAxisController;
import com.macrofocus.high_d.parallelcoordinates.swing.SwingAxisComponents;
import com.macrofocus.high_d.parallelcoordinates.swing.SwingParallelCoordinatesComponent;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.swing.SwingITiming;
import com.macrofocus.labeling.EnhancedJLabel;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import com.macrofocus.order.VisibleOrder;
import com.macrofocus.properties.swing.BooleanPropertyButtonModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;

public class SwingParallelCoordinatesView<Row, C>
extends AbstractParallelCoordinatesView<JComponent, Color, Row, C> {
    private static final boolean NEW = false;
    private final JScrollPane nativeComponent;
    private final SwingInteractiveComponent<ParallelCoordinatesLayeredPane> interactiveComponent;
    private ParallelCoordinatesModel<Color, Row, C> model;
    private SwingITiming timing = new SwingITiming("Paint");
    private final Map<AxisModel, SwingAxisComponents> axisComponents = new HashMap<AxisModel, SwingAxisComponents>();
    private final Map<AxisGroupModel, AxisGroupView<JComponent>> axisGroupViews = new HashMap<AxisGroupModel, AxisGroupView<JComponent>>();
    private final Map<Integer, ParallelCoordinatesComponent<JComponent, Color, Row, C>> parallelCoordinatesComponents = new HashMap<Integer, ParallelCoordinatesComponent<JComponent, Color, Row, C>>();
    private boolean isSelectionMode = true;
    private int headerMaximumHeight;
    private LicenseModel licenseModel;
    private JPanel unregisteredPanel;
    private ComponentAdapter unregisteredPanelListener;
    private final ParallelCoordinatesLayoutEngine layoutEngine = new DefaultParallelCoordinatesLayoutEngine((ParallelCoordinatesView)this);
    private ParallelCoordinatesLayout layout;
    private final PropertiesListener propertiesListener = new PropertiesListener<ParallelCoordinatesView.PropertyType>(){

        public void propertyChanged(ParallelCoordinatesView.PropertyType name, PropertyEvent event) {
            if (name == ParallelCoordinatesView.PropertyType.Geometry) {
                SwingParallelCoordinatesView.this.refresh();
            } else if (name == ParallelCoordinatesView.PropertyType.ColorTheme) {
                for (ParallelCoordinatesComponent parallelCoordinatesComponent : SwingParallelCoordinatesView.this.parallelCoordinatesComponents.values()) {
                    ((JComponent)parallelCoordinatesComponent.getNativeComponent()).updateUI();
                }
                ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).updateUI();
                ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).repaint();
            } else if (name == ParallelCoordinatesView.PropertyType.AllowScrolling) {
                SwingParallelCoordinatesView.this.nativeComponent.setHorizontalScrollBarPolicy((Boolean)SwingParallelCoordinatesView.this.getAllowScrolling().getValue() != false ? 30 : 31);
            }
            SwingParallelCoordinatesView.this.createOverPlots();
        }
    };
    private final ParallelCoordinatesListener listener = new ParallelCoordinatesListener(){

        public void pararallelCoordinatesChanged() {
            SwingParallelCoordinatesView.this.reset();
        }
    };
    private final AxisListener axisListener = new AxisListener(){

        public void axisChanged() {
            SwingParallelCoordinatesView.this.refresh();
        }
    };
    private final HierarchyListener axisGroupHierarchyListener = new HierarchyListener(){

        public void hierarchyNodeInserted(HierarchyEvent event) {
            this.update(event);
        }

        public void hierarchyNodeChanged(HierarchyEvent event) {
            this.update(event);
        }

        public void hierarchyNodeRemoved(HierarchyEvent event) {
            this.update(event);
        }

        public void hierarchyStructureChanged(HierarchyEvent event) {
            this.update(event);
        }

        private void update(HierarchyEvent e) {
            SwingParallelCoordinatesView.this.refresh();
        }
    };
    private final OrderListener orderListener = new OrderListener<AxisModel<Row, C>>(){

        public void orderChanged(OrderEvent<AxisModel<Row, C>> event) {
            SwingParallelCoordinatesView.this.refresh();
        }

        public void orderVisibility(OrderEvent<AxisModel<Row, C>> event) {
            if (!((VisibleOrder)event.getModel()).isVisible(event)) {
                for (AxisModel axisModel : event.getAffected()) {
                    SwingParallelCoordinatesView.this.removeAxisView(axisModel);
                }
            }
            SwingParallelCoordinatesView.this.refresh();
        }

        public void orderAdded(OrderEvent<AxisModel<Row, C>> event) {
            SwingParallelCoordinatesView.this.refresh();
        }

        public void orderRemoved(OrderEvent<AxisModel<Row, C>> event) {
            for (AxisModel axisModel : event.getAffected()) {
                SwingParallelCoordinatesView.this.removeAxisView(axisModel);
            }
            SwingParallelCoordinatesView.this.refresh();
        }
    };
    private final PropertyListener<CPCanvas.Rendering> renderingListener = new PropertyListener<CPCanvas.Rendering>(){

        public void propertyChanged(PropertyEvent<CPCanvas.Rendering> event) {
            SwingParallelCoordinatesView.this.createOverPlots();
        }
    };
    private final PropertyListener<Geometry> geometryListener = new PropertyListener<Geometry>(){

        public void propertyChanged(PropertyEvent<Geometry> event) {
            SwingParallelCoordinatesView.this.refresh();
        }
    };

    public SwingParallelCoordinatesView() {
        super((CPColorFactory)SwingFactory.getInstance());
        this.interactiveComponent = new SwingInteractiveComponent((JComponent)new ParallelCoordinatesLayeredPane());
        this.nativeComponent = new JScrollPane();
        JViewport viewport = new JViewport(){};
        viewport.setView(this.interactiveComponent.getNativeComponent());
        this.nativeComponent.setViewport(viewport);
        ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).setOpaque(true);
        ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).updateUI();
        this.properties.addPropertiesListener(this.propertiesListener);
        this.nativeComponent.setHorizontalScrollBarPolicy((Boolean)this.getAllowScrolling().getValue() != false ? 30 : 31);
        ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SwingParallelCoordinatesView.this.refresh();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SwingParallelCoordinatesView.this.refresh();
            }
        });
        ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println("Repaint");
                ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).repaint();
            }
        }, KeyStroke.getKeyStroke(82, SwingHelper.getMultipleSelectionKey()), 1);
        ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println("Repaint");
                SwingParallelCoordinatesView.this.refresh();
            }
        }, KeyStroke.getKeyStroke(76, SwingHelper.getMultipleSelectionKey()), 1);
        ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println("Restart Timer");
                for (ParallelCoordinatesComponent parallelCoordinatesComponent : SwingParallelCoordinatesView.this.parallelCoordinatesComponents.values()) {
                }
                ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).repaint();
            }
        }, KeyStroke.getKeyStroke(84, SwingHelper.getMultipleSelectionKey()), 1);
        ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println("Clearing cache");
                for (ParallelCoordinatesComponent parallelCoordinatesComponent : SwingParallelCoordinatesView.this.parallelCoordinatesComponents.values()) {
                    parallelCoordinatesComponent.clearCache();
                }
                ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).repaint();
            }
        }, KeyStroke.getKeyStroke(67, SwingHelper.getMultipleSelectionKey()), 1);
        ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingParallelCoordinatesView.this.setShowTiming(!SwingParallelCoordinatesView.this.isShowTiming());
            }
        }, KeyStroke.getKeyStroke(66, SwingHelper.getMultipleSelectionKey()), 1);
        this.setLicenseModel(this.licenseModel);
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.interactiveComponent.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.interactiveComponent.addMouseMotionListener(l);
    }

    public void removeMouseListener(CPCanvas.MouseListener l) {
        this.interactiveComponent.removeMouseListener(l);
    }

    public void removeMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.interactiveComponent.removeMouseMotionListener(l);
    }

    void refresh() {
        this.runLayout();
        for (ParallelCoordinatesComponent<JComponent, Color, Row, C> parallelCoordinatesComponent : this.parallelCoordinatesComponents.values()) {
            parallelCoordinatesComponent.clearCache();
            parallelCoordinatesComponent.scheduleUpdate();
        }
        ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).repaint();
    }

    private void reset() {
        if (this.model != null) {
            this.runLayout();
            for (ParallelCoordinatesComponent<JComponent, Color, Row, C> parallelCoordinatesComponent : this.parallelCoordinatesComponents.values()) {
                parallelCoordinatesComponent.reset();
                parallelCoordinatesComponent.scheduleUpdate();
            }
            ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).repaint();
        }
    }

    public SwingParallelCoordinatesView(ParallelCoordinatesModel model) {
        this();
        this.setModel(model);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public JLayeredPane getInteractiveComponent() {
        return (JLayeredPane)this.interactiveComponent.getNativeComponent();
    }

    public int getWidth() {
        return ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).getWidth();
    }

    public int getHeight() {
        return ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).getHeight();
    }

    public boolean isShowTiming() {
        return (Boolean)this.properties.getProperty((Object)ParallelCoordinatesView.PropertyType.ShowTiming).getValue();
    }

    public void setShowTiming(boolean showTiming) {
        this.properties.getProperty((Object)ParallelCoordinatesView.PropertyType.ShowTiming).setValue((Object)showTiming);
        ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).repaint();
    }

    public void setLicenseModel(LicenseModel licenseModel) {
        if (this.unregisteredPanel != null) {
            ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).removeComponentListener(this.unregisteredPanelListener);
            ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).remove(this.unregisteredPanel);
            this.unregisteredPanel = null;
            this.unregisteredPanelListener = null;
        }
        if (licenseModel == null || licenseModel.verify() != LicenseModel.State.Valid) {
            EnhancedJLabel unregisteredLabel = new EnhancedJLabel();
            unregisteredLabel.setEffect(EnhancedLabel.Effect.Outline);
            String message = licenseModel == null ? "Unregistered version" : licenseModel.verify().toString();
            unregisteredLabel.setText(message);
            unregisteredLabel.setForeground(new Color(0, 0, 0, 63));
            unregisteredLabel.setBackground(new Color(255, 255, 255));
            unregisteredLabel.setEffectOpacity(0.2f);
            this.unregisteredPanel = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    super.paint(g2);
                }
            };
            this.unregisteredPanel.setOpaque(false);
            this.unregisteredPanel.setLayout(new OverlayLayout(this.unregisteredPanel));
            this.unregisteredPanel.add((Component)unregisteredLabel);
            unregisteredLabel.setFont(unregisteredLabel.getFont().deriveFont(1, 32.0f));
            ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).add((Component)this.unregisteredPanel, JLayeredPane.MODAL_LAYER);
            this.unregisteredPanelListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingHelper.centerBottom((Container)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent(), (Component)SwingParallelCoordinatesView.this.unregisteredPanel);
                }
            };
            ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).addComponentListener(this.unregisteredPanelListener);
        }
    }

    public ParallelCoordinatesLayout getParallelCoordinatesLayout() {
        return this.layout;
    }

    public ParallelCoordinatesModel getModel() {
        return this.model;
    }

    public void setModel(ParallelCoordinatesModel model) {
        if (this.model != null) {
            this.model.removeParallelCoordinateListener(this.listener);
            Hierarchy groupHierarchy = this.model.getAxisHierarchy().getAxisGroupHierarchy();
            groupHierarchy.removeHierarchyListener(this.axisGroupHierarchyListener);
            ((AxisGroupModel)groupHierarchy.getRoot()).getAxisOrder().removeOrderListener(this.orderListener);
        }
        this.model = model;
        Component[] components = ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).getComponentsInLayer(JLayeredPane.PALETTE_LAYER);
        for (Component component : components) {
            ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).remove(component);
        }
        components = ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).getComponentsInLayer(JLayeredPane.POPUP_LAYER);
        for (Component component : components) {
            ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).remove(component);
        }
        components = ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).getComponentsInLayer(JLayeredPane.DRAG_LAYER);
        for (Component component : components) {
            ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).remove(component);
        }
        components = ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
        for (Component component : components) {
            ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).remove(component);
        }
        this.axisComponents.clear();
        for (ParallelCoordinatesComponent parallelCoordinatesComponent : this.parallelCoordinatesComponents.values()) {
            parallelCoordinatesComponent.setModel(null);
        }
        this.parallelCoordinatesComponents.clear();
        if (this.model != null) {
            model.addParallelCoordinatesListener(this.listener);
            Hierarchy groupHierarchy = this.model.getAxisHierarchy().getAxisGroupHierarchy();
            groupHierarchy.addHierarchyListener(this.axisGroupHierarchyListener);
            ((AxisGroupModel)groupHierarchy.getRoot()).getAxisOrder().addOrderListener(this.orderListener);
            for (AxisGroupModel groupModel : groupHierarchy.breadthFirstIterator()) {
                for (AxisModel axisModel : groupModel.getAxisOrder()) {
                    this.getParallelPanel(axisModel);
                }
            }
        }
        this.refresh();
    }

    public void runLayout() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Dimension containerSize = ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).getSize();
                if (SwingParallelCoordinatesView.this.model == null || containerSize.height <= 0 || containerSize.width <= 0) {
                    return;
                }
                SwingAxisView axisView = SwingParallelCoordinatesView.this.createDummyAxisView();
                SwingParallelCoordinatesView.this.layout = SwingParallelCoordinatesView.this.layoutEngine.doLayout(axisView.getPreferredWidth(), axisView.getBeforeTrackGap(), axisView.getAfterTrackGap());
                for (int l = 0; l < SwingParallelCoordinatesView.this.layout.getLevelCount(); ++l) {
                    Rectangle2D bounds = SwingParallelCoordinatesView.this.layout.getLevelBounds(l);
                    if (bounds == null) continue;
                    ((JComponent)SwingParallelCoordinatesView.this.getParallelCoordinatesComponent(l).getNativeComponent()).setBounds((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
                }
                for (AxisGroupModel axisGroup : SwingParallelCoordinatesView.this.model.getAxisHierarchy().getAxisGroupHierarchy().breadthFirstIterator()) {
                    SwingParallelCoordinatesView.this.doLayout(SwingParallelCoordinatesView.this.model.getAxisHierarchy().getAxisGroupHierarchy(), axisGroup);
                }
                ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).revalidate();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    protected SwingAxisView createDummyAxisView() {
        return new SwingAxisView();
    }

    private void doLayout(Hierarchy<AxisGroupModel<Row, C>> hierarchy, AxisGroupModel<Row, C> axisGroup) {
        AxisGroupView axisGroupView = this.getAxisGroupView(axisGroup);
        if (axisGroupView != null) {
            Rectangle2D rect = this.layout.getHeaderBounds(axisGroup);
            ((JComponent)axisGroupView.getNativeComponent()).setBounds((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        }
        for (AxisModel axisModel : axisGroup.getAxisOrder()) {
            AxisView<JComponent> axisView = this.getAndInstallAxisView(axisModel);
            JButton label = this.getLabel(axisModel);
            switch ((Alignment)this.getAlignment().getValue()) {
                case Left: {
                    label.setHorizontalAlignment(10);
                    break;
                }
                case Center: {
                    label.setHorizontalAlignment(0);
                    break;
                }
                case Fill: {
                    label.setHorizontalAlignment(0);
                    break;
                }
                case Right: {
                    label.setHorizontalAlignment(11);
                }
            }
            Rectangle2D headerBounds = this.layout.getHeaderBounds(axisGroup, axisView.getModel());
            label.setBounds((int)headerBounds.getX(), (int)headerBounds.getY(), (int)headerBounds.getWidth(), (int)headerBounds.getHeight());
            Rectangle2D aBounds = this.layout.getSliderBounds(axisGroup, axisView.getModel());
            ((JComponent)axisView.getNativeComponent()).setBounds((int)aBounds.getX(), (int)aBounds.getY(), (int)aBounds.getWidth(), (int)aBounds.getHeight());
            Rectangle2D axisBounds = this.layout.getBounds(axisGroup, axisView.getModel());
            double x = aBounds.getX() + (double)((JComponent)axisView.getNativeComponent()).getWidth();
            double width = Math.min(headerBounds.getMaxX() - x, axisBounds.getMaxX() - x);
            this.getMaximumLabel(axisModel).setBounds((int)x, (int)aBounds.getY(), (int)width, axisView.getBeforeTrackGap());
            this.getMinimumLabel(axisModel).setBounds((int)x, (int)aBounds.getY() + (int)aBounds.getHeight() - axisView.getAfterTrackGap(), (int)width, axisView.getBeforeTrackGap());
        }
        for (AxisGroupModel child : hierarchy.getChildren(axisGroup)) {
            this.doLayout(hierarchy, child);
        }
    }

    public int getAxisX(AxisGroupModel axisGroup, AxisModel axisModel) {
        return (int)this.layout.getTrackBounds(axisGroup, axisModel).getX();
    }

    public int getHeaderAxisGroupMaximumHeight() {
        return this.headerMaximumHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParallelCoordinatesComponent<JComponent, Color, Row, C> getParallelCoordinatesComponent(int level) {
        if (!this.parallelCoordinatesComponents.containsKey(level)) {
            Map<Integer, ParallelCoordinatesComponent<JComponent, Color, Row, C>> map = this.parallelCoordinatesComponents;
            synchronized (map) {
                SwingParallelCoordinatesComponent parallelCoordinatesComponent = new SwingParallelCoordinatesComponent(this, level);
                parallelCoordinatesComponent.setModel(this.model);
                this.parallelCoordinatesComponents.put(level, (ParallelCoordinatesComponent<JComponent, Color, Row, C>)parallelCoordinatesComponent);
                ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).add((Component)parallelCoordinatesComponent.getNativeComponent(), JLayeredPane.DEFAULT_LAYER);
            }
        }
        return this.parallelCoordinatesComponents.get(level);
    }

    public int getHeaderAxisMaximumHeight() {
        return this.headerMaximumHeight;
    }

    JPopupMenu getPopupMenu() {
        return new ParallelCoordinatesPopupMenu(this.model, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwingAxisComponents getParallelPanel(final AxisModel axisModel) {
        if (!this.axisComponents.containsKey(axisModel)) {
            AxisModel axisModel2 = axisModel;
            synchronized (axisModel2) {
                Runnable doRun = new Runnable(){

                    @Override
                    public void run() {
                        axisModel.addAxisListener(SwingParallelCoordinatesView.this.axisListener);
                        AxisHeaderView label = SwingParallelCoordinatesView.this.createAxisHeaderView(axisModel);
                        SwingAxisComponents panel = new SwingAxisComponents((JButton)label);
                        SwingAxisView axisView = SwingParallelCoordinatesView.this.createAxisView(axisModel);
                        axisView.setInheritsPopupMenu(true);
                        MouseListener mouseListener = SwingParallelCoordinatesView.this.createAxisMouseListener((JButton)label);
                        if (mouseListener != null) {
                            label.addMouseListener(mouseListener);
                            axisView.addMouseListener(mouseListener);
                        }
                        panel.setAxisView((AxisView)axisView);
                        SwingParallelCoordinatesView.this.createAxisController((JButton)label, axisView);
                        SwingParallelCoordinatesView.this.axisComponents.put(axisModel, panel);
                    }
                };
                doRun.run();
            }
        }
        return this.axisComponents.get(axisModel);
    }

    protected MouseListener createAxisMouseListener(final JButton label) {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    if (!SwingHelper.isMultipleSelectionKey((InputEvent)e)) {
                        for (SwingAxisComponents axisComponents : SwingParallelCoordinatesView.this.axisComponents.values()) {
                            JButton component = axisComponents.getLabel();
                            if (component == label) continue;
                            component.setSelected(false);
                        }
                    }
                } else {
                    JPopupMenu popupMenu;
                    if (!label.isSelected()) {
                        label.setSelected(true);
                        if (!SwingHelper.isMultipleSelectionKey((InputEvent)e)) {
                            for (SwingAxisComponents axisComponents : SwingParallelCoordinatesView.this.axisComponents.values()) {
                                JButton component = axisComponents.getLabel();
                                if (component == label) continue;
                                component.setSelected(false);
                            }
                        }
                    }
                    if ((popupMenu = SwingParallelCoordinatesView.this.getPopupMenu()) != null) {
                        popupMenu.show(label, e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu popupMenu;
                    if (!label.isSelected()) {
                        label.setSelected(true);
                        if (!SwingHelper.isMultipleSelectionKey((InputEvent)e)) {
                            for (SwingAxisComponents axisComponents : SwingParallelCoordinatesView.this.axisComponents.values()) {
                                JButton component = axisComponents.getLabel();
                                if (component == label) continue;
                                component.setSelected(false);
                            }
                        }
                    }
                    if ((popupMenu = SwingParallelCoordinatesView.this.getPopupMenu()) != null) {
                        popupMenu.show(label, e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.requestFocusInWindow();
            }
        };
    }

    protected AxisHeaderView createAxisHeaderView(AxisModel axisModel) {
        AxisHeaderView label = new AxisHeaderView(axisModel);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).requestFocusInWindow(true);
            }
        });
        label.setModel((ButtonModel)new BooleanPropertyButtonModel(axisModel.getButtonModel()));
        return label;
    }

    protected AxisController createAxisController(JButton label, SwingAxisView axisView) {
        return new PopupAxisController(axisView, label, (ParallelCoordinatesView)this);
    }

    protected SwingAxisView createAxisView(AxisModel axisModel) {
        SwingAxisView axisView = new SwingAxisView(axisModel);
        return axisView;
    }

    public JButton getLabel(AxisModel axisModel) {
        final JButton label = this.getParallelPanel(axisModel).getLabel();
        if (label.getParent() == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).add((Component)label, JLayeredPane.PALETTE_LAYER);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return label;
    }

    public JComponent getMinimumLabel(AxisModel axisModel) {
        final JComponent c = this.getParallelPanel(axisModel).getMinLabel();
        if (c.getParent() == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).add((Component)c, JLayeredPane.PALETTE_LAYER);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return c;
    }

    public JComponent getMaximumLabel(AxisModel axisModel) {
        final JComponent c = this.getParallelPanel(axisModel).getMaxLabel();
        if (c.getParent() == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).add((Component)c, JLayeredPane.PALETTE_LAYER);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return c;
    }

    public AxisView<JComponent> getAndInstallAxisView(AxisModel axisModel) {
        final AxisView<JComponent> axisView = this.getParallelPanel(axisModel).getAxisView();
        if (((JComponent)axisView.getNativeComponent()).getParent() == null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).add((Component)axisView.getNativeComponent(), JLayeredPane.PALETTE_LAYER);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return axisView;
    }

    public AxisView<JComponent> getAxisView(AxisModel axisModel) {
        AxisView<JComponent> axisView = this.getParallelPanel(axisModel).getAxisView();
        return axisView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAxisView(AxisModel axisModel) {
        if (this.axisComponents.containsKey(axisModel)) {
            AxisModel axisModel2 = axisModel;
            synchronized (axisModel2) {
                axisModel.removeAxisListener(this.axisListener);
                SwingAxisComponents panel = this.axisComponents.get(axisModel);
                ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).remove(panel.getLabel());
                ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).remove((Component)panel.getAxisView().getNativeComponent());
                ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).remove(panel.getMinLabel());
                ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).remove(panel.getMaxLabel());
                this.axisComponents.remove(axisModel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AxisGroupView getAxisGroupView(AxisGroupModel axisGroup) {
        if (!this.axisGroupViews.containsKey(axisGroup)) {
            AxisGroupView axisGroupView = this.createAxisGroupView(axisGroup);
            if (axisGroupView != null) {
                Map<AxisGroupModel, AxisGroupView<JComponent>> map = this.axisGroupViews;
                synchronized (map) {
                    this.axisGroupViews.put(axisGroup, (AxisGroupView<JComponent>)axisGroupView);
                    ((ParallelCoordinatesLayeredPane)this.interactiveComponent.getNativeComponent()).add((Component)axisGroupView.getNativeComponent(), JLayeredPane.PALETTE_LAYER);
                }
            } else {
                return null;
            }
        }
        return this.axisGroupViews.get(axisGroup);
    }

    protected AxisGroupView createAxisGroupView(AxisGroupModel axisGroup) {
        return new SwingAxisGroupView(axisGroup);
    }

    public void waitUntilReady() {
        for (ParallelCoordinatesComponent<JComponent, Color, Row, C> parallelCoordinatesComponent : this.parallelCoordinatesComponents.values()) {
            parallelCoordinatesComponent.waitUntilReady();
        }
    }

    public Row getClosestRow(int x, int y) {
        if (this.layout != null) {
            for (int l = 0; l < this.layout.getLevelCount(); ++l) {
                ParallelCoordinatesComponent<JComponent, Color, Row, C> component = this.getParallelCoordinatesComponent(l);
                Rectangle b = ((JComponent)component.getNativeComponent()).getBounds();
                if (!b.contains(x, y)) continue;
                return (Row)component.getClosestRow(x - b.x, y - b.y);
            }
        }
        return null;
    }

    public Collection<Row> getRows(Rectangle2D rect) {
        if (this.layout != null) {
            HashSet list = new HashSet();
            for (int l = 0; l < this.layout.getLevelCount(); ++l) {
                Rectangle2D.Double r;
                List rows;
                ParallelCoordinatesComponent<JComponent, Color, Row, C> component = this.getParallelCoordinatesComponent(l);
                Rectangle b = ((JComponent)component.getNativeComponent()).getBounds();
                Rectangle2D.Double cb = new Rectangle2D.Double((double)b.x, (double)b.y, b.getWidth(), b.getHeight());
                if (!cb.intersects(rect) || (rows = component.getRows((Rectangle2D)(r = new Rectangle2D.Double(rect.getX() - (double)b.x, rect.getY() - (double)b.y, rect.getWidth(), rect.getHeight())))) == null) continue;
                list.addAll(rows);
            }
            return list;
        }
        return null;
    }

    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    public void setSelectionMode(boolean value) {
        this.isSelectionMode = value;
    }

    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        this.properties.replaceProperty((Object)ParallelCoordinatesView.PropertyType.ShowFiltered, showFiltered);
        this.createOverPlots();
    }

    public void setRendering(MutableProperty<CPCanvas.Rendering> rendering) {
        if (this.getRendering() != rendering) {
            if (this.getRendering() != null) {
                this.getRendering().removePropertyListener(this.renderingListener);
            }
            this.properties.replaceProperty((Object)ParallelCoordinatesView.PropertyType.Rendering, rendering);
            if (this.getRendering() != null) {
                this.getRendering().addPropertyListener(this.renderingListener);
            }
        }
        this.createOverPlots();
    }

    public void setAntialiasing(MutableProperty<Boolean> antialiasing) {
        this.properties.replaceProperty((Object)ParallelCoordinatesView.PropertyType.Antialiasing, antialiasing);
        this.createOverPlots();
    }

    public void setGeometry(MutableProperty<Geometry> geometry) {
        if (this.getGeometry() != geometry) {
            if (this.getGeometry() != null) {
                this.getGeometry().removePropertyListener(this.geometryListener);
            }
            this.properties.replaceProperty((Object)ParallelCoordinatesView.PropertyType.Geometry, geometry);
            if (this.getGeometry() != null) {
                this.getGeometry().addPropertyListener(this.geometryListener);
            }
        }
        this.refresh();
    }

    private void createOverPlots() {
        for (ParallelCoordinatesComponent<JComponent, Color, Row, C> parallelCoordinatesComponent : this.parallelCoordinatesComponents.values()) {
            parallelCoordinatesComponent.createOverplots();
            parallelCoordinatesComponent.scheduleUpdate();
        }
    }

    private class ParallelCoordinatesLayeredPane
    extends JLayeredPane {
        private ParallelCoordinatesLayeredPane() {
        }

        @Override
        public boolean requestFocusInWindow(boolean temporary) {
            return super.requestFocusInWindow(temporary);
        }

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return false;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            SwingParallelCoordinatesView.this.headerMaximumHeight = SwingParallelCoordinatesView.this.createAxisHeaderView((AxisModel)new DummyAxisModel((String)"T")).getPreferredSize().height;
            SwingParallelCoordinatesView.this.reset();
        }

        @Override
        public void paint(Graphics g) {
            SwingParallelCoordinatesView.this.timing.start();
            Graphics2D g2 = (Graphics2D)g;
            Object antialias = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias != null ? antialias : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            if (((Boolean)SwingParallelCoordinatesView.this.getAntialiasing().getValue()).booleanValue()) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias != null ? antialias : RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            super.paint(g);
            SwingParallelCoordinatesView.this.timing.end();
            if (SwingParallelCoordinatesView.this.isShowTiming()) {
                SwingParallelCoordinatesView.this.timing.draw(g2, ((ParallelCoordinatesLayeredPane)SwingParallelCoordinatesView.this.interactiveComponent.getNativeComponent()).getSize(), 10);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getPreferredSize() {
            if (((Boolean)SwingParallelCoordinatesView.this.getAllowScrolling().getValue()).booleanValue()) {
                int width = 0;
                int height = 0;
                if (SwingParallelCoordinatesView.this.layout != null) {
                    for (int l = 0; l < SwingParallelCoordinatesView.this.layout.getLevelCount(); ++l) {
                        Dimension d = ((JComponent)SwingParallelCoordinatesView.this.getParallelCoordinatesComponent(l).getNativeComponent()).getPreferredSize();
                        width = Math.max(width, d.width);
                        height = Math.max(height, d.height);
                    }
                }
                return new Dimension(width, height);
            }
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }
}

