/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplotmatrix.swing;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.helper.TableHelper;
import com.macrofocus.high_d.scatterplotmatrix.AbstractScatterPlotMatrix;
import com.macrofocus.high_d.scatterplotmatrix.DefaultScatterPlotMatrixModel;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixController;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixModel;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixView;
import com.macrofocus.high_d.scatterplotmatrix.swing.SwingScatterPlotMatrixController;
import com.macrofocus.high_d.scatterplotmatrix.swing.SwingScatterPlotMatrixView;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.java.TableModelDataFrame;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.OverlayLayout;
import javax.swing.table.TableModel;

public class SwingScatterPlotMatrix<R, C>
extends AbstractScatterPlotMatrix<JComponent, Color, R, C> {
    private final JComponent nativeComponent = new JComponent(){};

    public SwingScatterPlotMatrix() {
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.view = this.createView();
        this.view.setLicenseModel(licenseModel);
        this.controller = this.createController(this.view);
        this.nativeComponent.add((Component)this.view.getNativeComponent());
        this.nativeComponent.validate();
    }

    public SwingScatterPlotMatrix(ScatterPlotMatrixModel model) {
        this();
        this.setModel(model);
    }

    public SwingScatterPlotMatrix(DataFrame dataFrame) {
        this();
        this.load(dataFrame);
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API_V1, username, key);
    }

    protected void load(DataFrame dataFrame) {
        this.setModel(this.createScatterPlotMatrixModel(dataFrame));
    }

    protected ScatterPlotMatrixModel createScatterPlotMatrixModel(DataFrame dataFrame) {
        return new DefaultScatterPlotMatrixModel(dataFrame, (CPFactory)SwingFactory.getInstance());
    }

    protected ScatterPlotMatrixView createView() {
        SwingScatterPlotMatrixView view = new SwingScatterPlotMatrixView();
        return view;
    }

    protected ScatterPlotMatrixController createController(ScatterPlotMatrixView view) {
        return new SwingScatterPlotMatrixController(view);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public static void main(String[] args) {
        AbstractScatterPlotMatrix.setLicenseKey((String)"Macrofocus GmbH", (String)"3RCD9-DMQDM-AAEMV-LGN5S-76384-FE5WA");
        TableModel tableModel = TableHelper.createRandomTableModel((int)3, (int)10000, (int)10);
        SwingScatterPlotMatrix scatterPlotMatrix = new SwingScatterPlotMatrix((DataFrame)new TableModelDataFrame(tableModel));
        ScatterPlotMatrixModel model = scatterPlotMatrix.getModel();
        scatterPlotMatrix.getView().getColorTheme().setValue((Object)new LightColorTheme((CPColorFactory)SwingFactory.getInstance()));
        scatterPlotMatrix.getView().getShowTiming().setValue((Object)true);
        ApplicationModel applicationModel = ApplicationModelFactory.HIGHD_API_V1;
        JFrame frame = new JFrame(applicationModel.getName() + " " + applicationModel.getVersion() + ", Copyright (c) " + applicationModel.getCopyright() + " " + applicationModel.getEdition());
        frame.setSize(600, 600);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)scatterPlotMatrix.getNativeComponent());
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

