/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.action;

import com.macrofocus.application.high_d.model.HighDModel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class ReloadAction
extends AbstractAction {
    private final Component contentPane;
    private HighDModel tmm;

    public ReloadAction(Component contentPane, final PropertiesModel propertiesModel, ResourcesModel resourcesModel) {
        this.contentPane = contentPane;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        URL url = resourcesModel.getUrl("Refresh16.gif");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    ReloadAction.this.updateProperties(propertiesModel);
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.tmm.reload(this.contentPane);
    }

    public void setTreeMapModel(HighDModel tmm) {
        this.tmm = tmm;
        this.checkEnabled();
    }

    private void checkEnabled() {
        this.setEnabled(this.tmm != null);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String name = "Reload";
        if (propertiesModel != null && propertiesModel.isAvailable("action.reload.label")) {
            name = (String)propertiesModel.getValue("action.reload.label");
        }
        this.putValue("Name", name);
    }
}

