/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.configuration.swing;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.macrofocus.application.high_d.configuration.HighDColorMapPanelModel;
import com.macrofocus.application.high_d.configuration.swing.RenderingSettingsPanel;
import com.macrofocus.application.high_d.configuration.swing.TextualLegend;
import com.macrofocus.application.high_d.document.HighDConfigurationPanel;
import com.macrofocus.cartoplot.CartoPlotModel;
import com.macrofocus.cartoplot.georeferencing.GeoReferencingService;
import com.macrofocus.cartoplot.swing.georeferencing.SwingGeoReferencingServiceFactory;
import com.macrofocus.colormap.editor.ColorMapPanel;
import com.macrofocus.colormap.editor.ColorMapPanelModel;
import com.macrofocus.colormap.swing.SwingColorMapPanel;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.combobox.MListComboBox;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.swing.MJPanel;
import com.macrofocus.crossplatform.swing.MJScrollPane;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.docking.DockingPanel;
import com.macrofocus.docking.swing.SwingDockingPanel;
import com.macrofocus.hierarchy.Condition;
import com.macrofocus.high_d.HighDFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.swing.ColumnRenderer;
import com.macrofocus.molap.swing.ColumnSelectionComboBoxModel;
import com.macrofocus.properties.swing.PropertyComboBoxModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.swing.print.CopyAction;
import com.macrofocus.util.swing.print.ExportComponentAction;
import com.macrofocus.util.swing.print.PrintComponentAction;
import de.javasoft.taskpane.JYTaskPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jdesktop.swingx.JXCollapsiblePane;

public class SwingHighDConfigurationPanel<Row, Column>
implements HighDConfigurationPanel<JComponent> {
    private JPanel panel;
    private JPanel settingsPanel;
    private MListComboBox colorSettingsComboBox;
    private JLabel colorSettingsLabel;
    private JButton colorExpandButton;
    private JXCollapsiblePane colorPane;
    private JPanel legendContainer;
    private JPanel colorGroupPanel;
    private MListComboBox renderingSettingsComboBox;
    private JButton renderingExpandButton;
    private JXCollapsiblePane renderingPane;
    private JPanel renderingGroupPanel;
    private JSeparator backgroundSeparator;
    private JScrollPane scrollPane;
    private JPanel textualLegend;
    private JPanel legend;
    private JButton georeferencingExpandButton;
    private MListComboBox georeferencingSettingsComboBox;
    private JXCollapsiblePane georeferencingPane;
    private JPanel georeferencingGroupPanel;
    private ColumnSelectionComboBoxModel colorMappingcomboBoxModel;
    private final PropertiesModel propertiesModel;
    private final ColorMapPanel<Column, JComponent, Color> colorMapPanel;
    final SwingDockingPanel dockingPanel;

    public SwingHighDConfigurationPanel(final PropertiesModel propertiesModel) {
        this.propertiesModel = propertiesModel;
        this.$$$setupUI$$$();
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    SwingHighDConfigurationPanel.this.updateProperties(propertiesModel);
                }
            });
        }
        this.updateProperties(propertiesModel);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.colorMapPanel = new SwingColorMapPanel((JComponent)this.legendContainer, (JComponent)this.legend, null, false);
        this.renderingSettingsComboBox.setStretchToFit(true);
        this.renderingSettingsComboBox.setEditable(false);
        this.colorSettingsComboBox.setRenderer((ListCellRenderer)new ColumnRenderer());
        this.colorSettingsComboBox.setStretchToFit(true);
        this.colorSettingsComboBox.setEditable(false);
        this.configureExpandButton(this.renderingExpandButton, this.renderingPane);
        this.configureExpandButton(this.colorExpandButton, this.colorPane);
        this.configureExpandButton(this.georeferencingExpandButton, this.georeferencingPane);
        this.dockingPanel = new SwingDockingPanel();
        this.dockingPanel.setInnerComponent((JComponent)this.panel);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add((Action)new CopyAction("Copy Graphics", (Component)this.legend));
        try {
            popupMenu.add((Action)new ExportComponentAction("Export Graphics...", (JComponent)this.legend, false));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        popupMenu.add((Action)new PrintComponentAction("Print...", (Component)this.legend));
        this.legend.setComponentPopupMenu(popupMenu);
    }

    public void setModel(HighDFactory<?, Color, ?, ?, Row, Column, ?> model, final CartoPlotModel<Color, ?, ?> cartoPlotModel) {
        this.renderingSettingsComboBox.setModel((ComboBoxModel)new PropertyComboBoxModel(model.getRendering(), (Object[])CPCanvas.Rendering.values()));
        this.renderingPane.setLayout((LayoutManager)new BorderLayout());
        this.renderingPane.add((Component)new RenderingSettingsPanel<Row, Column>(model).getMainPanel());
        MutableColorMapping colormapping = model.getVisual().getColorMapping();
        this.colorMappingcomboBoxModel = new ColumnSelectionComboBoxModel(colormapping.getColorSelection(), model.getDataFrame(), false, true, new Condition<Column>(){

            public boolean accept(Column node) {
                return true;
            }
        });
        this.colorSettingsComboBox.setModel((ComboBoxModel)this.colorMappingcomboBoxModel);
        this.colorMapPanel.setModel((ColorMapPanelModel)new HighDColorMapPanelModel(colormapping));
        this.colorPane.setLayout((LayoutManager)new BorderLayout());
        ((JComponent)this.colorMapPanel.getNativeComponent()).setBorder(new TitledBorder(""));
        this.colorPane.add((Component)this.colorMapPanel.getNativeComponent());
        this.colorPane.validate();
        DefaultComboBoxModel<GeoReferencingService> geoReferencingComboBoxModel = new DefaultComboBoxModel<GeoReferencingService>();
        DataFrame dataFrame = model.getDataFrame();
        SwingGeoReferencingServiceFactory geoReferencingServiceFactory = SwingGeoReferencingServiceFactory.getInstance((DataFrame)dataFrame);
        for (GeoReferencingService geoReferencingService : geoReferencingServiceFactory.getGeoReferencingServices()) {
            geoReferencingComboBoxModel.addElement(geoReferencingService);
        }
        this.georeferencingSettingsComboBox.setModel(geoReferencingComboBoxModel);
        this.georeferencingSettingsComboBox.setSelectedItem((Object)cartoPlotModel.getGeoReferencingService());
        this.georeferencingSettingsComboBox.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                GeoReferencingService geoReferencingService = (GeoReferencingService)SwingHighDConfigurationPanel.this.georeferencingSettingsComboBox.getSelectedItem();
                cartoPlotModel.setGeoReferencingService(geoReferencingService);
                SwingHighDConfigurationPanel.this.georeferencingPane.removeAll();
                SwingHighDConfigurationPanel.this.georeferencingPane.setLayout((LayoutManager)new BorderLayout());
                SwingHighDConfigurationPanel.this.georeferencingPane.add((Component)geoReferencingService.getEditor());
                SwingHighDConfigurationPanel.this.georeferencingPane.validate();
                SwingHighDConfigurationPanel.this.panel.revalidate();
            }
        });
        this.georeferencingPane.setLayout((LayoutManager)new BorderLayout());
        this.georeferencingPane.add((Component)((JComponent)cartoPlotModel.getGeoReferencingService().getEditor()));
        this.georeferencingPane.validate();
    }

    public SwingDockingPanel getMainPanel() {
        return this.dockingPanel;
    }

    private JButton createExpandButton() {
        JYTaskPane taskPane = new JYTaskPane();
        taskPane.setCollapsed(true);
        Container child = (Container)taskPane.getComponent(0);
        JButton button = (JButton)child.getComponent(2);
        return button;
    }

    private void configureExpandButton(JButton button, JXCollapsiblePane pane) {
        button.setAction(pane.getActionMap().get("toggle"));
        button.setText(null);
        pane.setCollapsed(true);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        if (propertiesModel != null) {
            this.colorSettingsLabel.setText((String)propertiesModel.getValue("control.color.label"));
        }
    }

    private void createUIComponents() {
        this.panel = new MJPanel();
        this.scrollPane = new MJScrollPane();
        this.renderingSettingsComboBox = new MListComboBox();
        this.colorSettingsComboBox = new MListComboBox();
        this.georeferencingSettingsComboBox = new MListComboBox();
        this.renderingExpandButton = this.createExpandButton();
        this.colorExpandButton = this.createExpandButton();
        this.georeferencingExpandButton = this.createExpandButton();
        this.colorGroupPanel = new GroupPanel();
        this.renderingGroupPanel = new GroupPanel();
        this.georeferencingGroupPanel = new GroupPanel();
        this.textualLegend = new TextualLegend();
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.panel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setOpaque(true);
        this.panel.add((Component)this.scrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 5, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.scrollPane.setViewportView(this.settingsPanel);
        Spacer spacer1 = new Spacer();
        this.settingsPanel.add((Component)spacer1, new GridConstraints(6, 2, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.backgroundSeparator = new JSeparator();
        this.backgroundSeparator.setVisible(false);
        this.settingsPanel.add((Component)this.backgroundSeparator, new GridConstraints(5, 0, 1, 3, 0, 3, 4, 0, null, null, null, 1, false));
        JSeparator separator1 = new JSeparator();
        this.settingsPanel.add((Component)separator1, new GridConstraints(4, 0, 1, 3, 0, 3, 2, 0, null, null, null, 1, false));
        this.colorGroupPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.colorGroupPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.colorGroupPanel.add((Component)this.colorSettingsComboBox, new GridConstraints(0, 2, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.colorPane = new JXCollapsiblePane();
        this.colorPane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.colorGroupPanel.add((Component)this.colorPane, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 1, false));
        this.colorExpandButton.setMargin(new Insets(0, 2, 0, 5));
        this.colorExpandButton.setText("+");
        this.colorGroupPanel.add((Component)this.colorExpandButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.colorSettingsLabel = new JLabel();
        Font colorSettingsLabelFont = this.$$$getFont$$$(null, 1, -1, this.colorSettingsLabel.getFont());
        if (colorSettingsLabelFont != null) {
            this.colorSettingsLabel.setFont(colorSettingsLabelFont);
        }
        this.colorSettingsLabel.setHorizontalAlignment(2);
        this.colorSettingsLabel.setHorizontalTextPosition(2);
        this.colorSettingsLabel.setText("Color:");
        this.colorGroupPanel.add((Component)this.colorSettingsLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.renderingGroupPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.renderingGroupPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.renderingGroupPanel.add((Component)this.renderingSettingsComboBox, new GridConstraints(0, 2, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.renderingPane = new JXCollapsiblePane();
        this.renderingPane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.renderingGroupPanel.add((Component)this.renderingPane, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 1, false));
        this.renderingExpandButton.setMargin(new Insets(0, 2, 0, 5));
        this.renderingExpandButton.setText("+");
        this.renderingGroupPanel.add((Component)this.renderingExpandButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        Font label1Font = this.$$$getFont$$$(null, 1, -1, label1.getFont());
        if (label1Font != null) {
            label1.setFont(label1Font);
        }
        label1.setHorizontalAlignment(2);
        label1.setHorizontalTextPosition(2);
        label1.setText("Rendering:");
        this.renderingGroupPanel.add((Component)label1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JSeparator separator2 = new JSeparator();
        this.settingsPanel.add((Component)separator2, new GridConstraints(1, 0, 1, 3, 0, 3, 4, 0, null, null, null, 1, false));
        this.georeferencingGroupPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.settingsPanel.add((Component)this.georeferencingGroupPanel, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, true));
        this.georeferencingGroupPanel.add((Component)this.georeferencingSettingsComboBox, new GridConstraints(0, 2, 1, 1, 0, 1, 5, 3, new Dimension(0, -1), new Dimension(0, -1), null, 0, false));
        this.georeferencingPane = new JXCollapsiblePane();
        this.georeferencingPane.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.georeferencingGroupPanel.add((Component)this.georeferencingPane, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 3, new Dimension(0, -1), new Dimension(0, -1), null, 1, false));
        this.georeferencingExpandButton.setMargin(new Insets(0, 2, 0, 5));
        this.georeferencingExpandButton.setText("+");
        this.georeferencingGroupPanel.add((Component)this.georeferencingExpandButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        Font label2Font = this.$$$getFont$$$(null, 1, -1, label2.getFont());
        if (label2Font != null) {
            label2.setFont(label2Font);
        }
        label2.setHorizontalAlignment(2);
        label2.setHorizontalTextPosition(2);
        label2.setText("Georeferencing:");
        this.georeferencingGroupPanel.add((Component)label2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.legend = new JPanel();
        this.legend.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.panel.add((Component)this.legend, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.legend.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4), null, 0, 0, null, null));
        this.legend.add((Component)this.textualLegend, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 0, new Dimension(0, -1), null, null, 0, false));
        this.legendContainer = new JPanel();
        this.legendContainer.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.legend.add((Component)this.legendContainer, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.colorSettingsLabel.setLabelFor((Component)this.colorSettingsComboBox);
        label1.setLabelFor((Component)this.renderingSettingsComboBox);
        label2.setLabelFor((Component)this.renderingSettingsComboBox);
    }

    private Font $$$getFont$$$(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    public DockingPanel getDockingPanel() {
        return this.dockingPanel;
    }

    public JPanel getColorGroupPanel() {
        return this.colorGroupPanel;
    }

    public JPanel getRenderingGroupPanel() {
        return this.renderingGroupPanel;
    }

    public JButton getColorExpandButton() {
        return this.colorExpandButton;
    }

    public JButton getRenderingExpandButton() {
        return this.renderingExpandButton;
    }

    public void setAnimated(boolean animated) {
        this.colorPane.setAnimated(animated);
        this.renderingPane.setAnimated(animated);
    }

    public ColorMapPanel getColorMapPanel() {
        return this.colorMapPanel;
    }

    public MListComboBox getColorSettingsComboBox() {
        return this.colorSettingsComboBox;
    }

    public JPanel getLegend() {
        return this.legend;
    }

    public CPComponent<JComponent> getMainComponent() {
        return SwingFactory.getInstance().createComponent((JComponent)this.dockingPanel);
    }

    private class GroupPanel
    extends MJPanel {
        private GroupPanel() {
            this.setBorder(new EmptyBorder(5, 0, 5, 0));
        }
    }
}

