/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document.swing;

import com.jidesoft.grid.BooleanCheckBoxCellRenderer;
import com.jidesoft.grid.CellEditorManager;
import com.jidesoft.grid.CellRendererManager;
import com.jidesoft.grid.HyperlinkTableCellEditorRenderer;
import com.jidesoft.swing.JideButton;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.application.document.DocumentBasedApplication;
import com.macrofocus.application.document.DocumentBasedApplicationState;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.document.View;
import com.macrofocus.application.document.swing.ReloadUICommand;
import com.macrofocus.application.document.swing.SwingDragDropHere;
import com.macrofocus.application.document.swing.SwingSDIDocumentBasedApplication;
import com.macrofocus.application.file.CPDirectoryChooser;
import com.macrofocus.application.file.SwingDirectoryChooser;
import com.macrofocus.application.high_d.HighDResource;
import com.macrofocus.application.high_d.document.HighDDocument;
import com.macrofocus.application.high_d.document.HighDView;
import com.macrofocus.application.high_d.document.JavaHighDApplication;
import com.macrofocus.application.high_d.document.JavaHighDDocument;
import com.macrofocus.application.high_d.document.PopulateOpenDatasetCommand;
import com.macrofocus.application.high_d.document.persistence.HighDPersistence;
import com.macrofocus.application.high_d.document.swing.SwingHighDStatusBar;
import com.macrofocus.application.high_d.document.swing.SwingHighDView;
import com.macrofocus.application.high_d.swing.HighD;
import com.macrofocus.application.logging.DetailsDialogLoggingOutput;
import com.macrofocus.application.status.CPStatusBar;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.cartoplot.swing.SwingCartoPlot;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.file.CartoPlotFileType;
import com.macrofocus.common.file.CommaDelimitedFileType;
import com.macrofocus.common.file.FileType;
import com.macrofocus.common.file.GeoJSONFileType;
import com.macrofocus.common.file.HighDFileType;
import com.macrofocus.common.file.InfoScopeFileType;
import com.macrofocus.common.file.JsonFileType;
import com.macrofocus.common.file.MicrosoftAccessFileType;
import com.macrofocus.common.file.MicrosoftExcelFileType;
import com.macrofocus.common.file.ODFSpreadsheetFileType;
import com.macrofocus.common.file.ParquetFileType;
import com.macrofocus.common.file.SASFileType;
import com.macrofocus.common.file.SPSSFileType;
import com.macrofocus.common.file.ShapefileFileType;
import com.macrofocus.common.file.TabDelimitedFileType;
import com.macrofocus.common.file.TreeMapFileType;
import com.macrofocus.common.logging.Logging;
import com.macrofocus.crossplatform.swing.SwingExecutor;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.data.dataframe.DataFrameTableModel;
import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.data.source.DataSource;
import com.macrofocus.data.source.DataSourceFactory;
import com.macrofocus.data.table.JSONTableModel;
import com.macrofocus.data.table.TableHelper;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.high_d.HighDFactory;
import com.macrofocus.high_d.command.ResetFiltersCommand;
import com.macrofocus.high_d.distributions.swing.SwingDistributions;
import com.macrofocus.high_d.mds.tsne.JavaMatrixOperationsFactory;
import com.macrofocus.high_d.mds.tsne.MatrixOperationsFactory;
import com.macrofocus.high_d.parallelcoordinates.swing.SwingParallelCoordinates;
import com.macrofocus.high_d.parallelcoordinatesmatrix.swing.SwingParallelCoordinatesMatrix;
import com.macrofocus.high_d.scatterplot.AbstractScatterPlot;
import com.macrofocus.high_d.scatterplotmatrix.AbstractScatterPlotMatrix;
import com.macrofocus.high_d.tablelens.swing.SwingTableLens;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.igraphics.colortheme.DarkColorTheme;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.JsonDataFrame;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.molap.exporter.java.SwingDataFrameExporter;
import com.macrofocus.molap.persistence.DefaultDataSourcePersistence;
import com.macrofocus.palette.PaletteFactory;
import com.macrofocus.palette.swing.SwingPaletteFactory;
import com.macrofocus.persistence.DefaultElementFactory;
import com.macrofocus.persistence.Element;
import com.macrofocus.persistence.ElementFactory;
import com.macrofocus.persistence.JsonMLElement;
import com.macrofocus.persistence.xml.XmlElementSerializer;
import com.macrofocus.persistence.xom.XomElement;
import com.macrofocus.persistence.xom.XomElementFactory;
import com.macrofocus.resources.ResourceBundleResourcesModel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.WeakResourcesModel;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.swing.MComboBox;
import com.macrofocus.timer.CPExecutor;
import com.macrofocus.util.logging.MacrofocusLogFactory;
import com.macrofocus.util.logging.SwingLogging;
import com.macrofocus.util.logging.SwingLoggingOutput;
import com.macrofocus.util.swing.action.AboutAction;
import com.macrofocus.util.swing.plaf.action.NamedLookAndFeelAction;
import com.macrofocus.util.swing.table.SimpleTableCellRenderer;
import com.macrofocus.util.update.CheckForUpdateAction;
import com.macrofocus.util.update.NewUpdateAction;
import com.macrofocus.util.update.NoUpdateAction;
import com.macrofocus.util.update.UpdateAction;
import com.macrofocus.visual.Visual;
import com.treemap.swing.SwingTreeMap;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessControlException;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import nu.xom.Document;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONML;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SwingHighDApplication
extends SwingSDIDocumentBasedApplication<JavaHighDDocument, HighDView<JComponent, JavaHighDDocument>>
implements JavaHighDApplication<JFrame, JComponent, File, JavaHighDDocument> {
    private final String lf;
    private final boolean expert;
    private Image applicationIcon;
    private ResourcesModel resourcesModel;
    private CPDirectoryChooser<JFrame, File> directoryChooser;
    final PropertyChangeListener rootPaneListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SwingHighDApplication.this.setColorTheme((CPColor)new SwingColor(UIManager.getColor("Panel.background")));
        }
    };

    public SwingHighDApplication(String lf, boolean expert) {
        this.lf = lf;
        this.expert = expert;
        this.allowNewDocument = true;
        this.startWithNewDocument = true;
        this.exitOnClose = false;
    }

    @Override
    public String[] getRecent() {
        return (String[])this.getResourcesModel().getPropertiesModel().getValue("high-d.recent");
    }

    @Override
    public void init() {
        SwingParallelCoordinates.setLicenseKey((String)"Macrofocus GmbH", (String)"U5RND-ZB843-M36YR-B9XA6-4V26U-CGP8N");
        SwingParallelCoordinatesMatrix.setLicenseKey((String)"Macrofocus GmbH", (String)"U5RND-ZB843-M36YR-B9XA6-4V26U-CGP8N");
        AbstractScatterPlot.setLicenseKey((String)"Macrofocus GmbH", (String)"U5RND-ZB843-M36YR-B9XA6-4V26U-CGP8N");
        AbstractScatterPlotMatrix.setLicenseKey((String)"Macrofocus GmbH", (String)"U5RND-ZB843-M36YR-B9XA6-4V26U-CGP8N");
        SwingDistributions.setLicenseKey((String)"Macrofocus GmbH", (String)"U5RND-ZB843-M36YR-B9XA6-4V26U-CGP8N");
        SwingTableLens.setLicenseKey((String)"Macrofocus GmbH", (String)"U5RND-ZB843-M36YR-B9XA6-4V26U-CGP8N");
        SwingCartoPlot.setLicenseKey((String)"Macrofocus GmbH", (String)"NVH74-CGFJL-RMERD-GYG28-L8DVD-GGUDN");
        SwingTreeMap.setLicenseKey((String)"Macrofocus GmbH", (String)"5SP5S-AJ5RV-MCRKQ-F32W4-V4QWR-AGP8E");
        new NamedLookAndFeelAction(this.lf).perform();
        this.initJide();
        this.initSynthetica();
        this.initLogging();
        super.init();
        this.getApplicationState().addListener(new DocumentBasedApplicationState.Listener(){

            public void closing() {
                SwingHighDApplication.this.getResourcesModel().savePreferences();
            }

            public void recentChanged() {
                String[] urls = SwingHighDApplication.this.getApplicationState().getRecentURLs();
                SwingHighDApplication.this.getResourcesModel().getPropertiesModel().setValue("high-d.recent", (Object)urls);
                SwingHighDApplication.this.getResourcesModel().savePreferences();
            }
        });
        this.autoCheckForUpdate();
    }

    public void autoCheckForUpdate() {
        try {
            Component mainFrame = null;
            final CheckForUpdateAction autoCheckForUpdateAction = this.createCheckForUpdateAction(mainFrame, true);
            autoCheckForUpdateAction.setUpdateAction((Action)new NewUpdateAction(mainFrame, this.getApplicationModel(), this.createUpdateAction()));
            autoCheckForUpdateAction.setNoUpdateAction(null);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (autoCheckForUpdateAction != null) {
                            autoCheckForUpdateAction.actionPerformed(new ActionEvent(this, 0, null));
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                    }
                    catch (RuntimeException runtimeException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }).start();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public CheckForUpdateAction createCheckForUpdateAction(Component mainFrame, boolean checkSchedule) {
        PropertiesModel propertiesModel = this.getResourcesModel().getPropertiesModel();
        CheckForUpdateAction checkForUpdateAction = new CheckForUpdateAction("http://www.high-d.com/installers/updates.xml", checkSchedule, propertiesModel);
        checkForUpdateAction.setUpdateAction((Action)this.createUpdateAction());
        checkForUpdateAction.setNoUpdateAction((Action)new NoUpdateAction(mainFrame));
        return checkForUpdateAction;
    }

    public UpdateAction createUpdateAction() {
        return new UpdateAction("699");
    }

    private void initJide() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    CellRendererManager.initDefaultRenderer();
                    CellRendererManager.registerRenderer(Boolean.class, (TableCellRenderer)new BooleanCheckBoxCellRenderer());
                    CellEditorManager.initDefaultEditor();
                    CellEditorManager.registerEditor(Boolean.class, () -> new DefaultCellEditor((JCheckBox)new BooleanCheckBoxCellRenderer()));
                    HyperlinkTableCellEditorRenderer renderer = new HyperlinkTableCellEditorRenderer(){
                        private final SimpleTableCellRenderer nullComponent = new SimpleTableCellRenderer();

                        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                            if (value == null) {
                                value = "";
                            }
                            if (value != null) {
                                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
                            }
                            return null;
                        }

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            if (value == null) {
                                value = "";
                            }
                            if (value != null) {
                                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            }
                            return this.nullComponent;
                        }
                    };
                    renderer.setActionListener(e -> {
                        Object source = e.getSource();
                        try {
                            JideButton button = (JideButton)source;
                            String text = button.getText();
                            if (text != null && text.length() > 0) {
                                URL value = new URL(text);
                                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                                    try {
                                        Desktop.getDesktop().browse(value.toURI());
                                    }
                                    catch (IOException e1) {
                                        e1.printStackTrace();
                                    }
                                    catch (URISyntaxException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            }
                        }
                        catch (MalformedURLException e1) {
                            e1.printStackTrace();
                        }
                    });
                    CellRendererManager.registerRenderer(URL.class, (TableCellRenderer)renderer);
                    CellEditorManager.registerEditor(URL.class, () -> renderer);
                }
                catch (NoClassDefFoundError e2) {
                    e2.printStackTrace();
                }
                catch (AccessControlException e3) {
                    e3.printStackTrace();
                }
                catch (RuntimeException e4) {
                    e4.printStackTrace();
                }
            }
        });
    }

    private void initSynthetica() {
        UIManager.put("SidePane.alwaysShowTabText", Boolean.TRUE);
    }

    private void initLogging() {
        SwingLogging.setCommonsLogFactory(MacrofocusLogFactory.class);
        SwingLogging.getInstance().setOutput(new SwingLoggingOutput[]{new DetailsDialogLoggingOutput(null)});
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.ERROR);
    }

    @Override
    public CPDirectoryChooser<JFrame, File> getDirectoryChooser() {
        if (this.directoryChooser == null) {
            this.directoryChooser = new SwingDirectoryChooser();
        }
        return this.directoryChooser;
    }

    @Override
    protected Image getApplicationIcon() {
        if (this.applicationIcon == null) {
            this.applicationIcon = new ImageIcon(HighDResource.class.getResource("icon32x32.gif")).getImage();
        }
        return this.applicationIcon;
    }

    @Override
    public ResourcesModel getResourcesModel() {
        if (this.resourcesModel == null) {
            this.resourcesModel = new ResourceBundleResourcesModel(HighDResource.class, HighDResource.class, Locale.getDefault(), HighDResource.getPreferences());
        }
        return this.resourcesModel;
    }

    public ResourcesModel createResourcesModel() {
        return new WeakResourcesModel(this.getResourcesModel());
    }

    @Override
    public void configureWindow(JFrame window) {
        super.configureWindow(window);
        window.getRootPane().addPropertyChangeListener("UI", this.rootPaneListener);
        this.setColorTheme((CPColor)new SwingColor(UIManager.getColor("Panel.background")));
    }

    @Override
    public void closeWindow(CPWindow<JFrame, JComponent> window) {
        ((JFrame)window.getNativeWindow()).getRootPane().removePropertyChangeListener("UI", this.rootPaneListener);
        super.closeWindow(window);
    }

    @Override
    protected CPStatusBar<JComponent> createStatusBar(CPWindow<JFrame, JComponent> window, HighDView<JComponent, JavaHighDDocument> view) {
        SwingHighDStatusBar statusBar = new SwingHighDStatusBar(new ShowAboutAction(this, window), this.createResourcesModel(), null);
        if (view.getDocument() != null) {
            HighDFactory highDFactory = view.getHighDFactory();
            Visual visual = highDFactory.getVisual();
            statusBar.setModel(highDFactory.getDataFrame(), visual.getSelection(), visual.getFilter(), visual.getColoring(), (Command)new ResetFiltersCommand(highDFactory));
        }
        return statusBar;
    }

    private void setColorTheme(CPColor background) {
        LightColorTheme colorTheme = background.lum() > SwingFactory.getInstance().getGray().lum() ? new LightColorTheme((CPColorFactory)SwingFactory.getInstance()) : new DarkColorTheme((CPColorFactory)SwingFactory.getInstance());
        for (HighDView view : this.getApplicationState().getViews()) {
            if (view.getDocument() == null) continue;
            ((JavaHighDDocument)view.getDocument()).getSettings().getColorTheme().setValue((Object)colorTheme);
        }
    }

    public HighDView<JComponent, JavaHighDDocument> createView(JFrame window, JavaHighDDocument document) {
        SwingHighDView view = new SwingHighDView(this, window, this.expert, this.createLocalProperties());
        view.init();
        view.setDocument(document);
        return view;
    }

    @Override
    protected void customizeEmptyView(SwingDragDropHere dragDropHere, CPWindow<JFrame, JComponent> window) {
        super.customizeEmptyView(dragDropHere, window);
        JLabel label = new JLabel();
        label.setText("<html>or load document from <b>server</b></html>");
        label.setVerticalTextPosition(3);
        label.setHorizontalTextPosition(0);
        label.setForeground(Color.GRAY);
        label.setFont(new Font("Monospace", 0, 24));
        dragDropHere.addComponent(label);
        final MComboBox onlineMenu = new MComboBox();
        onlineMenu.addItem(null);
        dragDropHere.addComponent((JComponent)onlineMenu);
        String servers = "https://public.high-d.com/";
        if (servers != null) {
            for (String server : servers.split(",")) {
                this.runAsyncBackground(new PopulateOpenDatasetCommand<JFrame, JComponent>(this, window, server), new DocumentBasedApplication.Callback<PopulateOpenDatasetCommand<JFrame, JComponent>, Object>(){

                    public Object execute(final PopulateOpenDatasetCommand<JFrame, JComponent> arg) {
                        SwingHighDApplication.this.runAsyncUIThread(new Command(){
                            private final WeakActionListeners actionListeners = new WeakActionListeners();

                            public void execute() {
                                List<UICommand> commands = arg.getCommands();
                                for (UICommand command : commands) {
                                    onlineMenu.addItem((Object)command);
                                }
                                onlineMenu.addActionListener(this.actionListeners.create(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        UICommand selectedItem = (UICommand)onlineMenu.getSelectedItem();
                                        if (selectedItem != null) {
                                            selectedItem.execute((Object)this);
                                        }
                                    }
                                }, (Object)onlineMenu));
                            }
                        });
                        return null;
                    }
                });
            }
        }
    }

    public JavaHighDDocument openLocalDocument(File file, String content, JFrame window) throws OpenDocumentException {
        if (file.getName().endsWith(".json")) {
            try {
                JsonObject treeMap;
                String json = JSONTableModel.convertStreamToString((InputStream)new FileInputStream(file));
                JsonObject root = (JsonObject)Json.instance().parse(json);
                JsonArray data = (JsonArray)root.get("data");
                JsonDataFrame dataFrame = new JsonDataFrame(data);
                dataFrame = new DefaultDataFrame((DataFrame)dataFrame, true);
                JavaHighDDocument document = new JavaHighDDocument(file.getName(), file.toURI().toURL().toExternalForm(), (DataFrame<Integer, String, Object>)dataFrame, null, SwingFactory.getInstance(), SwingColorMapFactory.getInstance(), (MatrixOperationsFactory)JavaMatrixOperationsFactory.getInstance(), (CPExecutor)new SwingExecutor(), null);
                if (root instanceof JsonObject && (treeMap = (JsonObject)root.get("High-D")) != null) {
                    DefaultElementFactory elementFactory = new DefaultElementFactory();
                    HighDPersistence persistance = new HighDPersistence(document, (CPColorFactory)SwingFactory.getInstance(), (CPFontFactory)SwingFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), (ElementFactory)elementFactory);
                    persistance.load((Element)new JsonMLElement(treeMap));
                }
                return document;
            }
            catch (FileNotFoundException e) {
                throw new OpenDocumentException("File not found " + file.getName(), (Throwable)e);
            }
            catch (IOException e) {
                throw new OpenDocumentException("Could not read file " + file.getName(), (Throwable)e);
            }
            catch (NullPointerException e) {
                throw new OpenDocumentException("Could not decode file " + file.getName(), (Throwable)e);
            }
            catch (Throwable e) {
                throw new OpenDocumentException("Unknown error reading " + file.getName(), e);
            }
        }
        try {
            DataSource dataSource = DataSourceFactory.getDataSource((File)file);
            MutableDataFrame dataFrame = dataSource.loadDataFrame((Component)window);
            HighDDocument document = this.createDocument(file.getName(), file.toURI().toURL().toExternalForm(), dataSource, dataFrame);
            return document;
        }
        catch (FileNotFoundException e) {
            throw new OpenDocumentException("File not found " + file.getName(), (Throwable)e);
        }
        catch (IOException e) {
            throw new OpenDocumentException("Could not read file " + file.getName(), (Throwable)e);
        }
        catch (SQLException e) {
            throw new OpenDocumentException("Could not execute query contained in file " + file.getName(), (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new OpenDocumentException("Could not decode file " + file.getName(), (Throwable)e);
        }
        catch (Throwable e) {
            throw new OpenDocumentException("Unknown error reading " + file.getName(), e);
        }
    }

    public JavaHighDDocument openRemoteDocument(String name, String url, String content) throws OpenDocumentException {
        try {
            URL u = new URL(url);
            DataSource dataSource = DataSourceFactory.getDataSource((URL)u);
            MutableDataFrame dataFrame = dataSource.loadDataFrame(null);
            HighDDocument document = this.createDocument(name, url, dataSource, dataFrame);
            return document;
        }
        catch (MalformedURLException e) {
            throw new OpenDocumentException("Invalid location " + url, (Throwable)e);
        }
        catch (IOException e) {
            throw new OpenDocumentException("Could not read file " + url, (Throwable)e);
        }
        catch (SQLException e) {
            throw new OpenDocumentException("Could not execute query contained in file " + url, (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new OpenDocumentException("Could not decode file " + url, (Throwable)e);
        }
        catch (Throwable e) {
            throw new OpenDocumentException("Unknown error reading " + url, e);
        }
    }

    @Override
    public JavaHighDDocument createDocument(String name, String url, DataSource dataSource, MutableDataFrame<Integer, String, Object> dataFrame) {
        Document xml = dataSource.getDocument(ApplicationModelFactory.HIGHD_APP);
        XomElementFactory elementFactory = new XomElementFactory();
        JavaHighDDocument document = new JavaHighDDocument(name, url, (DataFrame<Integer, String, Object>)dataFrame, new DefaultDataSourcePersistence(dataSource), SwingFactory.getInstance(), SwingColorMapFactory.getInstance(), (MatrixOperationsFactory)JavaMatrixOperationsFactory.getInstance(), (CPExecutor)new SwingExecutor(), dataSource);
        HighDPersistence persistance = new HighDPersistence(document, (CPColorFactory)SwingFactory.getInstance(), (CPFontFactory)SwingFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), (ElementFactory)elementFactory);
        if (xml != null) {
            persistance.load((Element)new XomElement(xml.getRootElement()));
        }
        return document;
    }

    public UICommand getReloadCommand(HighDView<JComponent, JavaHighDDocument> view) {
        return new ReloadUICommand(this, (View)view, null, (HighDView)view){
            final /* synthetic */ HighDView val$view;
            {
                this.val$view = highDView;
                super(arg0, arg1, (CPWindow<JFrame, JComponent>)arg2);
            }

            public void execute(Object source) {
                JavaHighDDocument document = (JavaHighDDocument)this.val$view.getDocument();
                DataSource dataSource = document.getDataSource();
                try {
                    DefaultDataFrame dataFrame = new DefaultDataFrame((DataFrame)dataSource.getOriginalDataSource().loadDataFrame(null));
                    document.setDataFrame((DataFrame)dataFrame);
                }
                catch (IOException e) {
                    Logging.getInstance().process((Throwable)e);
                }
                catch (SQLException e) {
                    Logging.getInstance().process((Throwable)e);
                }
            }
        };
    }

    public void saveView(HighDView<JComponent, JavaHighDDocument> view) {
    }

    public void saveView(HighDView<JComponent, JavaHighDDocument> view, File file, FileType fileType) {
        SwingHighDApplication.saveDocument(file, fileType, (HighDDocument)view.getDocument());
    }

    public static void saveDocument(File file, FileType fileType, HighDDocument document) {
        DefaultElementFactory elementFactory = new DefaultElementFactory();
        HighDPersistence persistance = new HighDPersistence(document, (CPColorFactory)SwingFactory.getInstance(), (CPFontFactory)SwingFactory.getInstance(), (PaletteFactory)SwingPaletteFactory.getInstance(), (FormatFactory)SwingFormatFactory.getInstance(), (ElementFactory)elementFactory);
        Element root = elementFactory.newElement("High-D");
        root.addAttribute(elementFactory.newAttribute("version", HighD.applicationModel.getVersionModel().toString()));
        persistance.save(root, (Object)file);
        if (fileType == JsonFileType.getInstance()) {
            try {
                String jsonDataFrame = SwingDataFrameExporter.exportJSON((DataFrame)document.getDataFrame());
                JSONObject xxx = new JSONObject(new JSONTokener(jsonDataFrame));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                new XmlElementSerializer().write((OutputStream)out, root);
                JSONObject json = JSONML.toJSONObject((String)out.toString());
                JSONArray Obj1 = (JSONArray)xxx.get("data");
                JSONObject combined = new JSONObject();
                combined.put("data", (Object)Obj1);
                combined.put("High-D", (Object)json);
                Files.write(file.toPath(), combined.toString().getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                zos.putNextEntry(new ZipEntry("datasource.ser"));
                TableModel tableModel = TableHelper.getExternalizableTableModel((TableModel)new DataFrameTableModel(document.getDataFrame()));
                ObjectOutputStream oout = new ObjectOutputStream(zos);
                oout.writeObject(tableModel);
                zos.closeEntry();
                zos.putNextEntry(new ZipEntry("high-d.xml"));
                new XmlElementSerializer().write((OutputStream)zos, root);
                zos.closeEntry();
                zos.close();
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
    }

    @Override
    public void showAbout(CPWindow<JFrame, JComponent> window) {
        HighDView view = (HighDView)this.getApplicationState().getView(window);
        if (view != null) {
            view.showAbout();
        } else {
            AboutAction aboutAction = new AboutAction(this.getResourcesModel(), "about.jpg", this.getApplicationModel(), null);
            aboutAction.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public FileType[] getOpenFileTypes() {
        return new FileType[]{HighDFileType.getInstance(), MicrosoftExcelFileType.getInstance(), CommaDelimitedFileType.getInstance(), TabDelimitedFileType.getInstance(), JsonFileType.getInstance(), ODFSpreadsheetFileType.getInstance(), ParquetFileType.getInstance(), GeoJSONFileType.getInstance(), ShapefileFileType.getInstance(), SPSSFileType.getInstance(), SASFileType.getInstance(), MicrosoftAccessFileType.getInstance(), InfoScopeFileType.getInstance(), TreeMapFileType.getInstance(), CartoPlotFileType.getInstance()};
    }

    public FileType[] getSaveFileTypes() {
        if (this.expert) {
            return new FileType[]{HighDFileType.getInstance(), JsonFileType.getInstance()};
        }
        return new FileType[]{HighDFileType.getInstance()};
    }

    public void waitUntilReady() {
        if (!SwingUtilities.isEventDispatchThread()) {
            EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
            while (eq.peekEvent() != null) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            System.err.println((Object)this.getFocusedView());
        }
    }

    public SwingHighDView getFocusedView() {
        System.err.println(this.getWindowManager());
        CPWindow activeWindow = this.getWindowManager().getActiveWindow();
        System.err.println("Active window: " + String.valueOf(activeWindow));
        HighDView treeMapView = (HighDView)this.getApplicationState().getView(activeWindow);
        System.err.println("View: " + String.valueOf(treeMapView));
        return (SwingHighDView)treeMapView;
    }

    public Component getRootWindow() {
        return (Component)this.getWindowManager().getActiveWindow().getNativeWindow();
    }

    public void openData(File dataset) {
    }

    public void setFocusedModelDirty(boolean b) {
    }

    public Object getFocusedModel() {
        return null;
    }

    public void closeData(Object focusedModel) {
    }

    private static class ShowAboutAction
    extends AbstractAction {
        private final SwingHighDApplication application;
        private final CPWindow<JFrame, JComponent> window;

        public ShowAboutAction(SwingHighDApplication application, CPWindow<JFrame, JComponent> window) {
            this.application = application;
            this.window = window;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.application.showAbout(this.window);
        }
    }
}

