/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.document.swing.export;

import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.file.FileHelper;
import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.logging.SwingLogging;
import com.macrofocus.util.swing.FileChooserFactory;
import com.macrofocus.util.swing.export.ComponentCustomizer;
import com.macrofocus.util.swing.export.ExportDialog;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.DefaultContentProvider;
import com.macrofocus.util.swing.export.format.EMFExportFormat;
import com.macrofocus.util.swing.export.format.ExportFormat;
import com.macrofocus.util.swing.export.format.FileProvider;
import com.macrofocus.util.swing.export.format.FreeHEPPostscriptExportFormat;
import com.macrofocus.util.swing.export.format.GIFExportFormat;
import com.macrofocus.util.swing.export.format.JPEGExportFormat;
import com.macrofocus.util.swing.export.format.PNGExportFormat;
import com.macrofocus.util.swing.export.format.SVGExportFormat;
import com.macrofocus.util.swing.export.format.TIFFExportFormat;
import com.macrofocus.util.swing.export.format.WebPExportFormat;
import com.macrofocus.util.swing.export.format.XMLGraphicsPDFExportFormat;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ExportGraphicsAction
extends AbstractAction {
    private final Type type = Type.JFileChooserWithAccessory;
    private final JComponent rootPane;
    private ContentProvider<Component> contentProvider;
    private FileProvider<File> fileProvider;
    private ComponentCustomizer customizer = null;
    private ExportDialog exportDialog;
    private final ExportFormat<Component>[] exportFormats;
    private final FileChooserFactory fileChooserFactory = new FileChooserFactory(){

        public JFileChooser getFileChooser() {
            JFileChooser fileChooser = super.getFileChooser();
            if (fileChooser.getSelectedFile() == null) {
                File file = (File)ExportGraphicsAction.this.fileProvider.getFile();
                FileFilter fileFilter = fileChooser.getFileFilter();
                if (fileFilter instanceof AbstractFileFilter) {
                    file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension());
                }
                fileChooser.setSelectedFile(file);
            }
            return fileChooser;
        }

        protected JFileChooser createFileChooser() {
            final JFileChooser fileChooser = super.createFileChooser();
            fileChooser.setDialogTitle("Export Graphics");
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setAcceptAllFileFilterUsed(false);
            if (ExportGraphicsAction.this.type == Type.JFileChooserWithAccessory) {
                fileChooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        FileFilter fileFilter = fileChooser.getFileFilter();
                        JComponent settings = null;
                        for (ExportFormat<Component> exportFormat : ExportGraphicsAction.this.exportFormats) {
                            if (!exportFormat.isValid() || exportFormat.getFileFilter() != fileFilter) continue;
                            settings = (JComponent)exportFormat.getSettingsPanel();
                        }
                        fileChooser.setAccessory(settings);
                        fileChooser.validate();
                    }
                });
            }
            ExportFormat<Component> first = null;
            for (ExportFormat<Component> exportFormat : ExportGraphicsAction.this.exportFormats) {
                if (!exportFormat.isValid()) continue;
                if (first == null) {
                    first = exportFormat;
                }
                fileChooser.addChoosableFileFilter((FileFilter)exportFormat.getFileFilter());
            }
            if (first != null) {
                fileChooser.setFileFilter((FileFilter)first.getFileFilter());
            }
            return fileChooser;
        }
    };

    public ExportGraphicsAction(JComponent rootPane, final PropertiesModel propertiesModel, ComponentCustomizer customizer, boolean expertMode) {
        this.rootPane = rootPane;
        this.customizer = customizer;
        this.exportFormats = ExportGraphicsAction.getExportFormats(expertMode);
        this.setContent(null, null);
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    ExportGraphicsAction.this.updateProperties(propertiesModel);
                }
            });
        }
    }

    public static ExportFormat<Component>[] getExportFormats(boolean expert) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (expert) {
            try {
                list.add(new PNGExportFormat());
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
            try {
                list.add(new JPEGExportFormat());
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
            try {
                list.add(new GIFExportFormat());
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
            try {
                list.add(new TIFFExportFormat());
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
            try {
                list.add(new WebPExportFormat());
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
            try {
                list.add(new SVGExportFormat());
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
            try {
                list.add(new XMLGraphicsPDFExportFormat());
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
            try {
                list.add(new FreeHEPPostscriptExportFormat());
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
            try {
                list.add(new EMFExportFormat());
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
            }
        } else {
            try {
                list.add(new PNGExportFormat());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                list.add(new JPEGExportFormat());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                list.add(new GIFExportFormat());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                list.add(new TIFFExportFormat());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                list.add(new WebPExportFormat());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                list.add(new SVGExportFormat());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                list.add(new XMLGraphicsPDFExportFormat());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                list.add(new FreeHEPPostscriptExportFormat());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            try {
                list.add(new EMFExportFormat());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return list.toArray(new ExportFormat[list.size()]);
    }

    public void setContent(ContentProvider<Component> component, FileProvider<File> fileProvider) {
        this.contentProvider = component;
        this.fileProvider = fileProvider;
        this.setEnabled(this.contentProvider != null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            Component component;
            if (this.exportDialog == null) {
                this.exportDialog = this.createExportDialog(this.rootPane);
            }
            Component component2 = component = this.contentProvider != null ? (Component)this.contentProvider.getContent() : null;
            if (this.customizer != null) {
                component = this.customizer.configure(component);
            }
            if (this.type == Type.ExportDialog) {
                this.exportDialog.setContent((ContentProvider)new DefaultContentProvider((Object)component));
                this.exportDialog.pack();
                this.exportDialog.setLocationRelativeTo((Component)this.rootPane);
                this.exportDialog.setVisible(true);
            } else {
                JFileChooser fileChooser = this.fileChooserFactory.getFileChooser();
                fileChooser.rescanCurrentDirectory();
                int returnVal = fileChooser.showSaveDialog(this.rootPane);
                File file = fileChooser.getSelectedFile();
                FileFilter fileFilter = fileChooser.getFileFilter();
                if (returnVal == 0) {
                    int input;
                    if (!fileFilter.accept(file) && fileFilter instanceof AbstractFileFilter) {
                        file = FileHelper.replaceSuffix((File)file, (String)((AbstractFileFilter)fileFilter).getDefaultExtension());
                    }
                    if (file.exists() && (input = JOptionPane.showConfirmDialog(this.rootPane, "File " + file.getName() + " already exist! Overwrite?", "File already exist", 0, 2)) == 1) {
                        return;
                    }
                    for (ExportFormat<Component> exportFormat : this.exportFormats) {
                        if (!exportFormat.isValid() || exportFormat.getFileFilter() == null || !exportFormat.getFileFilter().equals((Object)fileFilter)) continue;
                        try {
                            exportFormat.save((ContentProvider)new DefaultContentProvider((Object)component), file);
                        }
                        catch (IOException e) {
                            SwingLogging.getInstance().process((Component)this.rootPane, (Throwable)e);
                        }
                    }
                }
            }
            if (this.customizer != null) {
                this.customizer.restore(component);
            }
        }
        catch (Throwable e) {
            SwingLogging.getInstance().process((Component)this.rootPane, e);
        }
    }

    protected ExportDialog createExportDialog(Component parent) throws HeadlessException {
        Window window = SwingUtilities.getWindowAncestor(parent);
        return new ExportDialog(window, this.exportFormats);
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        Object name = "Export Graphics";
        if (propertiesModel != null && propertiesModel.isAvailable("action.exportgraphics.label")) {
            name = (String)propertiesModel.getValue("action.exportgraphics.label");
        }
        name = (String)name + "...";
        this.putValue("Name", name);
    }

    public static enum Type {
        JFileChooser,
        JFileChooserWithAccessory,
        ExportDialog;

    }
}

