/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.cartoplot.CartoPlot;
import com.macrofocus.cartoplot.CartoPlotController;
import com.macrofocus.cartoplot.CartoPlotModel;
import com.macrofocus.cartoplot.CartoPlotView;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;

public abstract class AbstractCartoPlot<Component, Color, R, C>
implements CartoPlot<Component, Color, R, C> {
    protected static LicenseModel licenseModel;
    private CartoPlotModel<Color, R, C> model;
    protected CartoPlotView<Component, Color, R, C> view;
    protected CartoPlotController controller;

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.CARTOPLOT_API, username, key);
    }

    protected void load(DataFrame dataFrame) {
        this.setModel(this.createModel(dataFrame));
    }

    @Override
    public CartoPlotModel<Color, R, C> getModel() {
        return this.model;
    }

    @Override
    public void setModel(CartoPlotModel<Color, R, C> model) {
        if (this.model != model) {
            this.model = model;
            if (this.view != null) {
                this.view.setModel(model);
            }
        }
    }

    @Override
    public CartoPlotView<Component, Color, R, C> getView() {
        return this.view;
    }

    @Override
    public void setView(CartoPlotView<Component, Color, R, C> view) {
        if (this.view != view) {
            if (this.view != null) {
                this.view.setModel(null);
            }
            this.view = view;
            if (view != null) {
                view.setModel(this.model);
                this.view.setLicenseModel(licenseModel);
            }
        }
    }

    @Override
    public CartoPlotController getController() {
        return this.controller;
    }

    @Override
    public void setController(CartoPlotController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.setView(null);
            }
            this.controller = controller;
            if (controller != null) {
                controller.setView(this.view);
            }
        }
    }

    protected abstract CartoPlotModel<Color, R, C> createModel(DataFrame var1);

    protected abstract CartoPlotView<Component, Color, R, C> createView();

    protected abstract CartoPlotController createController(CartoPlotView var1);
}

