/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot;

import com.macrofocus.cartoplot.CartoPlotController;
import com.macrofocus.cartoplot.CartoPlotView;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import java.util.List;

public abstract class AbstractCartoPlotController<Component, Color, Row, Column>
implements CartoPlotController<Component, Color, Row, Column> {
    private CartoPlotView<Component, ?, Row, Column> view;
    private Mode mode = Mode.Selection;
    private final boolean multipleSelectionEnabled = true;
    private final boolean selectOnPopupTrigger = false;
    private boolean improvedBorderZooming = false;
    private final DefaultMouseListener mouseListener = new DefaultMouseListener();
    private final CPCanvas.KeyListener keyListener = new CPCanvas.KeyListener(){
        Mode oldMode;

        public void keyTyped(CPCanvas.KeyEvent event) {
        }

        public void keyPressed(CPCanvas.KeyEvent event) {
            if (event.getKeyCode() == 83) {
                if (this.oldMode == null) {
                    this.oldMode = AbstractCartoPlotController.this.mode;
                }
                AbstractCartoPlotController.this.mode = Mode.Selection;
            }
            if (event.getKeyCode() == 90 || event.getKeyCode() == 16) {
                if (this.oldMode == null) {
                    this.oldMode = AbstractCartoPlotController.this.mode;
                }
                AbstractCartoPlotController.this.mode = Mode.Zooming;
            }
            if (event.getKeyCode() == 80 || event.getKeyCode() == 32) {
                if (this.oldMode == null) {
                    this.oldMode = AbstractCartoPlotController.this.mode;
                }
                AbstractCartoPlotController.this.mode = Mode.Panning;
            }
        }

        public void keyReleased(CPCanvas.KeyEvent event) {
            if (this.oldMode != null) {
                AbstractCartoPlotController.this.mode = this.oldMode;
                this.oldMode = null;
            }
        }
    };

    public AbstractCartoPlotController(CartoPlotView<Component, Color, Row, Column> view) {
        this.setView(view);
    }

    @Override
    public void setView(CartoPlotView<Component, Color, Row, Column> view) {
        if (this.view != null) {
            // empty if block
        }
        this.view = view;
        if (view != null) {
            view.addKeyListener(this.keyListener);
            view.addMouseListener(this.mouseListener);
            view.addMouseMotionListener(this.mouseListener);
            view.addMouseWheelListener(this.mouseListener);
        }
    }

    private void zoom(double amount, Double xCenter, Double yCenter) {
        Rectangle2D viewport = this.getViewport();
        Rectangle2D world = this.getWorld();
        Range xRange = new Range(amount, xCenter, viewport.getMinX(), viewport.getWidth(), world.getMinX(), world.getMaxX(), this.view.getXRangeModel().getMaximumExtent()).invoke();
        double xMin = xRange.getMin();
        double xMax = xRange.getMax();
        Range yRange = new Range(amount, yCenter, viewport.getMinY(), viewport.getHeight(), world.getMinY(), world.getMaxY(), this.view.getYRangeModel().getMaximumExtent()).invoke();
        double yMin = yRange.getMin();
        double yMax = yRange.getMax();
        if (xMin < xMax && yMin < yMax) {
            this.view.zoom(false, xMin, xMax, yMin, yMax);
        }
    }

    public Rectangle2D getViewport() {
        Rectangle2D.Double r = new Rectangle2D.Double(this.view.getXRangeModel().getStart(), this.view.getYRangeModel().getStart(), this.view.getXRangeModel().getExtent(), this.view.getYRangeModel().getExtent());
        return r;
    }

    public Rectangle2D getWorld() {
        Rectangle2D.Double r = new Rectangle2D.Double(this.view.getXRangeModel().getMinimum(), this.view.getYRangeModel().getMinimum(), this.view.getXRangeModel().getMaximum() - this.view.getXRangeModel().getMinimum(), this.view.getYRangeModel().getMaximum() - this.view.getYRangeModel().getMinimum());
        return r;
    }

    public static enum Mode {
        Selection,
        Zooming,
        Panning;

    }

    public class DefaultMouseListener
    implements CPCanvas.MouseListener,
    CPCanvas.MouseMotionListener,
    CPCanvas.MouseWheelListener {
        private CPCanvas.MouseEvent last;
        private Row selectOnRelease = null;
        private Point zoomOnRelease = null;
        private Point zoomingPoint = null;
        private Point pressedPoint = null;

        public void mouseClicked(CPCanvas.MouseEvent event) {
        }

        public void mousePressed(CPCanvas.MouseEvent event) {
            if (AbstractCartoPlotController.this.view != null) {
                this.pressedPoint = new Point(event.getX(), event.getY());
                Object bestrow = AbstractCartoPlotController.this.view.getClosestRow(event.getX(), event.getY());
                if (bestrow != null) {
                    if (!event.isMultipleSelectionKey()) {
                        if (!AbstractCartoPlotController.this.view.getModel().getSelection().isSelected(bestrow) || AbstractCartoPlotController.this.view.getModel().getSelection().getSelectedCount() > 1) {
                            AbstractCartoPlotController.this.view.getModel().getSelection().clearSelection();
                            AbstractCartoPlotController.this.view.getModel().getSelection().setSelected(bestrow);
                            AbstractCartoPlotController.this.view.setSelectionMode(AbstractCartoPlotController.this.view.getModel().getSelection().isSelected(bestrow));
                        }
                    } else {
                        AbstractCartoPlotController.this.view.setSelectionMode(!AbstractCartoPlotController.this.view.getModel().getSelection().isSelected(bestrow));
                        if (AbstractCartoPlotController.this.view.isSelectionMode()) {
                            AbstractCartoPlotController.this.view.getModel().getSelection().setSelectedState(bestrow, true);
                        } else {
                            AbstractCartoPlotController.this.view.getModel().getSelection().setSelectedState(bestrow, false);
                        }
                    }
                } else {
                    AbstractCartoPlotController.this.view.getModel().getSelection().clearSelection();
                }
            }
        }

        public void mouseReleased(CPCanvas.MouseEvent event) {
            if (AbstractCartoPlotController.this.view != null) {
                if (!event.isPopupTrigger()) {
                    if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                        AbstractCartoPlotController.this.view.getModel().getSelection().clearSelection();
                        this.addToSelection(this.selectOnRelease);
                        this.selectOnRelease = null;
                    }
                    if (this.zoomOnRelease != null) {
                        if (event.isLeftMouseButton()) {
                            // empty if block
                        }
                        this.zoomOnRelease = null;
                    }
                    AbstractCartoPlotController.this.view.stopRubberBand();
                }
                this.last = null;
            }
        }

        public void mouseEntered(CPCanvas.MouseEvent event) {
            if (AbstractCartoPlotController.this.view != null && AbstractCartoPlotController.this.view.getModel() != null) {
                AbstractCartoPlotController.this.view.getModel().getProbing().setSelected(AbstractCartoPlotController.this.view.getClosestRow(event.getX(), event.getY()));
            }
        }

        public void mouseExited(CPCanvas.MouseEvent event) {
            if (AbstractCartoPlotController.this.view != null && AbstractCartoPlotController.this.view.getModel() != null) {
                AbstractCartoPlotController.this.view.getModel().getProbing().clearSelection();
            }
        }

        public void mouseDragged(CPCanvas.MouseEvent event) {
            if (AbstractCartoPlotController.this.view != null && AbstractCartoPlotController.this.view.getModel() != null) {
                if (this.last != null) {
                    switch (AbstractCartoPlotController.this.mode.ordinal()) {
                        case 0: {
                            boolean isAlreadySelected;
                            if (!event.isLeftMouseButton()) break;
                            if (event.isAltKeyDown() || event.isShiftKeyDown()) {
                                AbstractCartoPlotController.this.view.getModel().getProbing().clearSelection();
                                if (!AbstractCartoPlotController.this.view.getRubberBand().isActive()) {
                                    AbstractCartoPlotController.this.view.startRubberBand(this.pressedPoint.x, this.pressedPoint.y);
                                }
                                AbstractCartoPlotController.this.view.stretchRubberBand(event.getX(), event.getY());
                                Rectangle2D rect = AbstractCartoPlotController.this.view.getRubberBandScreen();
                                if (rect == null) break;
                                List toSelect = AbstractCartoPlotController.this.view.getRows(rect);
                                if (event.isMultipleSelectionKey()) {
                                    this.addToSelection(toSelect);
                                } else {
                                    AbstractCartoPlotController.this.view.getModel().getSelection().setSelectedIterable(toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            Object observation = AbstractCartoPlotController.this.view.getClosestRow(event.getX(), event.getY());
                            AbstractCartoPlotController.this.view.getModel().getProbing().setSelected(observation);
                            this.selectOnRelease = null;
                            boolean bl = isAlreadySelected = AbstractCartoPlotController.this.view.getModel().getSelection() != null && AbstractCartoPlotController.this.view.getModel().getSelection().isSelected(observation);
                            if (!isAlreadySelected && !event.isMenuShortcutKeyDown()) {
                                AbstractCartoPlotController.this.view.getModel().getSelection().clearSelection();
                            }
                            if (event.isMenuShortcutKeyDown()) {
                                this.addToSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            this.addToSelection(observation);
                            break;
                        }
                        case 2: {
                            if (!event.isLeftMouseButton()) break;
                            Rectangle2D viewport = AbstractCartoPlotController.this.getViewport();
                            Rectangle2D world = AbstractCartoPlotController.this.getWorld();
                            double x1 = AbstractCartoPlotController.this.view.getScreenTransform().getX().screenToWorld(this.last.getX());
                            double x2 = AbstractCartoPlotController.this.view.getScreenTransform().getX().screenToWorld(event.getX());
                            double worldDiffX = x1 - x2;
                            double xMin = viewport.getMinX() + worldDiffX;
                            double xMax = viewport.getMaxX() + worldDiffX;
                            double y1 = AbstractCartoPlotController.this.view.getScreenTransform().getY().screenToWorld(this.last.getY());
                            double y2 = AbstractCartoPlotController.this.view.getScreenTransform().getY().screenToWorld(event.getY());
                            double worldDiffY = y1 - y2;
                            double yMin = viewport.getMinY() + worldDiffY;
                            double yMax = viewport.getMaxY() + worldDiffY;
                            if (xMin < world.getMinX()) {
                                xMax += world.getMinX() - xMin;
                                xMin = world.getMinX();
                            }
                            if (xMax > world.getMaxX()) {
                                xMin -= xMax - world.getMaxX();
                                xMax = world.getMaxX();
                            }
                            xMin = Math.max(world.getMinX(), xMin);
                            xMax = Math.min(world.getMaxX(), xMax);
                            if (yMin < world.getMinY()) {
                                yMax += world.getMinY() - yMin;
                                yMin = world.getMinY();
                            }
                            if (yMax > world.getMaxY()) {
                                yMin -= yMax - world.getMaxY();
                                yMax = world.getMaxY();
                            }
                            yMin = Math.max(world.getMinY(), yMin);
                            yMax = Math.min(world.getMaxY(), yMax);
                            if (!(xMin < xMax) || !(yMin < yMax)) break;
                            AbstractCartoPlotController.this.view.zoom(false, xMin, xMax, yMin, yMax);
                            break;
                        }
                        case 1: {
                            if (!event.isMiddleMouseButton()) break;
                            AbstractCartoPlotController.this.zoom((double)event.getY() - (double)this.last.getY() / 100.0, AbstractCartoPlotController.this.view.getScreenTransform().getX().screenToWorld(event.getX()), AbstractCartoPlotController.this.view.getScreenTransform().getY().screenToWorld(event.getY()));
                            this.zoomOnRelease = null;
                        }
                    }
                }
                this.last = event;
            }
        }

        public void mouseMoved(CPCanvas.MouseEvent event) {
            Object closest = AbstractCartoPlotController.this.view.getClosestRow(event.getX(), event.getY());
            AbstractCartoPlotController.this.view.getModel().getProbing().setSelected(closest);
        }

        public void mouseWheelMoved(CPCanvas.MouseWheelEvent event) {
            if (AbstractCartoPlotController.this.view != null) {
                int amount = event.getWheelRotation();
                AbstractCartoPlotController.this.zoom((double)amount / 20.0, AbstractCartoPlotController.this.view.getScreenTransform().getX().screenToWorld(event.getX()), AbstractCartoPlotController.this.view.getScreenTransform().getY().screenToWorld(event.getY()));
            }
        }

        private void removeFromSelection(Row observation) {
            AbstractCartoPlotController.this.view.getModel().getSelection().setSelectedState(observation, false);
        }

        private void setSelection(Row observation) {
            if (observation != null) {
                AbstractCartoPlotController.this.view.getModel().getSelection().setSelectedElements(new Object[]{observation});
            } else {
                AbstractCartoPlotController.this.view.getModel().getSelection().clearSelection();
            }
        }

        private void addToSelection(Row observation) {
            AbstractCartoPlotController.this.view.getModel().getSelection().setSelectedState(observation, true);
        }

        private void addToSelection(List<Row> newSelection) {
            AbstractCartoPlotController.this.view.getModel().getSelection().setSelectedIterableState(newSelection, true);
        }
    }

    private class Range {
        private final double _amount;
        private final Double _center;
        private final double _start;
        private final double _extent;
        private final double _minRange;
        private final double _maxRange;
        private double _min;
        private double _max;
        private final double _maxExtent;

        public Range(double amount, Double center, double start, double extent, double minRange, double maxRange, double maxExtent) {
            this._amount = amount;
            this._center = center;
            this._start = start;
            this._extent = extent;
            this._minRange = minRange;
            this._maxRange = maxRange;
            this._maxExtent = maxExtent;
        }

        public double getMin() {
            return this._min;
        }

        public double getMax() {
            return this._max;
        }

        public Range invoke() {
            double range = this._extent;
            double newRange = Math.min(this._maxExtent, range + range * this._amount);
            if (this._center != null) {
                this._min = this._center - newRange * ((this._center - this._start) / range);
                this._max = this._center + newRange * ((this._start + this._extent - this._center) / range);
            } else {
                this._min = this._start;
                this._max = this._start + newRange;
            }
            if (this._min < this._minRange) {
                this._max += this._minRange - this._min;
                this._min = this._minRange;
            }
            if (this._max > this._maxRange) {
                this._min -= this._max - this._maxRange;
                this._max = this._maxRange;
            }
            this._min = Math.max(this._minRange, this._min);
            this._max = Math.min(this._maxRange, this._max);
            return this;
        }
    }
}

