/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot;

import com.macrofocus.cartoplot.IShapeCollectionPathIterator;
import com.macrofocus.cartoplot.ShapeCollectionPathIterator;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import java.util.ArrayList;
import java.util.List;

public class GeometryCollectionIShape
implements Shape {
    private final List<Shape> shapes = new ArrayList<Shape>();

    public void add(Shape shape) {
        this.shapes.add(shape);
    }

    public Rectangle2D getBounds2D() {
        Rectangle2D rectangle = null;
        for (Shape shape : this.shapes) {
            if (rectangle == null) {
                rectangle = shape.getBounds2D();
                continue;
            }
            rectangle = rectangle.createUnion(shape.getBounds2D());
        }
        return rectangle;
    }

    public boolean contains(double x, double y) {
        return this.contains((Point2D)new Point2D.Double(x, y));
    }

    public boolean contains(Point2D p) {
        for (Shape shape : this.shapes) {
            if (!shape.contains(p)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Rectangle2D r) {
        for (Shape shape : this.shapes) {
            if (!shape.intersects(r)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(double x, double y, double w, double h) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    public boolean contains(Rectangle2D r) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    public PathIterator getPathIterator() {
        return new IShapeCollectionPathIterator(this.shapes);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new ShapeCollectionPathIterator(this.shapes, at);
    }

    public PathIterator getFlattenPathIterator(double flatness) {
        return this.getPathIterator();
    }
}

