/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.cartoplot.AbstractCartoPlot;
import com.macrofocus.cartoplot.CartoPlotController;
import com.macrofocus.cartoplot.CartoPlotModel;
import com.macrofocus.cartoplot.CartoPlotView;
import com.macrofocus.cartoplot.DefaultCartoPlotModel;
import com.macrofocus.cartoplot.swing.SwingCartoPlotController;
import com.macrofocus.cartoplot.swing.SwingCartoPlotPanel;
import com.macrofocus.cartoplot.swing.SwingCartoPlotView;
import com.macrofocus.cartoplot.swing.georeferencing.SwingGeoReferencingServiceFactory;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.data.dataframe.DefaultDataFrame;
import com.macrofocus.helper.TableHelper;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.OverlayLayout;
import javax.swing.table.TableModel;

public class SwingCartoPlot<R, C>
extends AbstractCartoPlot<JComponent, Color, R, C> {
    private final JComponent nativeComponent = new JComponent(){};

    public SwingCartoPlot() {
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.view = this.createView();
        this.view.setLicenseModel(licenseModel);
        this.controller = this.createController(this.view);
        this.nativeComponent.add((Component)this.view.getNativeComponent());
        this.nativeComponent.validate();
    }

    public SwingCartoPlot(CartoPlotModel model) {
        this();
        this.setModel(model);
    }

    public SwingCartoPlot(TableModel tableModel) {
        this();
        this.load(tableModel);
    }

    public SwingCartoPlot(DataFrame dataFrame) {
        this();
        this.load(dataFrame);
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.CARTOPLOT_API, username, key);
    }

    void load(TableModel tableModel) {
        this.setModel(this.createModel(tableModel));
    }

    public SwingCartoPlotView getView() {
        return (SwingCartoPlotView)this.view;
    }

    protected CartoPlotModel createModel(TableModel tableModel) {
        DefaultDataFrame dataFrame = new DefaultDataFrame(tableModel);
        return this.createModel((DataFrame)dataFrame);
    }

    protected CartoPlotModel<Color, R, C> createModel(DataFrame dataFrame) {
        return new DefaultCartoPlotModel(dataFrame, (ColorMapFactory)SwingColorMapFactory.getInstance(), SwingGeoReferencingServiceFactory.getInstance(dataFrame).getDefault());
    }

    protected SwingCartoPlotView createView() {
        SwingCartoPlotView view = new SwingCartoPlotView();
        return view;
    }

    protected CartoPlotController createController(CartoPlotView view) {
        return new SwingCartoPlotController(view);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public static void main(String[] args) {
        SwingCartoPlot.setLicenseKey("Macrofocus GmbH", "NVH74-CGFJL-RMERD-GYG28-L8DVD-GGUDN");
        TableModel tableModel = TableHelper.createRandomCartoTableModel((int)3, (int)10000, (int)10);
        SwingCartoPlot scatterPlot = new SwingCartoPlot(tableModel);
        CartoPlotModel model = scatterPlot.getModel();
        ApplicationModel applicationModel = ApplicationModelFactory.HIGHD_API_V1;
        JFrame frame = new JFrame(applicationModel.getName() + " " + applicationModel.getVersion() + ", Copyright (c) " + applicationModel.getCopyright() + " " + applicationModel.getEdition());
        frame.setSize(600, 600);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new SwingCartoPlotPanel(scatterPlot));
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

