/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing;

import com.macrofocus.cartoplot.CartoPlotModel;
import com.macrofocus.cartoplot.swing.SwingCartoPlot;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.plot.AxisPlotPanel;
import com.macrofocus.plot.SwingAxisPlotPanel;
import com.macrofocus.plot.guide.AbstractSwingGuide;
import com.macrofocus.slider.BoundedIntervalRangeSliderAdapter;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.SliderView;
import com.macrofocus.slider.swing.JRangeSlider;
import com.macrofocus.slider.swing.SimpleRangeSliderController;
import com.macrofocus.slider.swing.TrapezoidRangeSlider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SwingCartoPlotPanel
extends JPanel
implements CPComponent<JComponent> {
    private final SwingCartoPlot cartoPlot;
    private final AxisPlotPanel<JComponent> axisPlotPanel;

    public SwingCartoPlotPanel(SwingCartoPlot cartoPlot) {
        this.cartoPlot = cartoPlot;
        this.setLayout(new BorderLayout());
        this.axisPlotPanel = new SwingAxisPlotPanel(cartoPlot.getView().getXGuide(), cartoPlot.getView().getYGuide());
        ((AbstractSwingGuide)cartoPlot.getView().getXGuide()).setPanel(this.axisPlotPanel);
        ((AbstractSwingGuide)cartoPlot.getView().getYGuide()).setPanel(this.axisPlotPanel);
        this.add((Component)this.axisPlotPanel.getNativeComponent(), "Center");
        this.axisPlotPanel.addComponent((Object)cartoPlot.getNativeComponent());
        ((JComponent)this.axisPlotPanel.getLeftYAxisContainer()).setBackground(new Color(250, 250, 247));
        ((JComponent)this.axisPlotPanel.getBottomTimeAxisContainer()).setBackground(new Color(250, 250, 247));
        ((JComponent)this.axisPlotPanel.getLeftYAxisContainer()).setOpaque(false);
        ((JComponent)this.axisPlotPanel.getBottomTimeAxisContainer()).setOpaque(false);
        this.axisPlotPanel.setShowTopTimeAxis(true);
        this.axisPlotPanel.setTopAxisVisible(true);
        this.axisPlotPanel.setShowBottomTimeAxis(false);
        BoundedIntervalRangeSliderAdapter xSliderModel = new BoundedIntervalRangeSliderAdapter(cartoPlot.getView().getXRangeModel(), 0.0, 0.0);
        JRangeSlider xRangeSlider = new JRangeSlider((RangeSliderModel)xSliderModel, 0);
        TrapezoidRangeSlider xZoomTrapezoid = new TrapezoidRangeSlider(xRangeSlider);
        xZoomTrapezoid.setOpaque(true);
        JPanel xRange = new JPanel();
        xRange.setLayout(new BorderLayout());
        xRange.add((Component)xRangeSlider, "North");
        xZoomTrapezoid.setMinimumSize(new Dimension(12, 12));
        xRange.add((Component)xZoomTrapezoid, "South");
        new SimpleRangeSliderController((SliderView)xRangeSlider, true);
        this.axisPlotPanel.addTopTimeAxisComponent((Object)xRange);
        this.axisPlotPanel.setLeftAxisVisible(false);
        this.axisPlotPanel.setRightAxisVisible(true);
        this.axisPlotPanel.setShowLeftYAxis(false);
        BoundedIntervalRangeSliderAdapter ySliderModel = new BoundedIntervalRangeSliderAdapter(cartoPlot.getView().getYRangeModel(), 0.0, 0.0);
        JRangeSlider yRangeSlider = new JRangeSlider((RangeSliderModel)ySliderModel, 1);
        TrapezoidRangeSlider yZoomTrapezoid = new TrapezoidRangeSlider(yRangeSlider);
        yZoomTrapezoid.setOpaque(true);
        JPanel yRange = new JPanel();
        yRange.setLayout(new BorderLayout());
        yZoomTrapezoid.setMinimumSize(new Dimension(12, 12));
        yRange.add((Component)yZoomTrapezoid, "West");
        yRange.add((Component)yRangeSlider, "East");
        new SimpleRangeSliderController((SliderView)yRangeSlider, true);
        this.axisPlotPanel.addRightYAxisComponent((Object)yRange);
    }

    public void setModel(CartoPlotModel model) {
        this.cartoPlot.setModel(model);
    }

    public SwingCartoPlot getCartoPlot() {
        return this.cartoPlot;
    }

    public AxisPlotPanel getAxisPlotPanel() {
        return this.axisPlotPanel;
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public JComponent getNativeComponent() {
        return this;
    }
}

