/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing.tile;

import com.macrofocus.cartoplot.swing.tile.SwingTile;
import com.macrofocus.cartoplot.swing.tile.SwingTileCache;
import com.macrofocus.cartoplot.tile.AbstractTileFactory;
import com.macrofocus.cartoplot.tile.Tile;
import com.macrofocus.cartoplot.tile.TileFactoryInfo;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;

public class SwingTileFactory
extends AbstractTileFactory {
    private int threadPoolSize = 4;
    private ExecutorService service;
    private final Map<String, SwingTile> tileMap = new HashMap<String, SwingTile>();
    private final SwingTileCache cache = new SwingTileCache(this);
    private static final BlockingQueue<SwingTile> tileQueue = new PriorityBlockingQueue<SwingTile>(5, new Comparator<SwingTile>(){

        @Override
        public int compare(SwingTile o1, SwingTile o2) {
            if (o1.getPriority() == SwingTile.Priority.Low && o2.getPriority() == SwingTile.Priority.High) {
                return 1;
            }
            if (o1.getPriority() == SwingTile.Priority.High && o2.getPriority() == SwingTile.Priority.Low) {
                return -1;
            }
            return 0;
        }
    });

    public SwingTileFactory(TileFactoryInfo info) {
        super(info);
    }

    public SwingTile getTile(int x, int y, int zoom, boolean wrap) {
        return this.getTile(x, y, zoom, wrap, true);
    }

    private SwingTile getTile(int tpx, int tpy, int zoom, boolean wrap, boolean eagerLoad) {
        SwingTile tile;
        int tileX = tpx;
        if (wrap) {
            int numTilesWide = this.getMapWidth(zoom);
            if (tileX < 0) {
                tileX = numTilesWide - Math.abs(tileX) % numTilesWide;
            }
            tileX %= numTilesWide;
        }
        int tileY = tpy;
        String url = this.getInfo().getTileUrl(tileX, tileY, zoom);
        SwingTile.Priority pri = SwingTile.Priority.High;
        if (!eagerLoad) {
            pri = SwingTile.Priority.Low;
        }
        if (!this.tileMap.containsKey(url)) {
            if (!this.getInfo().isValidTile(tileX, tileY, zoom)) {
                tile = new SwingTile(tileX, tileY, zoom);
            } else {
                tile = new SwingTile(tileX, tileY, zoom, url, pri, this);
                this.startLoading(tile);
            }
            this.tileMap.put(url, tile);
        } else {
            tile = this.tileMap.get(url);
            if (tile.getPriority() == SwingTile.Priority.Low && eagerLoad && !tile.isLoaded()) {
                this.promote(tile);
            }
        }
        return tile;
    }

    synchronized ExecutorService getService() {
        if (this.service == null) {
            this.service = Executors.newFixedThreadPool(this.threadPoolSize, new ThreadFactory(){
                private int count = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "tile-pool-" + this.count++);
                    t.setPriority(1);
                    t.setDaemon(true);
                    return t;
                }
            });
        }
        return this.service;
    }

    public void dispose() {
        if (this.service != null) {
            this.service.shutdown();
            this.service = null;
        }
    }

    public void clearCache() {
        this.cache.clear();
        for (SwingTile tile : this.tileMap.values()) {
            tile.image = new SoftReference<Object>(null);
        }
    }

    public void setThreadPoolSize(int size) {
        this.threadPoolSize = size;
    }

    public synchronized void startLoading(SwingTile tile) {
        if (tile.isLoading()) {
            System.out.println("already loading. bailing");
            return;
        }
        tile.setLoading(true);
        try {
            tileQueue.put(tile);
            this.getService().submit(this.createTileRunner());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    Runnable createTileRunner() {
        return new TileRunner();
    }

    synchronized void promote(SwingTile tile) {
        if (tileQueue.contains((Object)tile)) {
            try {
                tileQueue.remove((Object)tile);
                tile.setPriority(SwingTile.Priority.High);
                tileQueue.put(tile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected BufferedImage createImage(byte[] bimg) throws IOException {
        return ImageIO.read(new ByteArrayInputStream(bimg));
    }

    private class TileRunner
    implements Runnable {
        private TileRunner() {
        }

        URI getURI(SwingTile tile) throws URISyntaxException {
            if (tile.getURL() == null) {
                return null;
            }
            return new URI(tile.getURL());
        }

        @Override
        public void run() {
            final SwingTile tile = (SwingTile)((Object)tileQueue.remove());
            int trys = 3;
            while (!tile.isLoaded() && trys > 0) {
                try {
                    BufferedImage img = null;
                    URI uri = this.getURI(tile);
                    img = SwingTileFactory.this.cache.get(uri);
                    if (img == null) {
                        byte[] bimg = this.cacheInputStream(uri.toURL());
                        img = SwingTileFactory.this.createImage(bimg);
                        SwingTileFactory.this.cache.put(uri, bimg, img);
                        img = SwingTileFactory.this.cache.get(uri);
                    }
                    if (img == null) {
                        System.out.println("error loading: " + String.valueOf(uri));
                        System.err.println("Failed to load: " + String.valueOf(uri));
                        --trys;
                        continue;
                    }
                    final BufferedImage i = img;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            tile.image = new SoftReference<BufferedImage>(i);
                            tile.setLoaded(true);
                            SwingTileFactory.this.fireTileLoadedEvent((Tile)tile);
                        }
                    });
                }
                catch (OutOfMemoryError memErr) {
                    SwingTileFactory.this.cache.needMoreMemory();
                }
                catch (Throwable e) {
                    if (trys == 0) {
                        System.err.println("Failed to load a tile at url: " + tile.getURL() + ", stopping");
                        continue;
                    }
                    System.err.println("Failed to load a tile at url: " + tile.getURL() + ", retrying");
                    e.printStackTrace();
                    --trys;
                }
            }
            tile.setLoading(false);
        }

        private byte[] cacheInputStream(URL url) throws IOException {
            int n;
            URLConnection connection = url.openConnection();
            InputStream ins = connection.getInputStream();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((n = ins.read(buf)) != -1) {
                bout.write(buf, 0, n);
            }
            return bout.toByteArray();
        }
    }
}

