/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.barchart;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.high_d.barchart.BarChart;
import com.macrofocus.high_d.barchart.BarChartController;
import com.macrofocus.high_d.barchart.BarChartModel;
import com.macrofocus.high_d.barchart.BarChartView;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;

public abstract class AbstractBarChart<Component, Color, Row, Column>
implements BarChart<Component, Color, Row, Column> {
    private BarChartModel<Color, Row, Column> model;
    protected BarChartView<Component, Color, Row, Column> view;
    protected BarChartController controller;
    protected static LicenseModel licenseModel;

    public AbstractBarChart(BarChartModel<Color, Row, Column> model) {
        this.model = model;
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API_V1, username, key);
    }

    protected void load(DataFrame dataFrame) {
        this.setModel(this.createModel(dataFrame));
    }

    @Override
    public BarChartModel<Color, Row, Column> getModel() {
        return this.model;
    }

    @Override
    public void setModel(BarChartModel<Color, Row, Column> model) {
        if (this.model != model) {
            this.model = model;
            if (this.view != null) {
                this.view.setModel(model);
            }
        }
    }

    @Override
    public BarChartView<Component, Color, Row, Column> getView() {
        return this.view;
    }

    @Override
    public void setView(BarChartView<Component, Color, Row, Column> view) {
        if (this.view != view) {
            if (this.view != null) {
                this.view.setModel(null);
            }
            this.view = view;
            if (view != null) {
                view.setModel(this.model);
                this.view.setLicenseModel(licenseModel);
            }
        }
    }

    @Override
    public BarChartController getController() {
        return this.controller;
    }

    @Override
    public void setController(BarChartController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.setView(null);
            }
            this.controller = controller;
            if (controller != null) {
                controller.setView(this.view);
            }
        }
    }

    protected abstract BarChartModel<Color, Row, Column> createModel(DataFrame var1);

    protected abstract BarChartView<Component, Color, Row, Column> createView();

    protected abstract BarChartController createController(BarChartView var1);
}

