/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.controlchart;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.high_d.controlchart.ControlChart;
import com.macrofocus.high_d.controlchart.ControlChartScatterPlotModel;
import com.macrofocus.high_d.scatterplot.ScatterPlotController;
import com.macrofocus.high_d.scatterplot.ScatterPlotView;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;

public abstract class AbstractControlChart<Component, Color, Font, Row, Column>
implements ControlChart<Component, Color, Font, Row, Column> {
    private ControlChartScatterPlotModel<Color, Row, Column> model;
    protected ScatterPlotView<Component, Color, Font, Row, Column> view;
    protected ScatterPlotController controller;
    protected static LicenseModel licenseModel;

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API, username, key);
    }

    protected void load(DataFrame dataFrame) {
        this.setModel(this.createModel(dataFrame));
    }

    @Override
    public ControlChartScatterPlotModel<Color, Row, Column> getModel() {
        return this.model;
    }

    @Override
    public void setModel(ControlChartScatterPlotModel<Color, Row, Column> model) {
        if (this.model != model) {
            this.model = model;
            if (this.view != null) {
                this.view.setModel(model);
            }
        }
    }

    @Override
    public ScatterPlotView<Component, Color, Font, Row, Column> getView() {
        return this.view;
    }

    @Override
    public void setView(ScatterPlotView<Component, Color, Font, Row, Column> view) {
        if (this.view != view) {
            if (this.view != null) {
                this.view.setModel(null);
            }
            this.view = view;
            if (view != null) {
                view.setModel(this.model);
                this.view.setLicenseModel(licenseModel);
            }
        }
    }

    @Override
    public ScatterPlotController getController() {
        return this.controller;
    }

    @Override
    public void setController(ScatterPlotController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.setView(null);
            }
            this.controller = controller;
            if (controller != null) {
                controller.setView(this.view);
            }
        }
    }

    protected abstract ControlChartScatterPlotModel<Color, Row, Column> createModel(DataFrame var1);

    protected abstract ScatterPlotView<Component, Color, Font, Row, Column> createView();

    protected abstract ScatterPlotController createController(ScatterPlotView var1);
}

