/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions;

import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.distributions.DistributionsComponent;
import com.macrofocus.high_d.distributions.DistributionsModel;
import com.macrofocus.high_d.distributions.DistributionsView;
import com.macrofocus.high_d.interaction.InteractionMode;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.molap.colection.Maps;
import com.macrofocus.molap.subset.AutoSigmaDistributionStrategy;
import com.macrofocus.molap.subset.DistributionDimension;
import com.macrofocus.molap.subset.FixedDistributionStrategy;
import com.macrofocus.molap.subset.FixedSigmaDistributionStrategy;
import com.macrofocus.molap.subset.GenedataDistributionStrategy;
import com.macrofocus.molap.subset.SingleBinningDimension;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import com.macrofocus.rubberband.RubberBand;
import com.macrofocus.rubberband.SimpleRubberBand;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;

public abstract class AbstractDistributionsView<Component, Color, Row, Column, Value, Bin>
implements DistributionsView<Component, Color, Row, Column, Value, Bin> {
    private DistributionsModel<Color, Row, Column, Value, Bin> model;
    private final RubberBand rubberBand;
    private boolean isSelectionMode = true;
    protected final MutableProperties<DistributionsView.PropertyType> properties = new EnumProperties(DistributionsView.PropertyType.class);
    private final Map<Column, DistributionDimension<Row, Value, Bin>> binnedDimensions = Maps.createTHashMap();
    final SimpleSingleSelection<AbstractMap.SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>> probing = new SimpleSingleSelection();
    private final PropertiesListener<DistributionsView.PropertyType> propertiesListener = new PropertiesListener<DistributionsView.PropertyType>(){

        public void propertyChanged(DistributionsView.PropertyType name, PropertyEvent event) {
            AbstractDistributionsView.this.createOverplots();
        }
    };
    private final OrderListener<AxisModel<Row, Column>> orderListener = new OrderListener<AxisModel<Row, Column>>(){

        public void orderChanged(OrderEvent<AxisModel<Row, Column>> event) {
            AbstractDistributionsView.this.refresh();
        }

        public void orderVisibility(OrderEvent<AxisModel<Row, Column>> event) {
            AbstractDistributionsView.this.refresh();
        }

        public void orderAdded(OrderEvent<AxisModel<Row, Column>> event) {
            AbstractDistributionsView.this.refresh();
        }

        public void orderRemoved(OrderEvent<AxisModel<Row, Column>> event) {
            for (AxisModel axisModel : event.getAffected()) {
                AbstractDistributionsView.this.removeBinnedDimension(axisModel.getColumn());
            }
            AbstractDistributionsView.this.refresh();
        }
    };

    public AbstractDistributionsView(CPColorFactory<Color> factory) {
        this.properties.createProperty((Object)DistributionsView.PropertyType.Orientation, (Object)DistributionsView.Orientation.Horizontal);
        this.properties.createProperty((Object)DistributionsView.PropertyType.ShowFiltered, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)DistributionsView.PropertyType.ShowTiming, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)DistributionsView.PropertyType.Antialiasing, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)DistributionsView.PropertyType.ColorTheme, (Object)new LightColorTheme(factory));
        this.properties.createProperty((Object)DistributionsView.PropertyType.Rendering, (Object)CPCanvas.Rendering.Density);
        this.properties.createProperty((Object)DistributionsView.PropertyType.InteractionMode, (Object)InteractionMode.Filter);
        this.properties.addPropertiesListener(this.propertiesListener);
        this.rubberBand = new SimpleRubberBand();
    }

    @Override
    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    @Override
    public void setModel(DistributionsModel<Color, Row, Column, Value, Bin> model) {
        if (this.model != null) {
            this.model.getAxisGroupModel().getAxisOrder().removeOrderListener(this.orderListener);
        }
        this.model = model;
        this.getDistributionsComponent().setModel(model);
        if (this.model != null) {
            this.model.getAxisGroupModel().getAxisOrder().addOrderListener(this.orderListener);
        }
    }

    @Override
    public void setSelectionMode(boolean value) {
        this.isSelectionMode = value;
    }

    @Override
    public MutableSingleSelection<AbstractMap.SimpleImmutableEntry<SingleBinningDimension<Row, Bin>, Bin>> getProbing() {
        return this.probing;
    }

    @Override
    public DistributionsModel getModel() {
        return this.model;
    }

    protected abstract void refresh();

    protected abstract DistributionsComponent getDistributionsComponent();

    @Override
    public Property<DistributionsView.Orientation> getOrientation() {
        return this.properties.getProperty((Object)DistributionsView.PropertyType.Orientation);
    }

    @Override
    public MutableProperty<Boolean> getAntialiasing() {
        return this.properties.getProperty((Object)DistributionsView.PropertyType.Antialiasing);
    }

    @Override
    public Property<Boolean> getShowFiltered() {
        return this.properties.getProperty((Object)DistributionsView.PropertyType.ShowFiltered);
    }

    @Override
    public MutableProperty<Boolean> getShowTiming() {
        return this.properties.getProperty((Object)DistributionsView.PropertyType.ShowTiming);
    }

    @Override
    public MutableProperty<ColorTheme<Color>> getColorTheme() {
        return this.properties.getProperty((Object)DistributionsView.PropertyType.ColorTheme);
    }

    @Override
    public MutableProperty<InteractionMode> getInteractionMode() {
        return this.properties.getProperty((Object)DistributionsView.PropertyType.InteractionMode);
    }

    @Override
    public void setInteractionMode(MutableProperty<InteractionMode> interactionMode) {
        this.properties.replaceProperty((Object)DistributionsView.PropertyType.InteractionMode, interactionMode);
    }

    @Override
    public void setColorTheme(MutableProperty<ColorTheme<Color>> colorTheme) {
        this.properties.replaceProperty((Object)DistributionsView.PropertyType.ColorTheme, colorTheme);
    }

    @Override
    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        this.properties.replaceProperty((Object)DistributionsView.PropertyType.ShowFiltered, showFiltered);
    }

    @Override
    public void setAntialiasing(MutableProperty<Boolean> antialiasing) {
        this.properties.replaceProperty((Object)DistributionsView.PropertyType.Antialiasing, antialiasing);
    }

    @Override
    public void setShowTiming(MutableProperty<Boolean> showTiming) {
        this.properties.replaceProperty((Object)DistributionsView.PropertyType.ShowTiming, showTiming);
    }

    public MutableProperty<CPCanvas.Rendering> getRendering() {
        return this.properties.getProperty((Object)DistributionsView.PropertyType.Rendering);
    }

    @Override
    public void setRendering(MutableProperty<CPCanvas.Rendering> rendering) {
        this.properties.replaceProperty((Object)DistributionsView.PropertyType.Rendering, rendering);
    }

    @Override
    public DistributionDimension<Row, Value, Bin> getDistributionDimension(final AxisModel<Row, Column> axisModel) {
        DistributionDimension<Row, Value, Bin> dimension;
        Object column = axisModel.getColumn();
        if (this.binnedDimensions.containsKey(column)) {
            return this.binnedDimensions.get(column);
        }
        if (axisModel.isNumerical()) {
            AxisModel.BinType type;
            Object propertyListener;
            final MutableProperty binType = axisModel.getBinType();
            final MutableProperty binCount = axisModel.getBinCount();
            if (binType != null) {
                propertyListener = new PropertyListener<AxisModel.BinType>(){

                    public void propertyChanged(PropertyEvent<AxisModel.BinType> event) {
                        binType.removePropertyListener((PropertyListener)this);
                        AbstractDistributionsView.this.removeBinnedDimension(axisModel.getColumn());
                        AbstractDistributionsView.this.refresh();
                    }
                };
                binType.addPropertyListener((PropertyListener)propertyListener);
            }
            if (binCount != null) {
                propertyListener = new PropertyListener<Integer>(){

                    public void propertyChanged(PropertyEvent<Integer> event) {
                        binCount.removePropertyListener((PropertyListener)this);
                        AbstractDistributionsView.this.removeBinnedDimension(axisModel.getColumn());
                        AbstractDistributionsView.this.refresh();
                    }
                };
                binCount.addPropertyListener((PropertyListener)propertyListener);
            }
            if (binType != null) {
                switch ((AxisModel.BinType)binType.getValue()) {
                    case Auto: {
                        type = (AxisModel.BinType)binType.getValue();
                        break;
                    }
                    case Fixed: {
                        if (binCount != null && (Integer)binCount.getValue() > 1) {
                            type = (AxisModel.BinType)binType.getValue();
                            break;
                        }
                        type = AxisModel.BinType.Auto;
                        break;
                    }
                    case AutoSigma: {
                        type = (AxisModel.BinType)binType.getValue();
                        break;
                    }
                    case Sigma: {
                        if (binCount != null && (Integer)binCount.getValue() > 1) {
                            type = (AxisModel.BinType)binType.getValue();
                            break;
                        }
                        type = AxisModel.BinType.AutoSigma;
                        break;
                    }
                    default: {
                        type = AxisModel.BinType.Auto;
                        break;
                    }
                }
            } else {
                type = AxisModel.BinType.Auto;
            }
            switch (type) {
                case Auto: {
                    Object[] values = new Number[axisModel.getRowCount()];
                    int count = 0;
                    for (int i = 0; i < axisModel.getRowCount(); ++i) {
                        Number value = axisModel.getValue(axisModel.getRow(i));
                        if (value == null) continue;
                        values[count] = value;
                        ++count;
                    }
                    if (count > 0) {
                        Arrays.sort(values, 0, count);
                        GenedataDistributionStrategy distributionStrategy = new GenedataDistributionStrategy((Number[])values, count);
                        dimension = this.model.createDistributionDimension(column, (DistributionDimension.DistributionStrategy)distributionStrategy);
                        break;
                    }
                }
                case Fixed: {
                    dimension = this.model.createDistributionDimension(column, (DistributionDimension.DistributionStrategy)new FixedDistributionStrategy(binCount != null ? (Integer)binCount.getValue() : (int)Math.sqrt(axisModel.getRowCount()), axisModel.getMinimum(), axisModel.getMaximum()));
                    break;
                }
                case AutoSigma: {
                    dimension = this.model.createDistributionDimension(column, (DistributionDimension.DistributionStrategy)new AutoSigmaDistributionStrategy(binCount != null ? (Integer)binCount.getValue() : (int)Math.sqrt(axisModel.getRowCount()), axisModel.getMinimum(), axisModel.getMean(), axisModel.getStdDev(), axisModel.getMaximum()));
                    break;
                }
                case Sigma: {
                    dimension = this.model.createDistributionDimension(column, (DistributionDimension.DistributionStrategy)new FixedSigmaDistributionStrategy(binCount != null ? (Integer)binCount.getValue() : (int)Math.sqrt(axisModel.getRowCount()), axisModel.getMinimum(), axisModel.getMean(), axisModel.getStdDev(), axisModel.getMaximum()));
                    break;
                }
                default: {
                    dimension = null;
                    break;
                }
            }
        } else {
            final FixedDistributionStrategy distributionStrategy = new FixedDistributionStrategy((int)(axisModel.getMaximum() - axisModel.getMinimum()) + 2, axisModel.getMinimum(), axisModel.getMaximum());
            dimension = this.model.createDistributionDimension(column, (DistributionDimension.DistributionStrategy)distributionStrategy);
            dimension.setBinningStrategy(new SingleBinningDimension.SingleBinningStrategy<Row, Bin>(){

                public boolean isBinnable(Row row) {
                    return distributionStrategy.isBinnable((Object)axisModel.getValue(row));
                }

                public Bin rowToBin(Row row) {
                    return distributionStrategy.valueToBin((Object)axisModel.getValue(row));
                }
            });
        }
        this.binnedDimensions.put(column, dimension);
        return dimension;
    }

    protected void removeBinnedDimension(Column column) {
        if (this.binnedDimensions.containsKey(column)) {
            this.model.removeDistributionDimension(this.binnedDimensions.get(column));
            this.binnedDimensions.remove(column);
        }
    }

    private void createOverplots() {
        if (this.getDistributionsComponent() != null) {
            this.getDistributionsComponent().createOverplots();
            this.getDistributionsComponent().scheduleUpdate();
        }
    }

    @Override
    public RubberBand getRubberBand() {
        return this.rubberBand;
    }
}

