/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions;

import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.Filter;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.group.DefaultAxisGroupModel;
import com.macrofocus.high_d.axis.locations.AxisLocations;
import com.macrofocus.high_d.axis.locations.DefaultAxisLocations;
import com.macrofocus.high_d.distributions.AbstractDistributionsModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.subset.DistributionDimension;
import com.macrofocus.molap.subset.SubsetDataFrame;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DefaultDistributionsModel<Color, Row, Column, Value, Bin>
extends AbstractDistributionsModel<Color, Row, Column, Value, Bin>
implements VisualObjects<Row> {
    private final DataFrame<Row, Column, ?> dataFrame;
    private final SubsetDataFrame<Row, Column, Value> subsetDataFrame;
    private final Visual<Color, Row, Column> visual;
    private final AxisGroupModel<Row, Column> axisGroupModel;
    private final AxisLocations axisLocations;
    private final AxisModel order = null;
    private final List<Row> sortedRow;
    private RowComparator rowComparator;
    private final MutableProperties properties = new SimpleProperties();
    private final Property<Integer> maxDimensions = this.properties.createProperty((Object)"maxDimensions", (Object)Integer.MAX_VALUE);

    public DefaultDistributionsModel(CPFactory<?, ?, ?, Color> factory, ColorMapFactory<Color> colorMapFactory, DataFrame<Row, Column, ?> dataFrame, SubsetDataFrame<Row, Column, Value> subsetDataFrame) {
        this(factory, dataFrame, subsetDataFrame, (Visual<Color, Row, Column>)new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), (MutableColorMapping)new SimpleColorMapping(colorMapFactory, dataFrame)));
    }

    public DefaultDistributionsModel(CPFactory<?, ?, ?, Color> factory, DataFrame<Row, Column, ?> dataFrame, SubsetDataFrame<Row, Column, Value> subsetDataFrame, Visual<Color, Row, Column> visual) {
        this(dataFrame, subsetDataFrame, visual, (AxisGroupModel<Row, Column>)new DefaultAxisGroupModel(factory, "Root", dataFrame, null, (SingleSelection)visual.getProbing(), (Selection)visual.getSelection(), (MutableFilter)visual.getFilter()));
    }

    public DefaultDistributionsModel(DataFrame<Row, Column, ?> dataFrame, SubsetDataFrame<Row, Column, Value> subsetDataFrame, Visual<Color, Row, Column> visual, AxisGroupModel<Row, Column> axisGroupModel) {
        this.dataFrame = dataFrame;
        this.subsetDataFrame = subsetDataFrame;
        this.axisGroupModel = axisGroupModel;
        this.axisLocations = new DefaultAxisLocations(axisGroupModel.getAxisOrder(), this.maxDimensions);
        this.visual = visual;
        this.sortedRow = new ArrayList<Row>();
        for (int r = 0; r < this.getObjectCount(); ++r) {
            this.sortedRow.add(this.getObject(r));
        }
    }

    @Override
    public Visual<Color, Row, Column> getVisual() {
        return this.visual;
    }

    @Override
    public int getObjectCount() {
        return this.dataFrame.getRowCount();
    }

    @Override
    public MutableSingleSelection<Row> getProbing() {
        return this.visual.getProbing();
    }

    @Override
    public MutableSelection<Row> getSelection() {
        return this.visual.getSelection();
    }

    @Override
    public Filter<Row> getFilter() {
        return this.visual.getFilter();
    }

    @Override
    public MutableColorMapping<Color, Row, Column> getColorMapping() {
        return this.visual.getColorMapping();
    }

    @Override
    public MutableColoring<Color, Row> getColoring() {
        return this.visual.getColoring();
    }

    @Override
    public Row getObject(int index) {
        if (this.order != null) {
            return this.sortedRow.get(index);
        }
        return (Row)this.dataFrame.getRowKey(index);
    }

    @Override
    public int getIndex(Row row) {
        if (this.order != null) {
            return Collections.binarySearch(this.sortedRow, row, this.rowComparator);
        }
        return this.dataFrame.getRowAddress(row);
    }

    private AxisModel getAxisModel(int c) {
        return (AxisModel)this.axisGroupModel.getAxisOrder().get(c);
    }

    @Override
    public int getAxisCount() {
        return this.axisGroupModel.getAxisOrder().size();
    }

    @Override
    public Double getLocation(AxisModel axisModel) {
        return this.axisLocations.getLocation(Alignment.Left, axisModel);
    }

    @Override
    public AxisGroupModel<Row, Column> getAxisGroupModel() {
        return this.axisGroupModel;
    }

    @Override
    public void setLocation(AxisModel axisModel, double l) {
        this.axisLocations.setLocation(Alignment.Left, axisModel, l);
        this.firedDistributionsChanged();
    }

    public int getVisibleAxisCount() {
        return this.axisGroupModel.getAxisOrder().size();
    }

    @Override
    public DistributionDimension<Row, Value, Bin> createDistributionDimension(Column column, DistributionDimension.DistributionStrategy distributionStrategy) {
        return this.subsetDataFrame.getDistributionDimension(column, distributionStrategy);
    }

    @Override
    public void removeDistributionDimension(DistributionDimension<Row, Value, Bin> distributionDimension) {
        this.subsetDataFrame.removeDimension(distributionDimension);
    }

    private class RowComparator
    implements Comparator<Row> {
        private final AxisModel axisModel;

        public RowComparator(AxisModel axisModel) {
            this.axisModel = axisModel;
        }

        @Override
        public int compare(Row o1, Row o2) {
            Number v1 = this.axisModel.getValue(o1);
            if (v1 != null) {
                Number v2 = this.axisModel.getValue(o2);
                if (v2 != null) {
                    int c = Double.compare(v1.doubleValue(), v2.doubleValue());
                    if (c == 0) {
                        return 0;
                    }
                    return c;
                }
                return -1;
            }
            Number v2 = this.axisModel.getValue(o2);
            if (v2 != null) {
                return 1;
            }
            return 0;
        }
    }
}

