/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.heatmap;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.high_d.heatmap.HeatMap;
import com.macrofocus.high_d.heatmap.HeatMapController;
import com.macrofocus.high_d.heatmap.HeatMapModel;
import com.macrofocus.high_d.heatmap.HeatMapView;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;

public abstract class AbstractHeatMap<Component, Color, Row, Column>
implements HeatMap<Component, Color, Row, Column> {
    private HeatMapModel<Color, Row, Column> model;
    protected HeatMapView<Component, Color, Row, Column> view;
    protected HeatMapController controller;
    protected static LicenseModel licenseModel;

    public AbstractHeatMap(HeatMapModel<Color, Row, Column> model) {
        this.model = model;
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API_V1, username, key);
    }

    protected void load(DataFrame dataFrame) {
        this.setModel(this.createModel(dataFrame));
    }

    @Override
    public HeatMapModel<Color, Row, Column> getModel() {
        return this.model;
    }

    @Override
    public void setModel(HeatMapModel<Color, Row, Column> model) {
        if (this.model != model) {
            this.model = model;
            if (this.view != null) {
                this.view.setModel(model);
            }
        }
    }

    @Override
    public HeatMapView<Component, Color, Row, Column> getView() {
        return this.view;
    }

    @Override
    public void setView(HeatMapView<Component, Color, Row, Column> view) {
        if (this.view != view) {
            if (this.view != null) {
                this.view.setModel(null);
            }
            this.view = view;
            if (view != null) {
                view.setModel(this.model);
                this.view.setLicenseModel(licenseModel);
            }
        }
    }

    @Override
    public HeatMapController getController() {
        return this.controller;
    }

    @Override
    public void setController(HeatMapController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.setView(null);
            }
            this.controller = controller;
            if (controller != null) {
                controller.setView(this.view);
            }
        }
    }

    protected abstract HeatMapModel<Color, Row, Column> createModel(DataFrame var1);

    protected abstract HeatMapView<Component, Color, Row, Column> createView();

    protected abstract HeatMapController createController(HeatMapView var1);
}

