/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds.pca;

import com.macrofocus.high_d.mds.AbstractMDSEngine;
import com.macrofocus.high_d.mds.MDSEngineEvent;
import com.macrofocus.high_d.mds.MDSModel;
import com.macrofocus.high_d.mds.pca.EigenvalueDecomposition;
import com.macrofocus.high_d.mds.pca.PCAMatrix;
import com.macrofocus.high_d.mds.pca.PCAModel;
import com.macrofocus.molap.dataframe.matrix.Matrix;
import com.macrofocus.timer.CPExecutor;

public class PCAMDSEngine
extends AbstractMDSEngine {
    private Matrix correlations;
    private PCAModel pcaModel;
    private Matrix matrixModel;

    public PCAMDSEngine(CPExecutor executor) {
        super(executor);
    }

    public PCAMDSEngine(PCAModel pcaModel, Matrix matrixModel, Matrix correlations, CPExecutor executor) {
        this(executor);
        this.setParameters(pcaModel, matrixModel, correlations);
    }

    @Override
    public MDSModel getModel() {
        return this.pcaModel;
    }

    @Override
    protected Matrix getDistanceTable() {
        throw new UnsupportedOperationException();
    }

    public void setParameters(PCAModel pcaModel, Matrix matrixModel, Matrix correlations) {
        this.pcaModel = pcaModel;
        this.matrixModel = matrixModel;
        this.correlations = correlations;
    }

    @Override
    public CPExecutor.Command createRunCommand() {
        return new CPExecutor.Command(){

            public boolean execute() {
                PCAMatrix matrix = new PCAMatrix(PCAMDSEngine.this.correlations.getRowCount(), PCAMDSEngine.this.correlations.getColumnCount());
                for (int row = 0; row < PCAMDSEngine.this.correlations.getRowCount(); ++row) {
                    for (int column = 0; column < PCAMDSEngine.this.correlations.getColumnCount(); ++column) {
                        matrix.set(row, column, PCAMDSEngine.this.correlations.getDouble(PCAMDSEngine.this.correlations.getRowKey(row), PCAMDSEngine.this.correlations.getColumnKey(column)));
                    }
                }
                EigenvalueDecomposition pca = new EigenvalueDecomposition(matrix);
                double[] eigenvalues = pca.getRealEigenvalues();
                double[][] eigenvectors = pca.getV().getArray();
                int n = eigenvalues.length;
                for (int i = 0; i < n / 2; ++i) {
                    double tmp = eigenvalues[i];
                    eigenvalues[i] = Math.abs(eigenvalues[n - i - 1]);
                    eigenvalues[n - i - 1] = Math.abs(tmp);
                    double[] tmp1 = eigenvectors[i];
                    eigenvectors[i] = eigenvectors[n - i - 1];
                    eigenvectors[n - i - 1] = tmp1;
                }
                for (int row = 0; row < PCAMDSEngine.this.matrixModel.getRowCount() && !PCAMDSEngine.this.isInterrupted(); ++row) {
                    double x = 0.0;
                    double y = 0.0;
                    double[] v2 = new double[PCAMDSEngine.this.matrixModel.getColumnCount()];
                    for (int i = 0; i < PCAMDSEngine.this.matrixModel.getColumnCount(); ++i) {
                        v2[i] = 0.0;
                        double length = 0.0;
                        for (int j = 0; j < PCAMDSEngine.this.matrixModel.getColumnCount(); ++j) {
                            int n2 = i;
                            v2[n2] = v2[n2] + eigenvectors[i][j] * PCAMDSEngine.this.matrixModel.getDouble(PCAMDSEngine.this.matrixModel.getRowKey(row), PCAMDSEngine.this.matrixModel.getColumnKey(j));
                            length += eigenvectors[i][j] * eigenvectors[i][j];
                        }
                        int n3 = i;
                        v2[n3] = v2[n3] / length;
                        int n4 = i;
                        v2[n4] = v2[n4] * Math.sqrt(eigenvalues[i]);
                    }
                    PCAMDSEngine.this.pcaModel.setX(row, v2[0]);
                    PCAMDSEngine.this.pcaModel.setY(row, v2[1]);
                }
                PCAMDSEngine.this.notifyEngineIterated(new MDSEngineEvent(PCAMDSEngine.this, 1));
                PCAMDSEngine.this.notifyEngineFinished(new MDSEngineEvent(PCAMDSEngine.this, 1));
                return false;
            }
        };
    }
}

