/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates;

import com.macrofocus.common.properties.Property;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.geom.Line2D;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesComponent;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesListener;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.geometry.Geometry;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayout;
import com.macrofocus.igraphics.AbstractIDrawing;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.pressure.LogPressure;
import com.macrofocus.igraphics.pressure.Pressure;
import com.macrofocus.palette.FixedPalette;
import com.macrofocus.rubberband.RubberbandDrawing;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.macrofocus.timer.VisualizationExecutorService;
import com.macrofocus.visual.VisualLayer;
import com.macrofocus.visual.VisualListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class AbstractParallelCoordinatesComponent<Component, Color, Row, C>
implements ParallelCoordinatesComponent<Component, Color, Row, C> {
    protected ParallelCoordinatesModel<Color, Row, C> model;
    protected final int level;
    protected final CPCanvas canvas;
    private final CPFactory<?, ?, ?, Color> factory;
    private static final float coloredStroke = 1.5f;
    private static final float probingStroke = 4.0f;
    private static final float selectionStroke = 2.0f;
    private static final float axisStroke = 3.0f;
    private static final float rubberbandStroke = 1.0f;
    private static final boolean MULTITHREADED = true;
    private static final VisualizationExecutorService executor = VisualizationExecutorService.getInstance();
    private static final Pressure logPressure = new Pressure(){

        public double transform(double v) {
            if (v > 0.0) {
                return v;
            }
            return 0.0;
        }
    };
    protected final ParallelCoordinatesView<Component, CPColor, Row, C> view;
    private final Cache cache = new Cache();
    private final ParallelCoordinatesListener listener = new ParallelCoordinatesListener(){

        @Override
        public void pararallelCoordinatesChanged() {
            AbstractParallelCoordinatesComponent.this.repaint();
        }
    };
    protected final CPTimer timer;

    protected AbstractParallelCoordinatesComponent(ParallelCoordinatesView view, CPCanvas canvas, CPFactory<?, ?, ?, Color> factory, int level) {
        this.view = view;
        this.canvas = canvas;
        this.factory = factory;
        this.level = level;
        this.timer = factory.createTimer("ParallelCoordinates$Resizer", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                if (AbstractParallelCoordinatesComponent.this.getWidth() > 0 && AbstractParallelCoordinatesComponent.this.getHeight() > 0) {
                    AbstractParallelCoordinatesComponent.this.refresh();
                }
            }
        });
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void refresh();

    protected abstract void repaint();

    @Override
    public void setModel(ParallelCoordinatesModel<Color, Row, C> model) {
        if (this.model != null) {
            this.model.removeParallelCoordinateListener(this.listener);
        }
        this.model = model;
        if (model != null) {
            this.createOverplots();
            model.addParallelCoordinatesListener(this.listener);
        }
        this.cache.clear();
        if (model != null) {
            this.timer.restart();
        }
    }

    @Override
    public void createOverplots() {
        if (this.model != null) {
            this.canvas.removeAllLayers();
            this.canvas.addLayer((IDrawing)new AbstractIDrawing(){

                public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
                    CPColor background = ((ColorTheme)AbstractParallelCoordinatesComponent.this.view.getColorTheme().getValue()).getBackground();
                    if (background != null) {
                        g.setColor(background);
                        g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
                    }
                }
            });
            this.canvas.addLayer((IDrawing)new AbstractIDrawing(){

                public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
                    if (AbstractParallelCoordinatesComponent.this.view.getGeometry().getValue() != Geometry.Steps && ((Boolean)AbstractParallelCoordinatesComponent.this.view.getAxisLine().getValue()).booleanValue()) {
                        g.setColor(((ColorTheme)AbstractParallelCoordinatesComponent.this.view.getColorTheme().getValue()).getForeground());
                        g.setLineWidth(3.0);
                        ParallelCoordinatesLayout layout = AbstractParallelCoordinatesComponent.this.view.getParallelCoordinatesLayout();
                        for (AxisGroupModel axisGroup : layout.getAxisGroups(AbstractParallelCoordinatesComponent.this.level)) {
                            for (AxisModel axisModel : axisGroup.getAxisOrder()) {
                                int x = AbstractParallelCoordinatesComponent.this.view.getAxisX(axisGroup, axisModel) + layout.getAxisPreferredWidth() / 2;
                                Rectangle2D trackBounds = layout.getTrackBounds(axisGroup, axisModel);
                                g.drawLine(x, (int)trackBounds.getY(), x, (int)(trackBounds.getY() + trackBounds.getHeight()));
                            }
                        }
                    }
                }
            });
            this.canvas.addDensityLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getFiltered(), this.cache, 0, this.level){

                @Override
                public boolean isActive() {
                    return (Boolean)AbstractParallelCoordinatesComponent.this.view.getShowFiltered().getValue() != false && super.isActive();
                }

                @Override
                public void draw(IGraphics g, Shape shape, Row row) {
                    g.drawShape(shape);
                }
            }, (Pressure)new LogPressure(), new CPCanvas.PaletteProvider(){

                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractParallelCoordinatesComponent.this.view.getColorTheme().getValue()).getGhostedPalette();
                }
            });
            this.canvas.addDensityLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getVisible(), this.cache, 0, this.level){

                @Override
                public void draw(IGraphics g, Shape shape, Row row) {
                    g.drawShape(shape);
                }
            }, (Pressure)new LogPressure(), new CPCanvas.PaletteProvider(){

                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractParallelCoordinatesComponent.this.view.getColorTheme().getValue()).getVisiblePalette();
                }
            });
            this.canvas.addAveragingLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getColorMapped(), this.cache, 0, this.level){

                @Override
                public void draw(IGraphics g, Shape shape, Row row) {
                    g.setColor(AbstractParallelCoordinatesComponent.this.model.getColorMapping().getColor(row));
                    g.drawShape(shape);
                }
            });
            this.canvas.addBufferedLayer((IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getColored(), this.cache, 0, this.level){

                @Override
                public void draw(IGraphics g, Shape shape, Row row) {
                    g.setLineWidth(1.5);
                    g.setColor(AbstractParallelCoordinatesComponent.this.model.getColoring().getColor(row));
                    g.drawShape(shape);
                }
            });
            this.canvas.addDensityLayer((CPCanvas.Rendering)this.view.getRendering().getValue(), (IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getMultipleSelected(), this.cache, 0, this.level){

                @Override
                public void draw(IGraphics g, Shape shape, Row row) {
                    g.setColor(((ColorTheme)AbstractParallelCoordinatesComponent.this.view.getColorTheme().getValue()).getSelection());
                    g.drawShape(shape);
                }
            }, (Pressure)new LogPressure(), new CPCanvas.PaletteProvider(){

                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractParallelCoordinatesComponent.this.view.getColorTheme().getValue()).getSelectedPalette();
                }
            });
            this.canvas.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getSingleSelected(), this.cache, 0, this.level){

                @Override
                public void draw(IGraphics g, Shape shape, Row row) {
                    g.setLineWidth(2.0);
                    g.setColor(((ColorTheme)AbstractParallelCoordinatesComponent.this.view.getColorTheme().getValue()).getSelection());
                    g.drawShape(shape);
                }
            });
            this.canvas.addLayer((IDrawing)new AbstractVisualLayerIDrawing(this.model.getVisual().getProbed(), this.cache, 0, this.level){

                @Override
                public void draw(IGraphics g, Shape shape, Row row) {
                    g.setLineWidth(4.0);
                    g.setColor(((ColorTheme)AbstractParallelCoordinatesComponent.this.view.getColorTheme().getValue()).getProbing());
                    g.drawShape(shape);
                    if (AbstractParallelCoordinatesComponent.this.model.getVisual().getSelection().isSelected(row)) {
                        g.setLineWidth(2.0);
                        g.setColor(((ColorTheme)AbstractParallelCoordinatesComponent.this.view.getColorTheme().getValue()).getSelection());
                        g.drawShape(shape);
                    }
                }
            });
            this.canvas.addLayer((IDrawing)new AnnotationIDrawing((Selection<Object>)this.model.getVisual().getAnnotationProbing(), this.factory.createRGBAColor(255, 150, 0, 200)));
            this.canvas.addLayer((IDrawing)new AnnotationIDrawing((Selection<Object>)this.model.getVisual().getAnnotationSelection(), this.factory.createRGBAColor(255, 100, 0, 200)));
            this.canvas.addLayer((IDrawing)new AbstractIDrawing(){

                public boolean isActive() {
                    return (Boolean)AbstractParallelCoordinatesComponent.this.view.getShowProbedValues().getValue();
                }

                public void draw(IGraphics g, Point2D point, double w, double h, Rectangle clipBounds) {
                    Object row = AbstractParallelCoordinatesComponent.this.model.getProbing().getSelected();
                    if (row != null) {
                        ParallelCoordinatesLayout layout = AbstractParallelCoordinatesComponent.this.view.getParallelCoordinatesLayout();
                        for (AxisGroupModel axisGroup : layout.getAxisGroups(AbstractParallelCoordinatesComponent.this.level)) {
                            if (axisGroup.isCollapsed()) continue;
                            for (AxisModel axisModel : axisGroup.getAxisOrder()) {
                                Rectangle2D trackBounds = layout.getTrackBounds(axisGroup, axisModel);
                                int x = (int)trackBounds.getX() + layout.getAxisPreferredWidth() / 2;
                                Number value = axisModel.getValue(0, row);
                                boolean currentAvailable = value != null;
                                if (!currentAvailable) continue;
                                int height = (int)trackBounds.getHeight();
                                Rectangle2D levelBounds = AbstractParallelCoordinatesComponent.this.view.getParallelCoordinatesLayout().getLevelBounds(AbstractParallelCoordinatesComponent.this.level);
                                int fullHeight = (int)levelBounds.getHeight();
                                double y = Geometry.getY(fullHeight, height, layout.getAxisAfterTrackGap(), value.doubleValue(), axisModel);
                                String formattedValue = axisModel.getFormattedValue(row);
                                Rectangle2D bounds = g.getStringBounds(formattedValue);
                                if (((ColorTheme)AbstractParallelCoordinatesComponent.this.view.getColorTheme().getValue()).isDark()) {
                                    g.setColor(AbstractParallelCoordinatesComponent.this.factory.createRGBAColor(0, 0, 0, 191));
                                } else {
                                    g.setColor(AbstractParallelCoordinatesComponent.this.factory.createRGBAColor(0, 0, 0, 191));
                                }
                                y = y > (double)(fullHeight / 2) ? (y -= 16.0 + bounds.getHeight() / 2.0) : (y += 16.0 + bounds.getHeight() / 2.0);
                                g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double((double)(x - 2), y - bounds.getHeight() / 2.0 - 2.0, bounds.getWidth() + 4.0, bounds.getHeight() + 4.0));
                                g.setTextBaseline(IGraphics.TextBaseline.Middle);
                                g.setColor(((ColorTheme)AbstractParallelCoordinatesComponent.this.view.getColorTheme().getValue()).getProbing());
                                g.drawString(formattedValue, (float)x, (float)y);
                            }
                        }
                    }
                }
            });
            this.canvas.addLayer((IDrawing)new RubberbandDrawing((CPColorFactory)this.factory, this.view.getRubberBand()){

                protected Property<ColorTheme<CPColor>> getColorTheme() {
                    return AbstractParallelCoordinatesComponent.this.view.getColorTheme();
                }
            });
        }
    }

    protected Shape getShape(int layer, Object row, int level) {
        return this.cache.getShape(layer, row, level);
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public Row getClosestRow(int x, int y) {
        double bestdistance = Double.MAX_VALUE;
        Row bestrow = null;
        if (this.model != null) {
            for (int row = 0; row < this.model.getObjectCount(); ++row) {
                Shape line;
                Row rowObject = this.model.getObject(row);
                MutableFilter<Row> filter = this.model.getFilter();
                if (filter.isFiltered(rowObject) || (line = this.getShape(0, rowObject, this.level)) == null) continue;
                PathIterator pi = line.getPathIterator();
                float[] data = new float[6];
                int previousX = 0;
                int previousY = 0;
                double lastdistance = Double.MAX_VALUE;
                boolean willNotImprove = false;
                while (!willNotImprove && !pi.isDone()) {
                    int segType = pi.currentSegment(data);
                    switch (segType) {
                        case 0: {
                            previousX = (int)data[0];
                            previousY = (int)data[1];
                            double distance = AbstractParallelCoordinatesComponent.distance(previousX, previousY, x, y);
                            if (distance < bestdistance) {
                                bestdistance = distance;
                                bestrow = rowObject;
                            }
                            if (distance > lastdistance) {
                                // empty if block
                            }
                            lastdistance = distance;
                            break;
                        }
                        case 1: {
                            int currentX = (int)data[0];
                            int currentY = (int)data[1];
                            double distance = Line2D.ptSegDist((double)previousX, (double)previousY, (double)currentX, (double)currentY, (double)x, (double)y);
                            if (distance < bestdistance) {
                                bestdistance = distance;
                                bestrow = rowObject;
                            }
                            if (distance > lastdistance) {
                                // empty if block
                            }
                            lastdistance = distance;
                            previousX = currentX;
                            previousY = currentY;
                            break;
                        }
                        default: {
                            throw new Error("Segmented type unsupported");
                        }
                    }
                    pi.next();
                }
            }
        }
        return bestrow;
    }

    @Override
    public List<Row> getRows(Rectangle2D r) {
        if (this.model != null) {
            ArrayList<Row> list = new ArrayList<Row>();
            block4: for (int row = 0; row < this.model.getObjectCount(); ++row) {
                Shape line;
                Row rowObject = this.model.getObject(row);
                MutableFilter<Row> filter = this.model.getFilter();
                if (filter.isFiltered(rowObject) || (line = this.getShape(0, rowObject, this.level)) == null) continue;
                PathIterator pi = line.getPathIterator();
                float[] data = new float[6];
                int previousX = 0;
                int previousY = 0;
                while (!pi.isDone()) {
                    int segType = pi.currentSegment(data);
                    switch (segType) {
                        case 0: {
                            previousX = (int)data[0];
                            previousY = (int)data[1];
                            break;
                        }
                        case 1: {
                            int currentX = (int)data[0];
                            int currentY = (int)data[1];
                            if (r.intersectsLine((double)previousX, (double)previousY, (double)currentX, (double)currentY)) {
                                list.add(rowObject);
                                continue block4;
                            }
                            previousX = currentX;
                            previousY = currentY;
                            break;
                        }
                        default: {
                            throw new Error("Segmented type unsupported");
                        }
                    }
                    pi.next();
                }
            }
            return list;
        }
        return null;
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 -= x2) * x1 + (y1 -= y2) * y1);
    }

    public class Cache {
        private final Map<Row, Shape> shapes;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        public Cache() {
            this.shapes = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Shape getShape(int layer, Row row, int level) {
            this.lock.readLock().lock();
            try {
                if (this.shapes.containsKey(row)) {
                    Shape shape = this.shapes.get(row);
                    return shape;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            try {
                Rectangle2D levelBounds = AbstractParallelCoordinatesComponent.this.view.getParallelCoordinatesLayout().getLevelBounds(level);
                int fullHeight = (int)levelBounds.getHeight();
                Shape shape = this.createShape(fullHeight, layer, row, level);
                this.lock.writeLock().lock();
                try {
                    this.shapes.put(row, shape);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                return shape;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return null;
            }
        }

        private Shape createShape(int fullHeight, int layer, Row row, int level) {
            return ((Geometry)((Object)AbstractParallelCoordinatesComponent.this.view.getGeometry().getValue())).createGeometry(AbstractParallelCoordinatesComponent.this.view, AbstractParallelCoordinatesComponent.this.model, fullHeight, layer, row, level);
        }

        public void clear() {
            this.lock.writeLock().lock();
            try {
                this.shapes.clear();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    private class AnnotationIDrawing
    extends AbstractIDrawing {
        private final Selection<Object> selection;
        private final CPColor<Color> color;
        private final SelectionListener<Object> selectionListener = new SelectionListener<Object>(){

            public void selectionChanged(SelectionEvent<Object> event) {
                AnnotationIDrawing.this.notifyIDrawingChanged();
            }
        };

        public AnnotationIDrawing(Selection<Object> selection, CPColor<Color> color) {
            this.selection = selection;
            this.color = color;
            selection.addWeakSelectionListener(this.selectionListener);
        }

        public boolean isActive() {
            return this.selection.isActive();
        }

        public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
            for (Object row : this.selection) {
                g.setColor(this.color);
                Rectangle2D levelBounds = AbstractParallelCoordinatesComponent.this.view.getParallelCoordinatesLayout().getLevelBounds(AbstractParallelCoordinatesComponent.this.level);
                int fullHeight = (int)levelBounds.getHeight();
                Shape shape = AbstractParallelCoordinatesComponent.this.cache.createShape(fullHeight, 1, row, AbstractParallelCoordinatesComponent.this.level);
                g.drawShape(shape);
            }
        }
    }

    public abstract class AbstractVisualLayerIDrawing
    extends AbstractIDrawing {
        private final VisualLayer<Row> visualLayer;
        private final Cache cache;
        private final int layer;
        private final int level;

        protected AbstractVisualLayerIDrawing(VisualLayer<Row> visualLayer, Cache cache, int layer, int level) {
            this.visualLayer = visualLayer;
            this.cache = cache;
            this.layer = layer;
            this.level = level;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    AbstractVisualLayerIDrawing.this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(final IGraphics g, Point2D point, double gw, double gh, Rectangle clipBounds) {
            block11: {
                if (this.visualLayer.getObjectCount() <= 0) break block11;
                this.init(g);
                if (!g.isThreadSafe()) {
                    for (Object row : this.visualLayer) {
                        Shape geometry = this.cache.getShape(this.layer, row, this.level);
                        if (geometry == null) continue;
                        this.draw(g, geometry, row);
                    }
                } else {
                    int nTasks = Math.min(executor.getAvailableProcessors(), this.visualLayer.getObjectCount());
                    int nRowsPerTask = this.visualLayer.getObjectCount() / nTasks;
                    ArrayList<2> todo = new ArrayList<2>(nTasks);
                    for (int nTask = 0; nTask < nTasks; ++nTask) {
                        final int fromRow = nTask * nRowsPerTask;
                        final int toRow = nTask < nTasks - 1 ? fromRow + nRowsPerTask : this.visualLayer.getObjectCount();
                        todo.add(new Callable<Object>(){
                            private final int from;
                            private final int to;
                            {
                                this.from = fromRow;
                                this.to = toRow;
                            }

                            @Override
                            public Object call() throws Exception {
                                for (Object row : AbstractVisualLayerIDrawing.this.visualLayer.iterable(this.from, this.to - 1)) {
                                    Shape geometry = AbstractVisualLayerIDrawing.this.cache.getShape(AbstractVisualLayerIDrawing.this.layer, row, AbstractVisualLayerIDrawing.this.level);
                                    if (geometry == null) continue;
                                    AbstractVisualLayerIDrawing.this.draw(g, geometry, row);
                                }
                                return null;
                            }
                        });
                    }
                    try {
                        List answers = executor.getExecutor().invokeAll(todo);
                        for (Future answer : answers) {
                            try {
                                answer.get();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (ExecutionException e) {
                                e.getCause().printStackTrace();
                            }
                        }
                    }
                    catch (InterruptedException answers) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void init(IGraphics g) {
        }

        public abstract void draw(IGraphics var1, Shape var2, Row var3);
    }
}

