/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplotmatrix;

import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ScatterPlotMatrixComponent;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixModel;
import com.macrofocus.high_d.scatterplotmatrix.ScatterPlotMatrixView;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import com.macrofocus.rubberband.RubberBand;
import com.macrofocus.rubberband.SimpleRubberBand;

public abstract class AbstractScatterPlotMatrixView<Component, Color, Row, Column>
implements ScatterPlotMatrixView<Component, Color, Row, Column> {
    private ScatterPlotMatrixModel<Color, Row, Column> model;
    private final RubberBand rubberBand;
    private boolean isSelectionMode = true;
    protected final MutableProperties<ScatterPlotMatrixView.PropertyType> properties = new EnumProperties(ScatterPlotMatrixView.PropertyType.class);
    private final PropertiesListener<ScatterPlotMatrixView.PropertyType> propertiesListener = new PropertiesListener<ScatterPlotMatrixView.PropertyType>(){

        public void propertyChanged(ScatterPlotMatrixView.PropertyType name, PropertyEvent event) {
            AbstractScatterPlotMatrixView.this.createOverplots();
        }
    };
    private final OrderListener orderListener = new OrderListener(){

        public void orderChanged(OrderEvent event) {
            AbstractScatterPlotMatrixView.this.refresh();
        }

        public void orderVisibility(OrderEvent event) {
            AbstractScatterPlotMatrixView.this.refresh();
        }

        public void orderAdded(OrderEvent event) {
            AbstractScatterPlotMatrixView.this.refresh();
        }

        public void orderRemoved(OrderEvent event) {
            AbstractScatterPlotMatrixView.this.refresh();
        }
    };

    public AbstractScatterPlotMatrixView(CPColorFactory<Color> factory) {
        this.properties.createProperty((Object)ScatterPlotMatrixView.PropertyType.ShowTiming, (Object)Boolean.FALSE);
        this.properties.createProperty((Object)ScatterPlotMatrixView.PropertyType.ShowFiltered, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)ScatterPlotMatrixView.PropertyType.Antialiasing, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)ScatterPlotMatrixView.PropertyType.Rendering, (Object)CPCanvas.Rendering.Density);
        this.properties.createProperty((Object)ScatterPlotMatrixView.PropertyType.ColorTheme, (Object)new LightColorTheme(factory));
        this.properties.addPropertiesListener(this.propertiesListener);
        this.rubberBand = new SimpleRubberBand();
    }

    @Override
    public ScatterPlotMatrixModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(ScatterPlotMatrixModel model) {
        if (this.model != null) {
            this.model.getAxisGroupModel().getAxisOrder().removeOrderListener(this.orderListener);
        }
        this.model = model;
        this.getScatterPlotMatrixComponent().setModel(model);
        if (this.model != null) {
            this.model.getAxisGroupModel().getAxisOrder().addOrderListener(this.orderListener);
        }
    }

    @Override
    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    @Override
    public void setSelectionMode(boolean value) {
        this.isSelectionMode = value;
    }

    protected abstract void refresh();

    protected abstract ScatterPlotMatrixComponent getScatterPlotMatrixComponent();

    @Override
    public MutableProperty<ColorTheme<Color>> getColorTheme() {
        return this.properties.getProperty((Object)ScatterPlotMatrixView.PropertyType.ColorTheme);
    }

    @Override
    public void setColorTheme(MutableProperty<ColorTheme<Color>> colorTheme) {
        this.properties.replaceProperty((Object)ScatterPlotMatrixView.PropertyType.ColorTheme, colorTheme);
    }

    @Override
    public MutableProperty<Boolean> getShowTiming() {
        return this.properties.getProperty((Object)ScatterPlotMatrixView.PropertyType.ShowTiming);
    }

    @Override
    public MutableProperty<Boolean> getShowFiltered() {
        return this.properties.getProperty((Object)ScatterPlotMatrixView.PropertyType.ShowFiltered);
    }

    @Override
    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        this.properties.replaceProperty((Object)ScatterPlotMatrixView.PropertyType.ShowFiltered, showFiltered);
    }

    @Override
    public MutableProperty<Boolean> getAntialiasing() {
        return this.properties.getProperty((Object)ScatterPlotMatrixView.PropertyType.Antialiasing);
    }

    @Override
    public void setAntialiasing(MutableProperty<Boolean> antialiasing) {
        this.properties.replaceProperty((Object)ScatterPlotMatrixView.PropertyType.Antialiasing, antialiasing);
    }

    @Override
    public MutableProperty<CPCanvas.Rendering> getRendering() {
        return this.properties.getProperty((Object)ScatterPlotMatrixView.PropertyType.Rendering);
    }

    @Override
    public void setRendering(MutableProperty<CPCanvas.Rendering> rendering) {
        this.properties.replaceProperty((Object)ScatterPlotMatrixView.PropertyType.Rendering, rendering);
    }

    protected void createOverplots() {
        if (this.getScatterPlotMatrixComponent() != null) {
            this.getScatterPlotMatrixComponent().createOverplots();
            this.getScatterPlotMatrixComponent().scheduleUpdate();
        }
    }

    @Override
    public RubberBand getRubberBand() {
        return this.rubberBand;
    }
}

