/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.statistics;

import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.statistics.PresentationStatisticsDataFrame;
import com.macrofocus.high_d.statistics.Statistics;
import com.macrofocus.high_d.statistics.StatisticsDataFrame;
import com.macrofocus.high_d.table.ShowFilteredDataFrame;
import com.macrofocus.high_d.table.Table;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;

public abstract class AbstractStatistics<Component, Color, Format, R, C, V>
implements Statistics<Component, Color, Format, R, C, V> {
    private final CPFactory factory;
    private final ColorMapFactory<Color> colorMapFactory;
    protected final Table<Component, Color, Format, StatisticsDataFrame.Stat, C, Object> table;

    public AbstractStatistics(CPFactory factory, ColorMapFactory<Color> colorMapFactory) {
        this.factory = factory;
        this.colorMapFactory = colorMapFactory;
        this.table = this.createTable();
    }

    @Override
    public void setModel(DataFrame dataFrame, Visual<Color, R, C> visual, AxisGroupModel<StatisticsDataFrame.Stat, C> axisGroupModel) {
        StatisticsDataFrame statisticsDataFrame = new StatisticsDataFrame(this.factory, dataFrame, visual.getProbing(), visual.getSelection(), visual.getFilter(), visual.getColorMapping(), visual.getColoring());
        PresentationStatisticsDataFrame<StatisticsDataFrame.Stat, C> annotationDataFrame = new PresentationStatisticsDataFrame<StatisticsDataFrame.Stat, C>(this.factory, statisticsDataFrame, axisGroupModel);
        SimpleVisualObjects visualObjects = new SimpleVisualObjects(annotationDataFrame);
        SimpleVisual v = new SimpleVisual((VisualObjects)visualObjects, visual.getAnnotationProbing(), visual.getAnnotationSelection(), (MutableColorMapping)new SimpleColorMapping(this.colorMapFactory, annotationDataFrame));
        this.table.setModel(new ShowFilteredDataFrame(annotationDataFrame, annotationDataFrame, this.table.getShowFiltered()), v, axisGroupModel);
    }

    protected abstract Table<Component, Color, Format, StatisticsDataFrame.Stat, C, Object> createTable();

    @Override
    public MutableProperty<ColorTheme<Color>> getColorTheme() {
        return this.table.getColorTheme();
    }

    @Override
    public void setColorTheme(MutableProperty<ColorTheme<Color>> colorTheme) {
        this.table.setColorTheme(colorTheme);
    }

    public Component getNativeComponent() {
        return (Component)this.table.getNativeComponent();
    }
}

