/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.tablelens;

import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.tablelens.TableLensController;
import com.macrofocus.high_d.tablelens.TableLensView;
import java.util.Collection;
import java.util.List;

public abstract class AbstractTableLensController<Component, Color, Row, Column>
implements TableLensController<Component, Color, Row, Column> {
    private TableLensView<Component, Color, Row, Column> view;
    private final boolean multipleSelectionEnabled = true;
    private final boolean selectOnPopupTrigger = false;
    private TableLensController.Mode mode = TableLensController.Mode.Selection;
    private final DefaultMouseListener mouseListener = new DefaultMouseListener();

    @Override
    public void setView(TableLensView<Component, Color, Row, Column> view) {
        if (this.view != null) {
            // empty if block
        }
        this.view = view;
        if (view != null) {
            view.addMouseListener(this.mouseListener);
            view.addMouseMotionListener(this.mouseListener);
        }
    }

    public TableLensView<Component, Color, Row, Column> getView() {
        return this.view;
    }

    @Override
    public TableLensController.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(TableLensController.Mode mode) {
        this.mode = mode;
    }

    private void removeFromSelection(Object observation) {
        this.getView().getModel().getSelection().setSelectedState(observation, false);
    }

    private void setSelection(Object observation) {
        if (observation != null) {
            this.getView().getModel().getSelection().setSelectedElements(new Object[]{observation});
        } else {
            this.getView().getModel().getSelection().clearSelection();
        }
    }

    private void addToSelection(Object observation) {
        this.getView().getModel().getSelection().setSelectedState(observation, true);
    }

    private void addToSelection(Collection<Object> newSelection) {
        this.getView().getModel().getSelection().setSelectedIterableState(newSelection, true);
    }

    public class DefaultMouseListener
    implements CPCanvas.MouseListener,
    CPCanvas.MouseMotionListener {
        private Point last;
        private Object selectOnRelease = null;
        private Point zoomOnRelease = null;
        private Point zoomingPoint = null;
        private Point pressedPoint = null;

        public void mouseClicked(CPCanvas.MouseEvent e) {
        }

        public void mousePressed(CPCanvas.MouseEvent event) {
            if (AbstractTableLensController.this.getView() != null) {
                this.pressedPoint = new Point(event.getX(), event.getY());
                Object bestrow = AbstractTableLensController.this.getView().getClosestRow(event.getX(), event.getY());
                switch (AbstractTableLensController.this.getMode()) {
                    case Selection: {
                        if (bestrow != null) {
                            if (!event.isMultipleSelectionKey()) {
                                if (AbstractTableLensController.this.getView().getModel().getSelection().isSelected(bestrow) && AbstractTableLensController.this.getView().getModel().getSelection().getSelectedCount() <= 1) break;
                                AbstractTableLensController.this.getView().getModel().getSelection().clearSelection();
                                AbstractTableLensController.this.getView().getModel().getSelection().setSelected(bestrow);
                                AbstractTableLensController.this.getView().setSelectionMode(AbstractTableLensController.this.getView().getModel().getSelection().isSelected(bestrow));
                                break;
                            }
                            AbstractTableLensController.this.getView().setSelectionMode(!AbstractTableLensController.this.getView().getModel().getSelection().isSelected(bestrow));
                            if (AbstractTableLensController.this.getView().isSelectionMode()) {
                                AbstractTableLensController.this.getView().getModel().getSelection().setSelectedState(bestrow, true);
                                break;
                            }
                            AbstractTableLensController.this.getView().getModel().getSelection().setSelectedState(bestrow, false);
                            break;
                        }
                        AbstractTableLensController.this.getView().getModel().getSelection().clearSelection();
                        break;
                    }
                    case Toggle: {
                        boolean selected = AbstractTableLensController.this.getView().getModel().getSelection().isSelected(bestrow);
                        AbstractTableLensController.this.getView().getModel().getSelection().setSelectedState(bestrow, !selected);
                        break;
                    }
                    case Filter: {
                        boolean filtered = AbstractTableLensController.this.getView().getModel().getFilter().isFilteredBy(bestrow, (Object)this);
                        AbstractTableLensController.this.getView().getModel().getFilter().setFiltered(bestrow, !filtered, (Object)this);
                    }
                }
            }
        }

        public void mouseReleased(CPCanvas.MouseEvent event) {
            if (AbstractTableLensController.this.getView() != null) {
                if (!event.isPopupTrigger()) {
                    switch (AbstractTableLensController.this.getMode()) {
                        case Selection: {
                            if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                                AbstractTableLensController.this.getView().getModel().getSelection().clearSelection();
                                AbstractTableLensController.this.addToSelection(this.selectOnRelease);
                                this.selectOnRelease = null;
                            }
                            if (this.zoomOnRelease != null) {
                                if (event.isLeftMouseButton()) {
                                    // empty if block
                                }
                                this.zoomOnRelease = null;
                            }
                            AbstractTableLensController.this.getView().getRubberBand().stopRubberBand();
                            break;
                        }
                        case Toggle: {
                            if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                                AbstractTableLensController.this.getView().getModel().getSelection().clearSelection();
                                AbstractTableLensController.this.addToSelection(this.selectOnRelease);
                                this.selectOnRelease = null;
                            }
                            if (this.zoomOnRelease != null) {
                                if (event.isLeftMouseButton()) {
                                    // empty if block
                                }
                                this.zoomOnRelease = null;
                            }
                            AbstractTableLensController.this.getView().getRubberBand().stopRubberBand();
                            break;
                        }
                    }
                }
                this.last = null;
            }
        }

        public void mouseEntered(CPCanvas.MouseEvent e) {
        }

        public void mouseExited(CPCanvas.MouseEvent e) {
            AbstractTableLensController.this.getView().getModel().getProbing().clearSelection();
        }

        public void mouseDragged(CPCanvas.MouseEvent event) {
            if (AbstractTableLensController.this.getView() != null && AbstractTableLensController.this.getView().getModel() != null) {
                Point point = new Point(event.getX(), event.getY());
                if (this.last != null) {
                    switch (AbstractTableLensController.this.getMode()) {
                        case Selection: {
                            boolean isAlreadySelected;
                            if (!event.isLeftMouseButton()) break;
                            if (event.isAltKeyDown() || event.isShiftKeyDown()) {
                                AbstractTableLensController.this.getView().getModel().getProbing().clearSelection();
                                if (!AbstractTableLensController.this.getView().getRubberBand().getRubberBand().isActive()) {
                                    AbstractTableLensController.this.getView().getRubberBand().startRubberBand(this.pressedPoint.x, this.pressedPoint.y);
                                }
                                AbstractTableLensController.this.getView().getRubberBand().stretchRubberBand(event.getX(), event.getY());
                                Rectangle2D rect = AbstractTableLensController.this.getView().getRubberBand().getRubberBandScreen();
                                if (rect == null) break;
                                List toSelect = AbstractTableLensController.this.getView().getRows(rect);
                                if (event.isMultipleSelectionKey()) {
                                    AbstractTableLensController.this.addToSelection((Object)toSelect);
                                } else {
                                    AbstractTableLensController.this.getView().getModel().getSelection().setSelectedIterable(toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            Object observation = AbstractTableLensController.this.getView().getClosestRow(point.x, point.y);
                            AbstractTableLensController.this.getView().getModel().getProbing().setSelected(observation);
                            this.selectOnRelease = null;
                            boolean bl = isAlreadySelected = AbstractTableLensController.this.getView().getModel().getSelection() != null && AbstractTableLensController.this.getView().getModel().getSelection().isSelected(observation);
                            if (!isAlreadySelected && !event.isMenuShortcutKeyDown()) {
                                AbstractTableLensController.this.getView().getModel().getSelection().clearSelection();
                            }
                            if (event.isMenuShortcutKeyDown()) {
                                AbstractTableLensController.this.addToSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            AbstractTableLensController.this.addToSelection(observation);
                        }
                    }
                }
                this.last = new Point(event.getX(), event.getY());
            }
        }

        public void mouseMoved(CPCanvas.MouseEvent event) {
            Object closest = AbstractTableLensController.this.getView().getClosestRow(event.getX(), event.getY());
            AbstractTableLensController.this.getView().getModel().getProbing().setSelected(closest);
        }
    }
}

