/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Area;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.Labeling;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.PreferredSize;
import com.treemap.crossplatform.TGraphics;
import java.util.ArrayList;
import java.util.List;
import jsinterop.annotations.JsType;

@JsType
public abstract class AbstractLabeling<N, Row, Column, Color, Font>
implements Labeling<N, Row, Column, Color, Font> {
    protected static final float SHARE_OF_ZOOM_FACTOR = 0.15f;
    protected static final float COLOR_SIMILARITY_THRESHOLD = 0.5f;

    @Override
    public Shape subtract(TreeMapModel<N, Row, Column, Color, Font> model, Shape shape, N node) {
        return shape;
    }

    @Override
    public double getTopSpace(TreeMapModel<N, Row, Column, Color, Font> model) {
        return 0.0;
    }

    @Override
    public double getLeftSpace(TreeMapModel<N, Row, Column, Color, Font> model) {
        return 0.0;
    }

    @Override
    public void paintLeaf(TGraphics<Color, Font> g2, Shape shape, Rectangle bounds, N node, TreeMapView view) {
        TreeMapField[] treeMapFieldArray;
        TreeMapModel treeMapModel = view.getModel();
        if (!treeMapModel.getFilter().isFiltered(node) && !treeMapModel.getSearch().isFiltered(node) && (treeMapFieldArray = treeMapModel.getSettings().getLabelTreeMapFields()) != null && treeMapFieldArray.length > 0) {
            int n2;
            int n3;
            int n4;
            Object n5 = treeMapModel.getParent(node);
            if (!treeMapModel.isRoot(n5)) {
                TreeMapFieldSettings treeMapFieldSettings = treeMapModel.getSettings().getFieldSettings(treeMapModel.getGroupByField(n5));
                n4 = bounds.y + (int)Math.round(treeMapFieldSettings.getLabeling().getTopHeaderSpacing(n5, node, view, treeMapModel));
            } else {
                n4 = bounds.y;
            }
            int n6 = n4;
            int n7 = treeMapFieldArray.length;
            List<TreeMapField> list = this.getTreeMapFieldsByVerticalAlignment(treeMapModel, treeMapFieldArray, 1);
            if (list != null) {
                n3 = this.paintFields(g2, shape, bounds, node, view, treeMapModel, list, true, n6);
                if (n3 > 0) {
                    n6 += n3;
                    n7 -= list.size();
                } else {
                    return;
                }
            }
            if (n7 > 0 && (list = this.getTreeMapFieldsByVerticalAlignment(treeMapModel, treeMapFieldArray, 0)) != null) {
                n3 = this.paintFields(g2, shape, bounds, node, view, treeMapModel, list, false, n4);
                if (n3 > 0) {
                    n2 = bounds.y + (bounds.height - n3) / 2;
                    if (n2 > n6) {
                        n6 = n2;
                    }
                    this.paintFields(g2, shape, bounds, node, view, treeMapModel, list, true, n6);
                    n6 += n3;
                    n7 -= list.size();
                } else {
                    return;
                }
            }
            if (n7 > 0 && (list = this.getTreeMapFieldsByVerticalAlignment(treeMapModel, treeMapFieldArray, 3)) != null) {
                n3 = this.paintFields(g2, shape, bounds, node, view, treeMapModel, list, false, n4);
                if (n3 > 0) {
                    n2 = bounds.y + (bounds.height - n3);
                    if (n2 > n6) {
                        n6 = n2;
                    }
                    this.paintFields(g2, shape, bounds, node, view, treeMapModel, list, true, n6);
                    n6 += n3;
                } else {
                    return;
                }
            }
        }
    }

    protected List<TreeMapField> getTreeMapFieldsByVerticalAlignment(TreeMapModel model, TreeMapField[] fields, int alignement) {
        ArrayList<TreeMapField> arrayList = null;
        for (TreeMapField treeMapField : fields) {
            if (model.getSettings().getFieldSettings(treeMapField).getLabelingVerticalAlignment() != alignement) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<TreeMapField>();
            }
            arrayList.add(treeMapField);
        }
        return arrayList;
    }

    protected int paintFields(TGraphics<Color, Font> g2, Shape shape, Rectangle bounds, N node, TreeMapView view, TreeMapModel<N, Row, Column, Color, Font> model, List<TreeMapField> fields, boolean paint, int y2) {
        int n2 = 0;
        for (TreeMapField treeMapField : fields) {
            double d2;
            Dimension dimension;
            EnhancedLabel enhancedLabel;
            if (!treeMapField.isValid()) continue;
            TreeMapFieldSettings<Color, Font> treeMapFieldSettings = model.getSettings().getFieldSettings(treeMapField);
            CPColor<Color> cPColor = treeMapFieldSettings.getLabelingEffectColor();
            CPColor<Color> cPColor2 = treeMapFieldSettings.getLabelingForeground();
            if (cPColor2 == null) continue;
            CPFont cPFont = treeMapFieldSettings.getLabelingFont();
            Boolean bl = treeMapFieldSettings.getLabelingShrinkTextToFitShape();
            Boolean bl2 = treeMapFieldSettings.getLabelingResizeTextToFitShape();
            if (!bl.booleanValue() && !bl2.booleanValue()) {
                EnhancedLabel enhancedLabel2;
                double d3;
                if (!(cPFont.getSize2D() <= (double)bounds.height) || bounds.width <= 4) continue;
                float f2 = view.getZoomFactor();
                CPFont cPFont2 = f2 != 1.0f ? ((d3 = cPFont.getSize2D() * (double)(1.0f + ((float)Math.sqrt(f2) - 1.0f) * 0.15f)) != cPFont.getSize2D() ? cPFont.deriveFontSize(d3) : cPFont) : cPFont;
                if (!(cPFont2.getSize2D() <= (double)bounds.height) || (enhancedLabel2 = view.getLabelRenderer().getTreeMapLabelRendererComponent(view, treeMapField, treeMapFieldSettings, node, new Dimension(bounds.width, bounds.height))) == null) continue;
                CPColor<Color> cPColor3 = model.getColor(node);
                if (cPColor == null && cPColor3 != null) {
                    cPColor2 = this.adjustLabelColor(treeMapFieldSettings, cPColor2, cPColor3);
                }
                enhancedLabel2.setFont(cPFont2);
                enhancedLabel2.setForeground(cPColor2);
                enhancedLabel2.setBackground(cPColor);
                PreferredSize preferredSize = g2.sizeLabel(enhancedLabel2, bounds.width, bounds.height);
                double d4 = preferredSize.getPreferredHeight();
                int n3 = y2 + n2;
                if (!((double)n3 + d4 <= (double)(bounds.y + bounds.height))) break;
                if (paint) {
                    Rectangle rectangle = AbstractLabeling.findEnclosedRectangle(shape, n3, (int)d4);
                    this.paintLabel(g2, node, treeMapField, enhancedLabel2, bounds, rectangle);
                }
                if (treeMapFieldSettings.getLabelingFloat().booleanValue()) continue;
                n2 = (int)((double)n2 + d4);
                continue;
            }
            if (bounds.width <= 5 || bounds.height <= 5 || !(bl2 != false && (double)bounds.height >= cPFont.getSize2D()) && !bl.booleanValue() || (enhancedLabel = view.getLabelRenderer().getTreeMapLabelRendererComponent(view, treeMapField, treeMapFieldSettings, node, new Dimension(bounds.width, bounds.height))) == null) continue;
            int n4 = enhancedLabel.getInsetRight() + enhancedLabel.getInsetLeft();
            int n5 = enhancedLabel.getInsetTop() + enhancedLabel.getInsetBottom();
            int n6 = bounds.width - n4;
            int n7 = bounds.height - n5;
            enhancedLabel.setFont(cPFont);
            CPColor<Color> cPColor4 = model.getColor(node);
            if (cPColor == null && cPColor4 != null) {
                cPColor2 = this.adjustLabelColor(treeMapFieldSettings, cPColor2, cPColor4);
            }
            enhancedLabel.setForeground(cPColor2);
            enhancedLabel.setBackground(cPColor);
            PreferredSize preferredSize = g2.sizeLabel(enhancedLabel, bounds.width, bounds.height);
            double d5 = 0.9;
            if (treeMapFieldSettings.getLabelingRendering() != EnhancedLabel.Rendering.WordWrap) {
                float f3;
                float f4;
                float f5;
                boolean bl3 = true;
                if (bl3) {
                    dimension = preferredSize.getPreferredSize();
                    f5 = (float)bounds.getWidth() / (float)dimension.getWidth();
                    f4 = (float)bounds.getHeight() / (float)dimension.getHeight();
                    f3 = Math.min(f5, f4);
                    d2 = cPFont.getSize2D() * (double)f3 * 0.9;
                } else {
                    dimension = preferredSize.getPreferredSize();
                    f5 = (float)(dimension.getWidth() - (double)n4);
                    f4 = (float)(dimension.getHeight() - (double)n5);
                    f3 = (float)n6 / f5;
                    float f6 = (float)n7 / f4;
                    float f7 = Math.min(f3, f6);
                    d2 = Math.floor(cPFont.getSize2D() * (double)f7 * 1.0);
                }
            } else {
                d2 = g2.fitTextInsideRectangle(enhancedLabel, preferredSize, cPFont, (Rectangle2D)bounds, 0.9, bl2);
            }
            if (!bl.booleanValue()) {
                d2 = Math.max(cPFont.getSize2D(), d2);
            }
            if (!bl2.booleanValue()) {
                d2 = Math.min(cPFont.getSize2D(), d2);
            }
            if (!(d2 >= 5.0)) continue;
            CPFont cPFont3 = cPFont.deriveFontSize(d2);
            enhancedLabel.setFont(cPFont3);
            if (treeMapFieldSettings.getLabelingRendering() != EnhancedLabel.Rendering.WordWrap) {
                // empty if block
            }
            dimension = preferredSize.getPreferredSize();
            if (paint) {
                int n8 = y2 + n2;
                Rectangle rectangle = AbstractLabeling.findEnclosedRectangle(shape, n8, dimension.height);
                this.paintLabel(g2, node, treeMapField, enhancedLabel, bounds, rectangle);
            }
            if (treeMapFieldSettings.getLabelingFloat().booleanValue()) continue;
            n2 += dimension.height;
        }
        return n2;
    }

    protected void paintLabel(TGraphics<Color, Font> g2, N node, TreeMapField<N, Column> field, EnhancedLabel<Color, Font> label, Rectangle bounds, Rectangle drawingArea) {
        g2.paintLabel(label, drawingArea.x, drawingArea.y, drawingArea.width, drawingArea.height);
    }

    protected CPColor<Color> adjustLabelColor(TreeMapFieldSettings<Color, Font> settings, CPColor<Color> foreground, CPColor<Color> nodeColor) {
        return settings.getLabelingContrastEnhancement().adjustLabelColor(foreground, nodeColor);
    }

    protected static Rectangle findEnclosedRectangle(Shape shape, int y2, int height) {
        if (shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)shape;
            Rectangle rectangle2 = new Rectangle(rectangle.x, y2, rectangle.width, height);
            return rectangle2;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            Rectangle rectangle = new Rectangle((int)Math.ceil(rectangle2D.getX()), y2, (int)Math.floor(rectangle2D.getWidth()), height);
            return rectangle;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d2 = 0.001;
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), (double)y2, rectangle2D.getWidth(), 0.001);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(rectangle2D.getX(), (double)(y2 + height) - 0.001, rectangle2D.getWidth(), 0.001);
        Area area = new Area(shape);
        Area area2 = new Area((Shape)double_);
        area2.intersect(area);
        Area area3 = new Area((Shape)double_2);
        area3.intersect(area);
        Rectangle2D rectangle2D2 = area2.getBounds2D();
        Rectangle2D rectangle2D3 = area3.getBounds2D();
        int n2 = (int)Math.ceil(Math.max(rectangle2D2.getMinX(), rectangle2D3.getMinX()));
        int n3 = (int)Math.floor(Math.min(rectangle2D2.getMaxX(), rectangle2D3.getMaxX())) - n2;
        Rectangle rectangle = new Rectangle(n2, y2, n3, height);
        return rectangle;
    }

    @Override
    public double getTopHeaderSpacing(N parent, N node, TreeMapView view, TreeMapModel model) {
        return 0.0;
    }

    public static double getArea(Shape shape) {
        if (shape != null) {
            return AbstractLabeling.a(AbstractLabeling.getPoints(shape));
        }
        return 0.0;
    }

    private static double a(Point2D[] point2DArray) {
        int n2 = point2DArray.length;
        double d2 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = (i2 + 1) % n2;
            d2 += point2DArray[i2].getX() * point2DArray[n3].getY();
            d2 -= point2DArray[i2].getY() * point2DArray[n3].getX();
        }
        return d2 /= 2.0;
    }

    public static Point2D calcCenterOfMass(Point2D[] points) {
        int n2 = points.length;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = AbstractLabeling.a(points);
        double d5 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = (i2 + 1) % n2;
            d5 = points[i2].getX() * points[n3].getY() - points[n3].getX() * points[i2].getY();
            d2 += (points[i2].getX() + points[n3].getX()) * d5;
            d3 += (points[i2].getY() + points[n3].getY()) * d5;
        }
        d5 = 1.0 / (d4 *= 6.0);
        return new Point2D.Double(d2 *= d5, d3 *= d5);
    }

    public static Point2D getCentroid(Shape shape) {
        Point2D[] point2DArray = AbstractLabeling.getPoints(shape);
        return AbstractLabeling.calcCenterOfMass(point2DArray);
    }

    public static Point2D[] getPoints(Shape shape) {
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>(32);
        PathIterator pathIterator = shape.getPathIterator();
        int n2 = -1;
        while (!pathIterator.isDone()) {
            objectArray = new double[6];
            switch (pathIterator.currentSegment(objectArray)) {
                case 0: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    ++n2;
                    break;
                }
                case 1: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    break;
                }
                case 2: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    arrayList.add(new Point2D.Double(objectArray[2], objectArray[3]));
                    break;
                }
                case 3: {
                    arrayList.add(new Point2D.Double(objectArray[0], objectArray[1]));
                    arrayList.add(new Point2D.Double(objectArray[2], objectArray[3]));
                    arrayList.add(new Point2D.Double(objectArray[4], objectArray[5]));
                    break;
                }
                case 4: {
                    if (n2 < 0) break;
                    arrayList.add((Point2D)arrayList.get(n2));
                }
            }
            pathIterator.next();
        }
        objectArray = new Point2D[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }
}

