/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.tagcloud.HierarchicalBoundingBox;
import com.treemap.tagcloud.HierarchicalBoundingBoxPair;
import java.util.Stack;

public class HierarchicalBoundingBoxes {
    private final HierarchicalBoundingBox a;

    public HierarchicalBoundingBoxes(Shape shape, int depth, double sizeFactor) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        double d2 = double_.getWidth() / double_.getHeight();
        double d3 = d2 > 1.0 ? double_.getWidth() * (sizeFactor - 1.0) : double_.getHeight() * (sizeFactor - 1.0);
        double_ = new Rectangle2D.Double(double_.getX() - d3 / 2.0, double_.getY() - d3 / 2.0, double_.getWidth() + d3, double_.getHeight() + d3);
        this.a = new HierarchicalBoundingBox((Rectangle2D)new Rectangle2D.Double(double_.getX(), double_.getY(), double_.getWidth(), double_.getHeight()), shape, depth - 1);
    }

    public boolean intersects(HierarchicalBoundingBoxes otherBoundingBoxes) {
        HierarchicalBoundingBox hierarchicalBoundingBox = this.a;
        HierarchicalBoundingBox hierarchicalBoundingBox2 = otherBoundingBoxes.a;
        if (hierarchicalBoundingBox.getBounds().intersects(hierarchicalBoundingBox2.getBounds())) {
            Stack<HierarchicalBoundingBoxPair> stack = new Stack<HierarchicalBoundingBoxPair>();
            stack.push(new HierarchicalBoundingBoxPair(this.a, otherBoundingBoxes.a));
            do {
                HierarchicalBoundingBox[] hierarchicalBoundingBoxArray = !hierarchicalBoundingBox.isLeaf() ? hierarchicalBoundingBox.getChildren() : new HierarchicalBoundingBox[]{hierarchicalBoundingBox};
                HierarchicalBoundingBox[] hierarchicalBoundingBoxArray2 = !hierarchicalBoundingBox2.isLeaf() ? hierarchicalBoundingBox2.getChildren() : new HierarchicalBoundingBox[]{hierarchicalBoundingBox2};
                for (HierarchicalBoundingBox hierarchicalBoundingBox3 : hierarchicalBoundingBoxArray) {
                    if (hierarchicalBoundingBox3 == null) continue;
                    for (HierarchicalBoundingBox hierarchicalBoundingBox4 : hierarchicalBoundingBoxArray2) {
                        if (hierarchicalBoundingBox4 == null || !hierarchicalBoundingBox3.getBounds().intersects(hierarchicalBoundingBox4.getBounds())) continue;
                        if (hierarchicalBoundingBox3.isLeaf() && hierarchicalBoundingBox4.isLeaf()) {
                            return true;
                        }
                        stack.push(new HierarchicalBoundingBoxPair(hierarchicalBoundingBox3, hierarchicalBoundingBox4));
                    }
                }
                HierarchicalBoundingBoxPair hierarchicalBoundingBoxPair = (HierarchicalBoundingBoxPair)stack.pop();
                hierarchicalBoundingBox = hierarchicalBoundingBoxPair.getThisBox();
                hierarchicalBoundingBox2 = hierarchicalBoundingBoxPair.getOtherBox();
            } while (!stack.isEmpty());
        }
        return false;
    }

    public void setTranslation(double xPos, double yPos) {
        this.a.setTranslation(xPos, yPos);
    }
}

