/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.ButtonEvent;
import com.macrofocus.button.ButtonListener;
import com.macrofocus.button.ButtonModel;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AbstractButtonModel
implements ButtonModel {
    private boolean isStateOn = false;
    private boolean isEnabled = true;
    private Vector buttonListeners = new Vector();

    @Override
    public void setSelected(Object source) {
        this.fireButtonSelected(new ButtonEvent(source, this));
    }

    @Override
    public void doSelect(Object source, boolean state) {
        if (this.isStateOn != state) {
            this.setStateOn(source, state);
            this.setSelected(source);
        }
    }

    @Override
    public void setStateOn(Object source, boolean state) {
        if (this.isStateOn != state) {
            this.isStateOn = state;
            this.fireButtonStateChanged(new ButtonEvent(source, this));
        }
    }

    @Override
    public boolean isStateOn() {
        return this.isStateOn;
    }

    @Override
    public void setEnabled(Object source, boolean isEnabled) {
        if (this.isEnabled != isEnabled) {
            this.isEnabled = isEnabled;
            this.fireButtonEnabledChanged(new ButtonEvent(source, this));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void addButtonListener(ButtonListener listener) {
        this.buttonListeners.addElement(listener);
    }

    @Override
    public void removeButtonListener(ButtonListener listener) {
        this.buttonListeners.removeElement(listener);
    }

    private void fireButtonSelected(ButtonEvent event) {
        Enumeration enumeration = this.buttonListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ButtonListener)enumeration.nextElement()).buttonSelected(event);
        }
    }

    private void fireButtonStateChanged(ButtonEvent event) {
        Enumeration enumeration = this.buttonListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ButtonListener)enumeration.nextElement()).buttonStateChanged(event);
        }
    }

    private void fireButtonEnabledChanged(ButtonEvent event) {
        Enumeration enumeration = this.buttonListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((ButtonListener)enumeration.nextElement()).buttonEnabledChanged(event);
        }
    }
}

